<?php
/**
 * @package Tc Shortcode Generator
 * @author themescreative http://www.themescreative.com
 * @copyright Copyright (c) 2010 - 2014 themescreative
 * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
 */
defined('_JEXEC') or die;

$tc_shortcodes = array();

//Button
$tc_shortcodes['button'] = array( 
    'type'=>'general', 
    'title'=>'Button', 
    'attr'=>array(

        'size'=>array(
            'type'=>'select', 
            'title'=> 'Button Size', 
            'values'=>array(
                ''=>'Default',
                'small'=>'Small',
                'large' =>'Large',
                'mini' =>'Mini'
            )
        ),

        'type'=>array(
            'type'=>'select', 
            'title'=> 'Button Type', 
            'values'=>array(
                'default'=>'Default',
                'primary'=>'Primary',
                'success'=>'Success',
                'info'  =>'Info',
                'warning'=>'Warning',
                'danger'=>'Danger',
                'link'=>'Link',
            )
        ),

        'link'=>array(
            'type'=>'text', 
            'title'=>'Button Link',
            'placeholder'=>'eg. http://www.themescreative.com'
        ),

        'target'=>array(
            'type'=>'select', 
            'title'=> 'Target', 
            'values'=>array(
                ''=>'Same Window',
                '_blank'=>'New Window'
            )
        ),

        'content'=>array(
            'type'=>'text', 
            'title'=>'Button Text',
            'content'=>true
        )
    )
);

//Icon
$tc_shortcodes['icon'] = array(
    'type'=>'general', 
    'title'=>'Icon', 
    'attr'=>array(
        'name'=>array(
            'type'=>'icons', 
            'title'=> 'Select Icon'
        ),

        'size'=>array(
            'type'=>'text', 
            'title'=> 'Size'
        ),

        'color'=>array(
            'type'=>'text', 
            'title'=>'Color',
            'placeholder'=>'#rrggbb'
        ),

        'class'=>array(
            'type'=>'text', 
            'title'=> 'CSS Class'
        )
    )
);

//Divider
$tc_shortcodes['divider'] = array(
    'type'=>'general', 
    'title'=>'Divider', 
    'attr'=>array(

        'margin_top'=>array(
            'type'=>'text', 
            'title'=>'Margin Top',
            'value'=>'18px'
        ),

        'margin_bottom'=>array(
            'type'=>'text', 
            'title'=>'Margin Bottom',
            'value'=>'18px'
        ),

        'border'=>array(
            'type'=>'text', 
            'title'=>'Border Top',
            'value'=>'1px solid #ccc'
        )
    )
);

//Columns
$tc_shortcodes['row'] = array( 
    'type'=>'repetable', 
    'title'=>'Column',
    'attr'=>array(
        'id'=>array(
            'type'=>'text', 
            'title'=> 'Row ID'
        ),

        'class'=>array(
            'type'=>'text', 
            'title'=> 'Row Class'
        ),

        'repetable_item'=>array(
            'type'=>'repetable', 
            'title'=>'Repetable', 
            'attr'=>array(

                'class'=>array(
                    'type'=>'select', 
                    'title'=>'Column Width',
                    'values'=>array(
                        'span12'=>'Column 1',
                        'span6'=>'Column 1/2',
                        'span4'=>'Column 1/3',
                        'span3'=>'Column 1/4'
                    )
                ),

                'content'=>array(
                    'type'=>'textarea', 
                    'title'=>'Content',
                    'content'=>true
                )
            )
        )
    )
);

//alert
$tc_shortcodes['alert'] = array( 
    'type'=>'general', 
    'title'=>'Alert',
    'attr'=>array(

        'type'=>array(
            'type'=>'select', 
            'title'=>'Alert Type', 
            'values'=>array(
                ''=>'Default',
                'success'=>'Success',
                'info'=>'Info',
                'warning'=>'Warning',
                'danger'=>'Danger'
            )
        ),

        'close'=>array(
            'type'=>'select', 
            'title'=> 'Close Button', 
            'values'=>  array(
                'yes'=>'Yes',
                'no'=>'No'
            )
        ),

        'content'=>array(
            'type'=>'textarea',
            'title'=>'Content',
            'content'=>true
        )
    )
);

//progressbar
$tc_shortcodes['progressbar'] = array( 
    'type'=>'general', 
    'title'=>'Progress Bar',
    'attr'=>array(
        'type'=>array(
            'type'=>'select', 
            'title'=>'Type', 
            'values'=>array(
                'primary'=>'Primary',
                'success'=>'Success',
                'info'=>'Info',
                'warning'=>'Warning',
                'danger'=>'Danger'
            )
        ),

        'bar'=>array(
            'type'=>'text', 
            'title'=>'Progress',
            'value'=>'50%'
        ),

        'striped'=>array(
            'type'=>'select', 
            'title'=>'Striped',
            'values'=>array(
                'no'=>'No',
                'yes'=>'Yes'
            )
        ),

        'active'=>array(
            'type'=>'select', 
            'title'=>'active',
            'values'=>array(
                'no'=>'No',
                'yes'=>'Yes'
            )
        ),

        'text'=>array(
            'type'=>'text', 
            'title'=>'Text'
        )
    )
);

//Tab
$tc_shortcodes['tab'] = array( 
    'type'=>'repetable', 
    'title'=>'Tab',
    'attr'=>array(
        'id'=>array(
            'type'=>'text', 
            'title'=> 'CSS ID',
            'value'=>'tab'
        ),

        'class'=>array(
            'type'=>'text', 
            'title'=> 'CSS Class'
        ),

        'button'=>array(
            'type'=>'select', 
            'title'=> 'Button Style', 
            'values'=> array(
                'nav-tabs'=>'Nav Tabs',
                'nav-pills'=>'Nav Pills'
            )
        ),

        'repetable_item'=>array(
            'type'=>'repetable', 
            'title'=> 'Repetable', 
            'attr'=>  array(
                'title'=>array(
                    'type'=>'text', 
                    'title'=>'Title',
                    'value'=>'Tab Title'
                ),

                'content'=>array(
                    'type'=>'textarea', 
                    'title'=>'Content',
                    'value'=>'Tab Content.',
                    'content'=>true
                )
            )
        )
    )
);

//Accordion
$tc_shortcodes['accordion'] = array( 
    'type'=>'repetable', 
    'title'=>'Accordion',
    'attr'=>array(
        'id'=>array(
            'type'=>'text', 
            'title'=> 'CSS ID',
            'value'=>'accordion1'
        ),

        'repetable_item'=>array(
            'type'=>'repetable', 
            'title'=> 'Repetable', 
            'attr'=>  array(
                'title'=>array(
                    'type'=>'text', 
                    'title'=> 'Title',
                    'value'=> 'Accordion Title'
                ),
                'content'=>array(
                    'type'=>'textarea', 
                    'title'=>'Content',
                    'value'=>'Accordion Content.',
                    'content'=>true
                )  
            )
        )
    )
);

//Gallery
$tc_shortcodes['gallery'] = array( 
    'type'=>'repetable', 
    'title'=>'Gallery',
    'attr'=>array(
        'columns'=>array(
            'type'=>'text', 
            'title'=> 'Columns',
            'value'=>'3'
        ),

        'modal'=>array(
            'type'=>'select', 
            'title'=> 'Modal',
            'values'=>array(
                'yes'=>'Yes',
                'no'=>'No'
            )
        ),

        'filter'=>array(
            'type'=>'select', 
            'title'=> 'Tag Filter',
            'values'=>array(
                'yes'=>'Yes',
                'no'=>'No'
            )
        ),

        'repetable_item'=>array(
            'type'=>'repetable', 
            'title'=> 'Repetable', 
            'attr'=>  array(
                'src'=>array(
                    'type'=>'text', 
                    'title'=> 'Image Source'
                ),
                'tag'=>array(
                    'type'=>'text', 
                    'title'=> 'Tags'
                ),
                'content'=>array(
                    'type'=>'textarea', 
                    'title'=>'Content',
                    'content'=>true
                )  
            )
        )
    )
);


//Carousel
$tc_shortcodes['carousel'] = array( 
    'type'=>'repetable', 
    'title'=>'Carousel',
    'attr'=>array(

        'repetable_item'=>array(
            'type'=>'repetable', 
            'title'=> 'Repetable', 
            'attr'=>  array(
                'content'=>array(
                    'type'=>'textarea', 
                    'title'=>'Content',
                    'value'=>'<img style="border: 0;" src="images/...." alt="" /><div class="carousel-caption">Caption title here</div>',
                    'content'=>true
                )
            )
        )
    )
);

//Testimonial
$tc_shortcodes['testimonial'] = array( 
    'type'=>'general', 
    'title'=>'Testimonial', 
    'attr'=>array(

        'name'=>array(
            'type'=>'text', 
            'title'=>'Name',
            'value' => 'John Doe'
        ),

        'designation'=>array(
            'type'=>'text', 
            'title'=>'Designation'
        ),

        'email'=>array(
            'type'=>'text', 
            'title'=>'Email',
            'value'=>'email@email.com'
        ),

        'url'=>array(
            'type'=>'text', 
            'title'=>'Url'
        ),

        'content'=>array(
            'type'=>'textarea',
            'title'=> 'Testimonial',
            'content'=>true
        )
    ) 
);


//Blockquotes
$tc_shortcodes['blockquotes'] = array( 
    'type'=>'general', 
    'title'=>'Blockquotes', 
    'attr'=>array(

        'content'=>array(
            'type'=>'textarea',
            'title'=> 'Blockquotes',
            'content'=>true
        )
    ) 
);

//Map
$tc_shortcodes['tcmap'] = array( 
    'type'=>'general', 
    'title'=>'Map', 
    'attr'=>array(

        'lat'=>array(
            'type'=>'text', 
            'title'=>'Latitude',
            'value' => '-34.397'
        ),

        'lng'=>array(
            'type'=>'text', 
            'title'=>'Longitude',
            'value' => '150.644'
        ),

        'maptype'=>array(
            'type'=>'select', 
            'title'=>'Email',
            'values'=> array(
                'ROADMAP'=>'ROADMAP',
                'SATELLITE'=>'SATELLITE',
                'HYBRID'=>'HYBRID',
                'TERRAIN'=>'TERRAIN'
            )
        ),

        'height'=>array(
            'type'=>'text', 
            'title'=>'Url',
            'value'=>200
        ),

        'zoom'=>array(
            'type'=>'text',
            'title'=>'Zoom',
            'value'=>8
        )
    ) 
);

//Video
$tc_shortcodes['tcvideo'] = array( 
    'type'=>'general', 
    'title'=>'Video', 
    'attr'=>array(

        'height'=>array(
            'type'=>'text', 
            'title'=>'Height',
            'value' => 281
        ),

        'url'=>array(
            'type'=>'text', 
            'title'=>'Video URL',
            'placeholder'=>'Youtube/Vimeo full URL. eg. http://www.youtube.com/watch?v=vb2eObvmvdI',
            'content'=>true
        )
    ) 
);

//Typography

//Dropcap
$tc_shortcodes['dropcap'] = array(
    'type'=>'general', 
    'title'=>'Dropcap', 
    'attr'=>array(
        'content'=>array(
            'type'=>'textarea',
            'title'=>'Content',
            'content'=>true
        )
    )
);

//Blocknumber
$tc_shortcodes['blocknumber'] = array(
    'type'=>'general', 
    'title'=>'Blocknumber', 
    'attr'=>array(
        'text'=>array(
            'type'=>'text', 
            'title'=>'Number',
            'value' => '01'
        ),

        'background'=>array(
            'type'=>'text', 
            'title'=>'Background',
            'value' => '#000'
        ),

        'color'=>array(
            'type'=>'text', 
            'title'=>'Color',
            'value' => '#666'
        ),

        'type'=>array(
            'type'=>'select', 
            'title'=>'Type',
            'values' =>array(
                ''=>'Default',
                'rounded'=>'Rounded',
                'circle'=>'Circle'
            )
        ),

        'content'=>array(
            'type'=>'textarea',
            'title'=>'Content',
            'content'=>true
        )
    )
);

//Block
$tc_shortcodes['block'] = array(
    'type'=>'general', 
    'title'=>'Block', 
    'attr'=>array(
        'background'=>array(
            'type'=>'text', 
            'title'=>'Background',
            'value' => 'transparent'
        ),

        'color'=>array(
            'type'=>'text', 
            'title'=>'Color',
            'value' => '#666'
        ),
        
        'padding'=>array(
            'type'=>'text', 
            'title'=>'Padding',
            'value' => '15px'
        ),

        'border'=>array(
            'type'=>'text', 
            'title'=>'Border',
            'value' => '0'
        ),

        'type'=>array(
            'type'=>'select', 
            'title'=>'Type',
            'values' =>array(
                ''=>'Default',
                'rounded'=>'Rounded',
                'circle'=>'Circle'
            )
        ),

        'content'=>array(
            'type'=>'textarea',
            'title'=>'Content',
            'placeholder'=>'Block content.',
            'content'=>true
        )
    )
);

//Bubble
$tc_shortcodes['bubble'] = array(
    'type'=>'general', 
    'title'=>'Bubble', 
    'attr'=>array(
        'author'=>array(
            'type'=>'text', 
            'title'=>'Author',
            'value' => 'Bill'
        ),

        'background'=>array(
            'type'=>'text', 
            'title'=>'Background',
            'value' => '#fafafa'
        ),

        'color'=>array(
            'type'=>'text', 
            'title'=>'Color'
        ),
        
        'padding'=>array(
            'type'=>'text', 
            'title'=>'Padding',
            'value' => '10px'
        ),

        'border'=>array(
            'type'=>'text', 
            'title'=>'Border',
            'value' => '0'
        ),

        'type'=>array(
            'type'=>'select', 
            'title'=>'Type',
            'values' =>array(
                ''=>'Default',
                'rounded'=>'Rounded',
                'circle'=>'Circle'
            )
        ),

        'content'=>array(
            'type'=>'textarea',
            'title'=>'Content',
            'content'=>true
        )
    )
);
