<?php
/**

 * @package  mod_ju_articleslider
 *
 * @copyright   Copyright (C) 2005 - 2015 joomla2you.com. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 */

// no direct access
defined('_JEXEC') or die ('Restricted access');

class JFormFieldItems extends JFormField
{

	var $type = 'items';

	function getInput()
	{
    
    $fieldName = $this->name.'[]';

		$doc = JFactory::getDocument();
		$doc->addStyleSheet(JURI::root(true).'/modules/mod_ju_articleslider/assets/css/admin.css');
		$doc->addScript(JURI::root(true).'/modules/mod_ju_articleslider/assets/js/jquery-ui-1.8.24.custom.min.js');
		$doc->addScriptDeclaration("
		    var jQuery = jQuery.noConflict();
				function jSelectArticle_jform_params_item(id, title, object) {
					var exists = false;
					jQuery('#jpelement_list_items_added input').each(function(){
							if(jQuery(this).val()==id){
								alert('".JText::_('MOD_JU_CONTENT_SLIDER_THE_SELECTED_ITEM_IS_ALREADY_IN_THE_LIST')."');
								exists = true;
							}
					});
					if(!exists){
						var container = jQuery('<li/>').appendTo(jQuery('#jpelement_list_items_added'));
						var iconremove = jQuery('<span style=\"color: #bd362f;\" class=\"icon-cancel\"></span>').appendTo(container);
						iconremove.click(function(){jQuery(this).parent('li').remove();});
						var span = jQuery('<span/>',{'class':'handle'}).html(title).appendTo(container);
						var input = jQuery('<input/>',{value:id, type:'hidden', name:'".$fieldName."'}).appendTo(container);
						jQuery('#jpelement_list_items_added').sortable('refresh');
						alert('".JText::_('MOD_JU_CONTENT_SLIDER_ITEM_ADDED_IN_THE_LIST', true)."');
					}
				}
				
				jQuery(document).ready(function(){
					jQuery('#jpelement_list_items_added').sortable({
						containment: '#jpelement_list_items_added',
						items: 'li',
						handle: 'span.handle'
					});
					jQuery('body').css('overflow-y', 'scroll');
					jQuery('#jpelement_list_items_added .icon-cancel').click(function(){
						jQuery(this).parent().remove();
					});
				});
		");

		$current = array();
		if (is_string($this->value) && !empty($this->value)) $current[] = $this->value;
		if (is_array($this->value)) $current = $this->value;

		$output = '<ul id="jpelement_list_items_added">';
		foreach ($current as $id)
		{
		    $row = JTable::getInstance('content');
		    $row->load($id);
		    $output .= '<li><span style="color: #bd362f;" class="icon-cancel"></span><span class="handle">'.$row->title.'</span><input type="hidden" value="'.$row->id.'" name="'.$fieldName.'"/></li>';
		}
		$output .= '</ul>';

		return $output;
  }
}