<?php
/**

 * @package  mod_ju_articleslider
 *
 * @copyright   Copyright (C) 2005 - 2015 joomla2you.com. All rights reserved.
 * @license     GNU General Public License version 2 or later.
 */

// no direct access
defined('_JEXEC') or die ('Restricted access');

class JFormFieldItem extends JFormField
{

	var $type = 'item';

	function getInput()

    {
        $mainframe = JFactory::getApplication();
        $db = JFactory::getDBO();
        $doc = JFactory::getDocument();       
        $fieldName = $this->name;        
        $item = JTable::getInstance('content');
        if ($this->value)
        {
            $item->load($this->value);
        }
        else
        {
            $item->title = JText::_('MOD_JU_CONTENT_SLIDER_SELECT_AN_ITEM');
        }

        $doc->addScriptDeclaration("
    		function jSelectArticle_".$this->id."(id, title, catid, object) {
    			document.getElementById('".$this->name."' + '_id').value = id;
    			document.getElementById('".$this->name."' + '_name').value = title;
    			if(typeof(window.parent.SqueezeBox.close=='function')){
    				window.parent.SqueezeBox.close();
    			}
    			else {
    				document.getElementById('sbox-window').close();
    			}
    		}
		");
        
       	$link	= 'index.php?option=com_content&amp;view=articles&amp;layout=modal&amp;tmpl=component&amp;function=jSelectArticle_'.$this->id;

		if (isset($this->element['language']))
		{
			$link .= '&amp;forcedLanguage='.$this->element['language'];
		}
        JHTML::_('behavior.modal', 'a.modal');
        
            $html = '<span class="input-append">
            <input type="text" id="'.$this->name.'_name" value="'.htmlspecialchars($item->title, ENT_QUOTES, 'UTF-8').'" disabled="disabled" />
            <a class="modal btn" title="'.JText::_('MOD_JU_CONTENT_SLIDER_SELECT_AN_ITEM').'"  href="'.$link.'" rel="{handler: \'iframe\', size: {x: 700, y: 450}}"><i class="icon-file"></i>'.JText::_('MOD_JU_CONTENT_SLIDER_SELECT').'</a>
            <input type="hidden" class="required modal-value" id="'.$this->name.'_id" name="'.$fieldName.'" value="'.( int )$this->value.'" />
            </span>';
        return $html;
    }
}