<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

class MenuModelMenu extends JModelLegacy {
	function loadCategory($params = null) {
		$app = JFactory::getApplication();
		$id = 0;
		if (is_null($params)) {
			$params = $app->getParams();
			$cids = (array)$params->get('category_id');
			if ($id = $app->input->getInt('id') and !in_array($id, $cids)) {
				$params->set('category_id', array($id));
			}
		}
		$category = $this->getTable('category');
		$ids = $params->get('category_id');
		if ($cid = $id or (is_array($ids) and count($ids) == 1 and $cid = $ids[0])) {
			$category->load($cid);
		}
		return $category;
	}
	function loadList($params = null) {
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		if (is_null($params)) {
			$params = $app->getParams();
			if ($id = $app->input->getInt('id')) {
				$params->set('category_id', array($id));
			}
		}

		$where = array(
			'm.published = 1',
			'c.published = 1'
		);

		if ($buff = $app->input->getString('search')) {
			$where[] = 'm.name LIKE \'%'.$db->escape($buff).'%\'';
		}

		$cids = (array)$params->get('category_id');
		$cats = array();
		$tree = fwFoodMenuHelper::loadCategoriesTree($cids);
		if ($tree) {
			foreach ($tree as $row) {
				$row->_items = array();
				$cats[] = $row;
			}
		}

		if ($cids) {
			JArrayHelper::toInteger($cids, 0);
			if ($app->input->getInt('wosubcats')) {
				$where[] = 'm.category_id IN ('.implode($cids).')';
			} elseif (!in_array(0, $cids)) {
				$where[] = 'm.category_id IN ('.implode(',', fwFoodMenuHelper::getCategoriesIdBelow($cats, $cids)).')';
			}
		}

		$app->triggerEvent('onCollectMenuListWhere', array('com_fwfoodmenu', $params, &$where));
        $extras = $app->triggerEvent('onGetMenuListExtraFields', array('com_fwfoodmenu'));

		$db->setQuery('
SELECT
    m.*,
	c.parent,
	c.name AS _category_name,
	c.alias AS _category_alias,
	c.description AS _category_descr,
	\'\' AS _prices
    '.implode('', $extras).'
FROM
    #__fwfoodmenu_menu AS m
    LEFT JOIN #__fwfoodmenu_category AS c ON m.category_id = c.id
WHERE
	'.implode(' AND ', $where).'
ORDER BY
	c.parent,
	c.ordering,
	c.name,
	m.ordering'
		);
		if ($list = $db->loadObjectList()) {
			$ids = array();
			foreach ($list as $i=>$row) {
				$ids[] = $row->id;
				$list[$i]->_prices = array();
				$list[$i]->params = new JRegistry($row->params);
			}
			$db->setQuery('SELECT id, menu_id, name, special_price, price FROM `#__fwfoodmenu_menu_price` WHERE menu_id IN ('.implode(',', $ids).') ORDER BY ordering');
			if ($buff = $db->loadObjectList()) {
				foreach ($buff as $row) {
					$key = array_search($row->menu_id, $ids);
					$row->_price = fwFoodMenuHelper::formatPrice(($row->special_price>0)?$row->special_price:$row->price);
					$list[$key]->_prices[] = $row;
				}
			}
			$app->triggerEvent('onCalculateMenuListExtraFields', array('com_fwfoodmenu', &$list, $ids));
			$buff = $this->fillCategories($tree, $list);
			foreach ($buff as $i=>$row) {
				$cats[$i]->_items = fwFoodMenuHelper::straightenTree($row);
			}
		} else {
			foreach ($cats as $i=>$cat) {
				$cats[$i]->_items = fwFoodMenuHelper::straightenTree($cat);
			}
		}
		return $cats;
	}

	function fillCategories($cats, $list) {
		foreach ($cats as $i=>$cat) {
			$cats[$i]->_items = array();
			foreach ($list as $row) {
				if ($row->category_id == $cat->id) {
					$cats[$i]->_items[] = $row;
				}
			}
			if (!empty($cat->_children)) {
				$cats[$i]->_children = $this->fillCategories($cats[$i]->_children, $list);
			}
		}
		return $cats;
	}
}
