<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2019 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 */

defined('JPATH_BASE') or die;

$list = $displayData['list'];
$pages = $list['pages'];

$options = new JRegistry($displayData['options']);

$showLimitBox   = $options->get('showLimitBox', true);
$showPagesLinks = $options->get('showPagesLinks', true);
$showLimitStart = $options->get('showLimitStart', true);

// Calculate to display range of pages
$currentPage = 1;
$range = 1;
$step = 5;

if (!empty($pages['pages']))
{
	foreach ($pages['pages'] as $k => $page)
	{
		if (!$page['active'])
		{
			$currentPage = $k;
		}
	}
}

if ($currentPage >= $step)
{
	if ($currentPage % $step === 0)
	{
		$range = ceil($currentPage / $step) + 1;
	}
	else
	{
		$range = ceil($currentPage / $step);
	}
}
?>

<div class="uk-text-center uk-margin">
<?php if ($showLimitBox) : ?>
	<div class="limit uk-float-right">
		<?php echo JText::_('JGLOBAL_DISPLAY_NUM') . $list['limitfield']; ?>
	</div>
<?php endif; ?>

<?php if ($showPagesLinks && (!empty($pages))) : ?>
	<div class="uk-button-group">
		<?php
			echo fwFoodMenuHelper::loadTemplate('pagination.link', array_merge($displayData, $pages['start']));
			echo fwFoodMenuHelper::loadTemplate('pagination.link', array_merge($displayData, $pages['previous'])); ?>
		<?php foreach ($pages['pages'] as $k => $page) : ?>

			<?php $output = fwFoodMenuHelper::loadTemplate('pagination.link', array_merge($displayData, $page)); ?>
			<?php if (in_array($k, range($range * $step - ($step + 1), $range * $step), true)) : ?>
				<?php if (($k % $step === 0 || $k === $range * $step - ($step + 1)) && $k !== $currentPage && $k !== $range * $step - $step) : ?>
					<?php $output = preg_replace('#(<a.*?>).*?(</a>)#', '$1...$2', $output); ?>
				<?php endif; ?>
			<?php endif; ?>

			<?php echo fwFoodMenuHelper::escPluginsOutput($output); ?>
		<?php endforeach; ?>
		<?php
			echo fwFoodMenuHelper::loadTemplate('pagination.link', array_merge($displayData, $pages['next']));
			echo fwFoodMenuHelper::loadTemplate('pagination.link', array_merge($displayData, $pages['end'])); ?>
	</div>
<?php endif; ?>

<?php if ($showLimitStart) : ?>
	<input type="hidden" name="<?php echo esc_attr($list['prefix']); ?>limitstart" value="<?php echo (int)$list['limitstart']; ?>" />
<?php endif; ?>
</div>