<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2019 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldFwFmLayout extends JFormField {
	var	$type = 'fwfmlayout';

	function getInput() {
		if (!defined('FWFM_COMPONENT_SITE')) {
			define('FWFM_COMPONENT_SITE', JPATH_SITE.'/components/com_fwfoodmenu');
		}
		require_once(FWFM_COMPONENT_SITE.'/helpers/helper.php');

		fwFoodMenuHelper::loadAdminStyles();

		$layouts = array();
		JFactory::getApplication()->triggerEvent('onGetFoodMenuLayouts', array('com_fwfoodmenu', &$layouts));

		ob_start();
		if ($layouts) {
			$name = str_replace(array('[', ']'), array('_', ''), $this->name);
			$is_module_params = (JFactory::getApplication()->input->getString('option')=='com_modules');
			$lang_source = $is_module_params?'MODMEALCATEGORY':'MENUPARAMS_MEAL';
?>
		<fieldset id="jform_<?php echo $name; ?>" class="uk-button-group radio">
<?php
			foreach ($layouts as $i=>$layout) {
				$id = $name.$layout;
				$active = ($this->value == $layout or (!$this->value and !$i));
?>
			<input type="radio" id="jform_<?php echo $id; ?>" name="<?php echo $this->name; ?>" value="<?php echo $layout; ?>"<?php if ($active) { ?> checked="checked"<?php } ?>>
			<label for="jform_<?php echo $id; ?>" class="uk-button<?php if ($active) { ?> active uk-button-success<?php } ?>" uk-tooltip="<?php echo JText::_('FWFM_DOC_ADMIN_'.$lang_source.'_LAYOUT_'.$layout.'_HINT'); ?>">
				<?php echo JText::_('FWFM_DOC_ADMIN_'.$lang_source.'_LAYOUT_'.$layout); ?>
			</label>
<?php
			}
?>
		</fieldset>
<?php
		} else {
?>
<div id="fwfmlayout"></div>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
	$('#fwfmlayout').closest('.control-group').hide();
	})(jQuery);
});
</script>
<?php
		}
		return ob_get_clean();
	}
}
