<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2019 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

JHTML::_('behavior.core');
JHTML::_('formbehavior.chosen');

JToolBarHelper::title(JText::_('FWFM_ADMIN_LANG_TOOLBAR_TITLE'), 'world');

fwfmButtonsHelper::custom('file-edit', '', 'FWFM_DOC_ADMIN_LANG_TOOLBAR_BTN_CORRECTTRANSLATIONS', 'translation', false);

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => JText::_('FWFM_DOC_ADMIN_LANG'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_LANG_HINT'),
	'view' => $this
), JPATH_COMPONENT);
?>
<form action="index.php?option=com_fwfoodmenu&view=translation" method="post" class="form-validate" name="adminForm" id="adminForm">
    
    <div class="fwa-separate-box">
        <table class="table table-striped fwfm-admin-languages-list">
            <thead>
                <tr>
                    <th><?php echo JText::_('FWFM_LANGUAGE'); ?></th>
                    <th><?php echo JText::_('FWFM_INSTALLATION_STATUS'); ?></th>
                    <th><?php echo JText::_('FWFM_ACTION'); ?></th>
                </tr>
            </thead>
            <tbody>
<?php
$langs = json_decode($this->params->get('langs_data'));
foreach ($this->languages as $lang) {
    $remote_md5 = empty($langs->{$lang->tag})?'':$langs->{$lang->tag};
    $path = FWFM_LANGUAGE_ADMINISTRATOR.'/language/'.$lang->tag.'/'.$lang->tag.'.com_fwfoodmenu.ini';

    $installed = file_exists($path);
    $local_md5 = $installed?md5_file($path):'';
    $uptodate = ($lang->tag == 'en-GB' or ($remote_md5 and $remote_md5 == $local_md5));

    $button_enabled = true;
    $button_text = $button_class = '';
    if ($uptodate) {
        $button_enabled = false;
        $button_text = 'FWFM_TRANSLATION_UPTODATE';
        $button_class = 'secondary';
    } elseif ($remote_md5 and $local_md5 and $remote_md5 != $local_md5) {
        $button_text = 'FWFM_TRANSLATION_REINSTALL';
        $button_class = 'success fwfm-lang-reinstall';
    } elseif (!$local_md5 and $remote_md5) {
        $button_text = 'FWFM_TRANSLATION_INSTALL';
        $button_class = 'success fwfm-lang-install';
    } else {
        if ($this->params->get('translation_requested_'.$lang->tag)) {
            $button_enabled = false;
            $button_text = 'FWFM_TRANSLATION_REQUESTED';
            $button_class = 'warning';
        } else {
            $button_text = 'FWFM_TRANSLATION_REQUEST';
            $button_class = 'warning fwfm-lang-request';
        }
    }
?>
                <tr data-id="<?php echo $lang->tag; ?>">
                    <td><img class="uk-margin-right" src="<?php echo JURI::root(true); ?>/media/mod_languages/images/<?php echo str_replace('-', '_', strtolower($lang->tag)); ?>.gif" /> <?php echo $lang->name; ?></td>
                    <td>
                        <span class=""><?php echo JText::_('FWFM_'.($installed?'INSTALLED':'NOT_INSTALLED')); ?></span>
                        <?php if ($installed) : ?>
                        <div class="small uk-margin-small-top text-<?php if ($uptodate) { ?>muted<?php } else { ?>danger<?php } ?>"><?php echo JText::_('FWFM_'.($uptodate?'':'NOT').'UPTODATE'); ?></div>
                        <?php endif; ?>
                    </td>
                    <td>
                        <button type="button" class="uk-button uk-button-<?php echo $button_class; ?>"<?php if (!$button_enabled) { ?> disabled="disabled"<?php } ?>><?php echo JText::_($button_text); ?></button>
                        <div class="small uk-margin-small-top text-muted"><?php echo JText::_($button_text.'_hint'); ?></div>
                    </td>
                </tr>
<?php
}
?>
            </tbody>
        </table>
    </div>

	<input type="hidden" name="task" value="" />
	<input type="hidden" name="boxchecked" value="0" />
</form>
<script>
document.addEventListener('DOMContentLoaded', function() {
    (function($) {
        Joomla.submitbutton = function(pressbutton) {
            if (pressbutton == 'translation') {
                location = 'index.php?option=com_fwfoodmenu&view=translation&layout=translation';
            }
        }
        $('#adminForm').on('click', '.fwfm-lang-request', function() {
            var $btn = $(this).attr('disabled', true).html('<?php echo esc_js(JText::_('FWFM_TRANSLATION_REQUESTED')); ?>');
            $btn.next().html('<?php echo esc_js(JText::_('FWFM_TRANSLATION_REQUESTED_HINT')); ?>');
            var $wait = $('<div uk-spinner></div>');
            $btn.after($wait);
            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'translation',
                    layout: 'lang_request',
                    lang: $btn.closest('tr').data('id')
                }
            }).done(function(data) {
                $wait.remove();
                if (data.result) {
                    $btn.removeClass('uk-button-primary uk-button-success uk-button-warning fwfm-lang-request').addClass('uk-button-secondary').html('<?php echo esc_js(JText::_('FWFM_TRANSLATION_UPTODATE')); ?>');
                    $btn.next().html('');
                    $btn.closest('td').prev().find('span').removeClass('uk-text-danger').addClass('uk-text-success');
                }
                if (data.msg) {
                    fwfm_alert(data.msg);
                }
            });
        });
        $('#adminForm').on('click', '.fwfm-lang-reinstall', function() {
            var $btn = $(this).attr('disabled', true);
            var $wait = $('<div uk-spinner></div>');
            $btn.after($wait);
            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'translation',
                    layout: 'lang_reinstall',
                    lang: $btn.closest('tr').data('id')
                }
            }).done(function(data) {
                $wait.remove();
                if (data.result) {
                    $btn.removeClass('uk-button-primary uk-button-success uk-button-warning fwfm-lang-request').addClass('uk-button-secondary').html('<?php echo esc_js(JText::_('FWFM_TRANSLATION_UPTODATE')); ?>');
                    $btn.next().html('');
                    $btn.closest('td').prev().find('span').removeClass('uk-text-danger').addClass('uk-text-success');
                } else {
                    $btn.attr('disabled', false);
                }
                if (data.msg) {
                    fwfm_alert(data.msg);
                }
            });
        });
        $('#adminForm').on('click', '.fwfm-lang-install', function() {
            var $btn = $(this).attr('disabled', true);
            var $wait = $('<div uk-spinner></div>');
            $btn.after($wait);
            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'translation',
                    layout: 'lang_request',
                    lang: $btn.closest('tr').data('id')
                }
            }).done(function(data) {
                $wait.remove();
                if (data.result) {
                    $btn.removeClass('uk-button-primary uk-button-success uk-button-warning fwfm-lang-request').addClass('uk-button-secondary').html('<?php echo esc_js(JText::_('FWFM_TRANSLATION_UPTODATE')); ?>');
                    $btn.next().html('');
                    $btn.closest('td').prev().find('span').removeClass('uk-text-danger').addClass('uk-text-success');
                } else {
                    $btn.attr('disabled', false);
                }
                if (data.msg) {
                    fwfm_alert(data.msg);
                }
            });
        });
    })(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);

