<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

JHTML::_('behavior.core');
JHTML::_('formbehavior.chosen');

JToolBarHelper::title(JText::_('FWFM_ADMIN_SETTINGS_TOOLBAR_TITLE'), 'settings');
fwfmButtonsHelper::apply('apply', 'FWFM_DOC_ADMIN_SETTINGS_TOOLBAR_BTN_SAVE');
fwFoodMenuHelper::colorpicker();

$long = $this->object->params->get('location_longitude');
$lat = $this->object->params->get('location_latitude');
if (!is_numeric($long)) $long = 0;
if (!is_numeric($lat)) $lat = 0;

JHTML::script('https://maps.google.com/maps/api/js?key='.esc_url($this->params->get('map_key')));

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => JText::_('FWFM_DOC_ADMIN_SETTINGS'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_SETTINGS_HINT'),
	'view' => $this
), JPATH_COMPONENT);
?>
<div class="fwa-separate-box">
<form id="adminForm" name="adminForm" method="post" action="index.php?option=com_fwfoodmenu&view=settings" enctype="multipart/form-data">
<?php
if (fwFoodMenuHelper::pluginEnabled('multilingual')) {
?>
	<div class="fwa-separate-box fwa-filter-bar uk-grid-small" uk-grid>
<?php
	$this->app->triggerEvent('onShowLanguageFilters', array('com_fwfoodmenu', $this));
?>
	</div>
<?php
}
?>
	<ul uk-tab>
		<li class="uk-active" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_HINT')); ?>">
			<a href="#fwfm-settings-general">
				<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL'); ?>
			</a>
		</li>
		<li uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_HINT')); ?>">
			<a href="#fwfm-settings-design">
				<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN'); ?>
			</a>
		</li>
		<li uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_ORDERS_HINT')); ?>">
			<a href="#fwfm-settings-orders">
				<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_ORDERS'); ?>
			</a>
		</li>
		<li uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DELIVERY_HINT')); ?>">
			<a href="#fwfm-settings-delivery">
				<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DELIVERY'); ?>
			</a>
		</li>
	</ul>
    <div class="uk-switcher">
        <div id="fwfm-settings-general">
            <div>
				<div class="uk-child-width-1-2@m fwa-mb-cardbox" uk-grid>
					<div>
						<div class="uk-card">
							<div class="uk-card-header">
								<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON'); ?></h4>
							</div>
							<div class="uk-card-body">
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_UIKIT'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_UIKIT_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTMLfwView::radioGroup('config[do_not_load_uikit]', (int)$this->object->params->get('do_not_load_uikit'), array(
											'wrapper_class' => 'uk-margin-right',
											'buttons' => array(array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('JYES'),
												'value' => 0
											), array(
												'active_class' => 'uk-button-danger',
												'title' => JText::_('JNO'),
												'value' => 1
											))
										)); ?>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_MAINCOLOR'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_MAINCOLOR_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<div class="uk-flex">
											<input class="uk-input minicolors w-100" value="<?php echo $this->escape($this->object->params->get('main_color')); ?>" id="fwfm-main_color" type="text" name="config[main_color]">
											<button class="uk-button uk-button-outline-secondary" type="button"><i uk-icon="paint-brush"></i></button>
										</div>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_BGMAINCOLOR'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_BGMAINCOLOR_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<div class="uk-flex">
											<input class="uk-input minicolors w-100" value="<?php echo $this->escape($this->object->params->get('bgmain_color')); ?>" id="fwfm-bgmain_color" type="text" name="config[bgmain_color]">
											<button class="uk-button uk-button-outline-secondary" type="button"><i uk-icon="paint-brush"></i></button>
										</div>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_SECONDARYCOLOR'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_SECONDARYCOLOR_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<div class="uk-flex">
											<input class="uk-input minicolors w-100" value="<?php echo $this->escape($this->object->params->get('secondary_color')); ?>" id="fwfm-secondary_color" type="text" name="config[secondary_color]">
											<button class="uk-button uk-button-outline-secondary" type="button"><i uk-icon="paint-brush"></i></button>
										</div>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_BGSECONDARYCOLOR'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_BGSECONDARYCOLOR_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<div class="uk-flex">
											<input class="uk-input minicolors w-100" value="<?php echo $this->escape($this->object->params->get('bgsecondary_color')); ?>" id="fwfm-bgsecondary_color" type="text" name="config[bgsecondary_color]">
											<button class="uk-button uk-button-outline-secondary" type="button"><i uk-icon="paint-brush"></i></button>
										</div>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_LINKCOLOR'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_LINKCOLOR_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<div class="uk-flex">
											<input class="uk-input minicolors w-100" value="<?php echo $this->escape($this->object->params->get('link_color')); ?>" id="fwfm-link_color" type="text" name="config[link_color]">
											<button class="uk-button uk-button-outline-secondary" type="button"><i uk-icon="paint-brush"></i></button>
										</div>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_GOOGLEFONT'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_GOOGLEFONT_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<input class="uk-input" value="<?php echo $this->object->params->get('google_font'); ?>" id="fwfm-google_font" type="text" name="config[google_font]">
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_GOOGLEHEADERFONT'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_GOOGLEHEADERFONT_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<input class="uk-input" value="<?php echo $this->object->params->get('google_font_head'); ?>" id="fwfm-google_font_head" type="text" name="config[google_font_head]">
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_FONT'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_FONT_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@m">
										<div class="uk-flex">
											<input class="uk-input" value="<?php echo (int)$this->object->params->get('font_size', 16); ?>" id="fwfm-font_size" type="number" name="config[font_size]">
											<span class="input-group-text" id="basic-addon2">px</span>
										</div>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_PRICEZEROS'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_PRICEZEROS_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTMLfwView::radioGroup('config[hide_ending_ziro]', (int)$this->object->params->get('hide_ending_ziro'), array(
											'wrapper_class' => 'uk-margin-right',
											'buttons' => array(array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_SHOW'),
												'value' => 0
											), array(
												'active_class' => 'uk-button-danger',
												'title' => JText::_('FWFM_HIDE'),
												'value' => 1
											))
										)); ?>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_ADDONS'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_COMMON_ADDONS_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTMLfwView::radioGroup('config[show_addons_menu_settings]', (int)$this->object->params->get('show_addons_menu_settings'), array(
											'wrapper_class' => 'uk-margin-right',
											'buttons' => array(array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_SHOW'),
												'value' => 1
											), array(
												'active_class' => 'uk-button-danger',
												'title' => JText::_('FWFM_HIDE'),
												'value' => 0
											))
										)); ?>
									</div>
								</div>
							</div>
						</div>

						<div class="uk-card">
							<div class="uk-card-header">
								<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCAL'); ?></h4>
							</div>
							<div class="uk-card-body">
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCAL_CURSYMBOL'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCAL_CURSYMBOL_HINT')); ?>"></i>
									</div>
									<div class="uk-width-auto">
										<input class="uk-input" value="<?php echo $this->object->params->get('currency'); ?>" id="fwfm-currency" type="text" name="config[currency]">
									</div>
									<div class="uk-width-auto">
										<?php echo JHTMLfwView::radioGroup('config[currency_after]', $this->object->params->get('currency_after'), array(
											'wrapper_class' => 'uk-margin-right',
											'buttons' => array(array(
												'active_class' => 'uk-button-info',
												'title' => JText::_('FWFM_SETTINGS_BEFORE'),
												'value' => 0
											), array(
												'active_class' => 'uk-button-default uk-button-warning',
												'title' => JText::_('FWFM_SETTINGS_AFTER'),
												'value' => 1
											))
										)); ?>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCAL_CURCODE'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCAL_CURCODE_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<input class="uk-input" value="<?php echo $this->object->params->get('currency_code'); ?>" id="fwfm-currency_code" type="text" name="config[currency_code]">
									</div>
								</div>
                                <div uk-grid>
                                	<div class="uk-width-2-5@s">
                                		<?php echo JText::_('FWFM_CURRENCY_SEPARATOR'); ?>
                                		<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo esc_attr(JText::_('FWFM_CURRENCY_SEPARATOR_DESCR')); ?>"></i>
                                	</div>
                                	<div class="uk-width-3-5@s">
<?php
if ($this->langs) {
	foreach ($this->langs as $lang) {
?>
                                		<div uk-grid>
                                			<div class="uk-width-2-5@s">
                                				<?php echo esc_html($lang->name); ?>:
                                			</div>
                                			<div class="uk-width-3-5@s">
                                				<?php echo JHTML::_('select.genericlist', array(
                                					JHTML::_('select.option', 'prime', JText::_('FWFM_CURRENCY_DELIMETER_PRIME'), 'id', 'name'),
                                					JHTML::_('select.option', 'point', JText::_('FWFM_CURRENCY_DELIMETER_POINT'), 'id', 'name'),
                                					JHTML::_('select.option', 'comma', JText::_('FWFM_CURRENCY_DELIMETER_COMMA'), 'id', 'name'),
                                					JHTML::_('select.option', 'space', JText::_('FWFM_CURRENCY_DELIMETER_SPACE'), 'id', 'name')
                                				), 'config[currency_delimeter_'.$lang->id.']', 'class="uk-select"', 'id', 'name', $this->object->params->get('currency_delimeter_'.$lang->id)); ?>
                                			</div>
                                		</div>
<?php
	}
}
?>
                                	</div>
                                </div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCAL_DATEFORMAT'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCAL_DATEFORMAT_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTML::_('select.genericlist', array(
											JHTML::_('select.option', 'm/d/Y', 'm/d/Y', 'id', 'name'),
											JHTML::_('select.option', 'd/m/Y', 'd/m/Y', 'id', 'name'),
											JHTML::_('select.option', 'd.m.Y', 'd.m.Y', 'id', 'name'),
											JHTML::_('select.option', 'Y-m-d', 'Y-m-d', 'id', 'name')
										), 'config[date_format]', ' class="uk-select"', 'id', 'name', $this->object->params->get('date_format', 'm/d/Y')); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div>
<?php
$this->app->triggerEvent('onShowSettingsGenegalExtraCards', array('com_fwfoodmenu', $this));
?>
					</div>
				</div>
			</div>
        </div>
        <div id="fwfm-settings-design">
			<div class="uk-child-width-1-2@l fwa-mb-cardbox uk-grid-small" uk-grid>
				<div>
					<div class="uk-card">
        				<div class="uk-card-header">
        					<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY'); ?></h4>
        					<div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_HINT'); ?></div>
        				</div>
        				<div class="uk-card-body">
        					<div uk-grid>
        						<div class="uk-width-2-5@s">
        							<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_THEME'); ?>
        							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_THEME_HINT')); ?>"></i>
        						</div>
        						<div class="uk-width-3-5@s">
        							<?php echo JHTML::_('select.genericlist', fwFoodMenuHelper::getThemesList(), 'config[template]', ' class="uk-select"', 'id', 'name', $this->object->params->get('template')); ?>
        						</div>
        					</div>
        					<div uk-grid>
        						<div class="uk-width-2-5@s">
        							<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_SHOWTITLE'); ?>
        							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_SHOWTITLE_HINT')); ?>"></i>
        						</div>
        						<div class="uk-width-3-5@s">
        							<?php echo JHTMLfwView::radioGroup('config[display_category_title]', $this->object->params->get('display_category_title', '1'), array(
        								'wrapper_class' => 'uk-margin-right',
        								'buttons' => array(array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('JYES'),
        									'value' => '1'
        								), array(
        									'active_class' => 'uk-button-danger',
        									'title' => JText::_('JNO'),
        									'value' => '0'
        								))
        							)); ?>
        						</div>
        					</div>
        					<div uk-grid>
        						<div class="uk-width-2-5@s">
        							<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_SHORTDESCRIPTION'); ?>
        							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_SHORTDESCRIPTION_HINT')); ?>"></i>
        						</div>
        						<div class="uk-width-3-5@s">
        							<?php echo JHTMLfwView::radioGroup('config[display_category_shortdescription]', $this->object->params->get('display_category_shortdescription', '1'), array(
        								'wrapper_class' => 'uk-margin-right',
        								'buttons' => array(array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_SHOW'),
        									'value' => '1'
        								), array(
        									'active_class' => 'uk-button-danger',
        									'title' => JText::_('FWFM_HIDE'),
        									'value' => '0'
        								))
        							)); ?>
        						</div>
        					</div>
        					<div uk-grid>
        						<div class="uk-width-2-5@s">
        							<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_POSITION'); ?>
        							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_POSITION_HINT')); ?>"></i>
        						</div>
        						<div class="uk-width-3-5@s">
        							<?php echo JHTMLfwView::radioGroup('config[category_descr_position]', $this->object->params->get('category_descr_position', 'top'), array(
        								'wrapper_class' => 'uk-margin-right',
        								'buttons' => array(array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_TOP'),
        									'value' => 'top'
        								), array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_LEFT'),
        									'value' => 'left'
        								), array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_RIGHT'),
        									'value' => 'right'
        								), array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_BOTTOM'),
        									'value' => 'bottom'
        								))
        							)); ?>
        						</div>
        					</div>
        					<div uk-grid>
        						<div class="uk-width-2-5@s">
        							<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_ALIGNMENT'); ?>
        							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_CATEGORY_ALIGNMENT_HINT')); ?>"></i>
        						</div>
        						<div class="uk-width-3-5@s">
        							<?php echo JHTMLfwView::radioGroup('config[category_text_alignment]', $this->object->params->get('category_text_alignment', 'left'), array(
        								'wrapper_class' => 'uk-margin-right',
        								'buttons' => array(array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_LEFT'),
        									'value' => 'left'
        								), array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_CENTER'),
        									'value' => 'center'
        								), array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_RIGHT'),
        									'value' => 'right'
        								))
        							)); ?>
        						</div>
        					</div>
<?php
$this->app->triggerEvent('onShowSettingsCategoryExtraFields', array('com_fwfoodmenu', $this));
?>
        				</div>
        			</div>
				</div>
				<div>
        			<div class="uk-card">
        				<div class="uk-card-header">
        					<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_MEALLAYOUT'); ?></h4>
        					<div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_MEALLAYOUT_HINT'); ?></div>
        				</div>
        				<div class="uk-card-body">
							<div uk-grid>
        						<div class="uk-width-2-5@s">
        							<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_MEALLAYOUT_MEALCONTENT'); ?>
        							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_DESIGN_SECTION_MEALLAYOUT_MEALCONTENT_HINT')); ?>"></i>
        						</div>
        						<div class="uk-width-3-5@s">
        							<?php echo JHTMLfwView::radioGroup('config[meal_text_alignment]', $this->object->params->get('meal_text_alignment', 'left'), array(
        								'wrapper_class' => 'uk-margin-right',
        								'buttons' => array(array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_LEFT'),
        									'value' => 'left'
        								), array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_CENTER'),
        									'value' => 'center'
        								), array(
        									'active_class' => 'uk-button-success',
        									'title' => JText::_('FWFM_RIGHT'),
        									'value' => 'right'
        								))
        							)); ?>
        						</div>
        					</div>
<?php
$this->app->triggerEvent('onShowSettingsMenuExtraFields', array('com_fwfoodmenu', $this));
?>
<?php /*
        					<div uk-grid>
        						<div class="uk-width-2-5@s">
        							<?php echo JText::_('FWFM_ALIGN_BY'); ?>
        							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_ALIGN_BY_DESCR')); ?>" title="<?php echo $this->escape(JText::_('FWFM_ALIGN_BY_TITLE')); ?>"></i>
        						</div>
        						<div class="uk-width-3-5@s">
        							<?php echo JHTMLfwView::radioGroup('config[align_by]', $this->object->params->get('align_by', 'meal'), array(
        								'wrapper_class' => 'uk-margin-right',
        								'buttons' => array(array(
        									'active_class' => 'uk-button-success',
        									'title' => 'meal',
        									'value' => JText::_('FWFM_MEALS')
        								), array(
        									'active_class' => 'uk-button-success',
        									'title' => 'category',
        									'value' => JText::_('FWFM_CATEGORIES')
        								))
        							)); ?>
        						</div>
        					</div>
*/ ?>
        				</div>
        			</div>
				</div>
            </div>
        </div>
        <div id="fwfm-settings-orders">
<?php
$this->app->triggerEvent('onShowSettingsExtraCardsRight', array('com_fwfoodmenu', $this));

?>
        </div>
        <div id="fwfm-settings-delivery">
            <div>
				<div class="uk-child-width-1-2@m fwa-mb-cardbox" uk-grid>
					<div>
						<div class="uk-card">
							<div class="uk-card-header">
								<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCATION'); ?></h4>
							</div>
							<div class="uk-card-body">
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCATION_PLACENAME'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCATION_PLACENAME_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<input class="uk-input" value="<?php echo $this->object->params->get('location_name'); ?>" id="fwfm-location_name" type="text" name="config[location_name]">
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCATION_PHONE'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCATION_PHONE_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<input class="uk-input" value="<?php echo $this->object->params->get('location_phone'); ?>" id="fwfm-location_phone" type="text" name="config[location_phone]">
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCATION_MAPKEY'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo esc_attr(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_GENERAL_SECTION_LOCATION_MAPKEY_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<input class="uk-input" value="<?php echo esc_attr($this->object->params->get('map_key')); ?>" id="fwfm-map_key" type="text" name="config[map_key]">
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_ADDONS_SECTION_ORDERONLINEDELIVERY_ADDRESS'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo esc_attr(JText::_('FWFM_DOC_ADMIN_SETTINGS_TAB_ADDONS_SECTION_ORDERONLINEDELIVERY_ADDRESS_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<div class="uk-flex">
											<input type="text" class="uk-input" name="config[location_address]" value="<?php echo esc_attr($this->object->params->get('location_address')); ?>" />
											<button type="button" class="uk-button uk-button-info fwfm-find-location"><?php echo JText::_('FWFM_LOCATE'); ?></button>
										</div>
										<input type="hidden" name="config[location_longitude]" value="<?php echo esc_attr($long); ?>" />
										<input type="hidden" name="config[location_latitude]" value="<?php echo esc_attr($lat); ?>" />
									</div>
								</div>
								<div id="fwfm-order-map" style="height:400px;width:100%;" class="mb-3"></div>
								<div class="uk-alert uk-alert-info"><?php echo JText::_('FWFM_LOCATION_MAP_HINT'); ?></div>
							</div>
						</div>
<?php
$this->app->triggerEvent('onShowSettingsLocationCards', array('com_fwfoodmenu', $this));
?>
					</div>
					<div>
<?php
$this->app->triggerEvent('onShowSettingsDeliveryCards', array('com_fwfoodmenu', $this));
?>
		            </div>
	            </div>
            </div>
        </div>
    </div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="oid" value="1" />
</form>
</div>
<script>
var fwfm_location_map, fwfm_location_marker;
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
    	var myLatlng = new google.maps.LatLng(<?php echo $lat; ?>, <?php echo $long; ?>);
    	var myOptions = {
    		zoom: 16,
    		center: myLatlng,
    		mapTypeId: google.maps.MapTypeId.ROADMAP,
    		scrollwheel: false
    	}
    	fwfm_location_map = new google.maps.Map(document.getElementById('fwfm-order-map'), myOptions);
    	fwfm_location_marker = new google.maps.Marker({
    		  position: myLatlng,
    		  map: fwfm_location_map,
    		  draggable: true
    	});
    	google.maps.event.addListener(fwfm_location_marker, 'dragend', function(event) {
    		var point = fwfm_location_marker.getPosition();
    		$('input[name="config[location_longitude]"]').val(point.lng().toFixed(6));
    		$('input[name="config[location_latitude]"]').val(point.lat().toFixed(6));
    	});
    	google.maps.event.addDomListener(window, "resize", function() {
    		var center = fwfm_location_map.getCenter();
    		google.maps.event.trigger(fwfm_location_map, "resize");
    		fwfm_location_map.setCenter(center);
    	});
        $('.fwfm-find-location').click(function() {
			var $inp = $('input[name="config[location_address]"]')
            var addr = $inp.val();
			if (addr == '') {
				$inp.focus();
			} else {
				var geocoder = new google.maps.Geocoder();
				geocoder.geocode({'address': addr}, function(results, status) {
					if (status == google.maps.GeocoderStatus.OK) {
						fwfm_location_map.setCenter(results[0].geometry.location);
						fwfm_location_marker.setPosition(results[0].geometry.location);
						google.maps.event.trigger(fwfm_location_marker, 'dragend');
					}
				});
			}
        });
	})(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);
?>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
		$('button:has(\'[uk-icon="paint-brush"]\')').click(function() {
			$(this).parent().find('input').focus();
		});
	})(jQuery);
});
</script>
