<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2021 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

if ($this->list) {
	$latest_version = '';
	$latest_type = '';
	foreach ($this->list as $row) {
		if ($latest_version != $row->version) {
			$latest_type = '';

			$buff = explode('.', $row->version);
			$type = JText::_('FWFM_MAINTENANCE');
			if (count($buff) == 3) {
				if ($buff[1] == 0 and $buff[0] == 0) {
					$type = JText::_('FWFM_MAJOR');
				} elseif ($buff[0] == 0) {
					$type = JText::_('FWFM_MINOR');
				} 
			}
			$qty = 0;
			foreach ($this->list as $subrow) {
				if ($subrow->version == $row->version) {
					$qty++;
				}
			}
			if ($latest_version) {
?>
</ul>
<?php
			}
?>
<div class="fws-changelog-version-header">
	<span class="fws-changelog-version-header-info">
		<?php echo JText::_('FWFM_VERSION'); ?> <?php echo $row->version; ?> (<span class="text-lowercase"><?php echo $type; ?></span>)
	</span>
	<?php echo JText::_('FWFM_RELEASED_ON'); ?> <?php echo JHTML::date($row->created, 'd F Y'); ?>, <?php echo $qty; ?> <?php echo JText::_('FWFM_MODIFICATIONS'); ?>
</div>
<?php
			$latest_version = $row->version;
		}
		if ($latest_type != $row->type) {
			if ($latest_type) {
?>
</ul>
<?php
			}
			$icon = '';
			switch ($row->type) {
				case 'bugfixes' :
				$icon = 'bug';
				break;
				case 'updates' :
				$icon = 'sync';
				break;
				case 'new_features' :
				$icon = 'star';
				break;
			}
?>
<div class="fws-changelog-version-section fws-changelog-section-<?php echo $row->type; ?>">
	<i uk-icon="<?php echo $icon; ?>"></i>
	<?php echo JText::_('FWFM_'.$row->type); ?>
</div>
<ul class="fws-changelog-version-list">
<?php
			$latest_type = $row->type;
		}
?>
					<li><i uk-icon="check"></i> <?php echo $row->descr; ?></li>
<?php
		
	}
}
