<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

JToolBarHelper::title(JText::_('FWFM_ADMIN_DATA_TOOLBAR_TITLE'), 'database');

JHTML::_('formbehavior.chosen');

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => JText::_('FWFM_DOC_ADMIN_DATA'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_DATA_HINT'),
	'view' => $this
), JPATH_COMPONENT);
?>
<div class="fwa-separate-box">
<ul uk-tab>
	<li class="uk-active">
		<a href="#fwfm-restore"><?php echo JText::_('FWFM_DOC_ADMIN_DATA_TAB_RESTORE'); ?></a>
	</li>
	<li>
		<a href="#fwfm-backup"><?php echo JText::_('FWFM_DOC_ADMIN_DATA_TAB_BACKUP'); ?></a>
	</li>
<?php
if ($this->plugins) {
?>
	<li>
		<a href="#fwfm-data"><?php echo JText::_('FWFM_ADMIN_DATA_TAB_ADDONS'); ?></a>
	</li>
<?php
}
?>
</ul>
<div class="uk-switcher">
	<div id="fwfm-restore">
		<div>
			<form action="index.php?option=com_fwfoodmenu&amp;view=data" method="post" name="adminForm">
				<div>
					<div>
						<div class="uk-card mb-0 w-100">
							<div class="uk-card-header">
								<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_DATA_TAB_RESTORE_RESTORE'); ?></h4>
								<div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_DATA_TAB_RESTORE_RESTORE_HINT'); ?></div>
								<div class="uk-card-subtitle"><em><?php echo JText::_('FWFM_ADMIN_DATA_TAB_RESTORE_RESTORE_HINT'); ?> <?php echo str_replace('\\', '/', JPATH_SITE); ?>/media/com_fwfoodmenu/backups</em></div>
							</div>
							<div class="uk-card-body">
								<div class="table-responsive">
								<table class="table">
									<tbody id="fwfm-import-files">
<?php
if ($this->backups) {
	foreach ($this->backups as $file) {
?>
										<tr>
											<td><a href="<?php echo JURI::root(true); ?>/media/com_fwfoodmenu/backups/<?php echo $file; ?>"><?php echo $file; ?></a></td>
											<td>
												<button type="button" class="uk-button uk-button-primary"><?php echo JText::_('FWFM_RESTORE'); ?></button>
												<button type="button" class="uk-button uk-button-danger"><?php echo JText::_('FWFM_DELETE'); ?></button>
											</td>
										</tr>
<?php
	}
}
?>
									</tbody>
								</table>
								</div>

								<div class="mt-5"><?php echo JText::_('FWFM_IMPORT_UPLOAD_HINT'); ?></div>
								<div class="uk-margin" uk-margin>
									<div uk-form-custom="target: true">
										<input type="file" id="fwfm-input-import" name="upload" />
										<input class="uk-input uk-form-width-medium" type="text" placeholder="<?php echo esc_attr(JText::_('FWFM_CHOOSE_FILE')); ?>" disabled>
									</div>
									<button type="button" class="uk-button uk-button-success" id="fwfm-import-upload"><i uk-icon="upload" class="uk-margin-small-right"></i><?php echo JText::_('FWFM_UPLOAD'); ?></button>
								</div>
								<div class=" uk-margin-top fwfm-data-import-result"></div>
								<?php echo JHTML::_('fwView.handleUploadButton', array(
									'button' => '#fwfm-import-upload',
									'input' => '#fwfm-input-import',
									'image' => '',
									'exts' => array('zip'),
									'layout' => 'backup_upload',
									'callback' => 'function(data) {
	$progress_bar.remove();
	$button.attr(\'disabled\', false);
	$input.next().html(\''.JText::_('FWFM_CHOOSE_FILE', false).'\');

	var $parent = $input.parent();
	var input_html = $parent.html();
	$parent.html(input_html);

	var $cont = $(\'#fwfm-import-files\');

	if (data.result) {
		$(\'.fwfm-data-import-result\').html(\''.JText::_('FWFM_EXPORT_FILE_CREATED', true).'\'+data.result);
		var $row = $(\'<tr>\\
	<td><a href="'.JURI::root(true).'/media/com_fwfoodmenu/backups/\'+data.result+\'">\'+data.result+\'</a></td>\\
	<td>\\
		<button type="button" class="uk-button uk-button-primary">'.JText::_('FWFM_RESTORE', true).'</button>\\
		<button type="button" class="uk-button uk-button-danger">'.JText::_('FWFM_DELETE', true).'</button>\\
	</td>\\
</tr>\');
		$(\'#fwfm-import-files\').append($row);
	}
	if (data.msg) fwfm_alert(data.msg);
}'
								)); ?>
							</div>
						</div>
					</div>
				</div>
                <input type="hidden" name="view" value="data" />
			</form>
		</div>
	</div>
	<div id="fwfm-backup">
		<div class="">
			<form action="index.php?option=com_fwfoodmenu&amp;view=data" method="post" name="adminForm">
				<div>
					<div>
						<div class="uk-card mb-0 w-100">
							<div class="uk-card-header">
								<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_DATA_TAB_BACKUP_BACKUP'); ?></h4>
								<div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_DATA_TAB_BACKUP_BACKUP_HINT'); ?></div>
								<div class="uk-card-subtitle"><em><?php echo JText::_('FWFM_ADMIN_DATA_TAB_BACKUP_BACKUP_HINT'); ?> <?php echo str_replace('\\', '/', JPATH_SITE); ?>/media/com_fwfoodmenu/backups</em></div>
							</div>
							<div class="uk-card-body">
								<div uk-grid>
									<label class="uk-width-2-5@s" for="fwfm-category-id">
										<?php echo JText::_('FWFM_DOC_ADMIN_DATA_TAB_BACKUP_CATEGORY'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_DATA_TAB_BACKUP_CATEGORY_HINT')); ?>"></i>
									</label>
									<div class="uk-width-3-5@s">
										<?php echo JHTML::_('fwfCategory.parent', null, 'cids[]', 'class="form-control advancedSelect" multiple="multiple"', null); ?>
									</div>
								</div>
								<div uk-grid>
									<label class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_DATA_TAB_BACKUP_OPTIONS'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_DATA_TAB_BACKUP_OPTIONS_HINT')); ?>"></i>
									</label>
									<div class="uk-width-3-5@s">
										<div class="form-group">
											<input type="checkbox" class="uk-checkbox" id="fwfm-pdata" name="pdata" value="1" checked="checked" disabled="disabled" />
											<label for="fwfm-pdata"><?php echo JText::_('FWFM_MENU_DATA'); ?></label>
										</div>
<?php
$this->app->triggerEvent('onShowExportFormExportExtraOptions', array('com_fwfoodmenu', $this));
?>
									</div>
								</div>
								<button type="button" id="fwfm-data-export" class="uk-button uk-button-success"><i uk-icon="upload" class="uk-margin-small-right"></i><?php echo JText::_('FWFM_BACKUP'); ?></button>
								<div class=" uk-margin-top fwfm-data-export-result"></div>
							</div>
						</div>
					</div>
				</div>
                <input type="hidden" name="view" value="data" />
			</form>
		</div>
	</div>
<?php
if ($this->plugins) {
?>
	<div id="fwfm-data">
		<div class="container-fluid fwa-main-body fwa-mb-cardbox">
			<div class="uk-card">
				<div class="uk-card-header">
					<h4 class="uk-card-title"><?php echo JText::_('FWFM_DATA_IMPORT_PLUGINS'); ?></h4>
					<div class="uk-card-subtitle"><?php echo JText::_('FWFM_DATA_IMPORT_PLUGINS_HINT'); ?></div>
				</div>
				<div class="uk-card-body">
					<div class="uk-child-width-1-2@l" uk-grid>
						<div>
<?php
	foreach ($this->plugins as $i=>$plugin) {
		if ($i and $i%2 == 0) {
?>
						</div>
						<div>
<?php
		}
		if ($plugin) {
?>
							<fieldset class="adminform">
								<?php echo $plugin; ?>
							</fieldset>
<?php
		}
	}
?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php
}
?>
</div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
	$('#fwfm-import-files').on('click', '.uk-button-primary', function() {
		var $row = $(this).closest('tr');
		var file = $(this).closest('td').prev().find('a').html();
		if (confirm('<?php echo JText::_('FWFM_ARE_YOU_SURE_BACKUP_RESTORE', true); ?> '+file)) {
			$('#fwfm-import-files').find('button').attr('disabled', true);
			fwfm_alert('<?php echo JText::_('FWFM_BACKUP_UNPACKING_AND_APPLYING', true); ?>');
			$.ajax({
				dataType: 'json',
				data: {
					format: 'json',
					view: 'data',
					layout: 'backup_restore',
					filename: file
				}
			}).done(function (data) {
				$('#fwfm-import-files').find('button').attr('disabled', false);
				if (data.msg) {
					fwfm_alert(data.msg);
				}
			});
		}
	}).on('click', '.uk-button-danger', function() {
		var $row = $(this).closest('tr');
		var file = $(this).closest('td').prev().find('a').html();
		if (confirm('<?php echo JText::_('FWFM_ARE_YOU_SURE_BACKUP_DELETE', true); ?> '+file)) {
			$row.find('button').attr('disabled', true);
			$.ajax({
				dataType: 'json',
				data: {
					format: 'json',
					view: 'data',
					layout: 'backup_delete',
					filename: file
				}
			}).done(function (data) {
				$row.find('button').attr('disabled', false);
				if (data.result) {
					$row.remove();
				}
				if (data.msg) {
					fwfm_alert(data.msg);
				}
			});
		}
	});
	$('#fwfm-data-export').click(function() {
		var $btn = $(this);
		var $form = $(this.form);

		if ($form.find('input:checked').length) {
			$btn.attr('disabled', true);
			fwfm_alert('<?php echo JText::_('FWFM_EXPORT_DATABASE_DATA', true); ?>');
			$.ajax({
				dataType: 'json',
				data: {
					format: 'json',
					view: 'data',
					layout: 'export_data',
					cids: $form.find('select[name="cids[]"]').val()
				}
			}).done(function(data) {
				if (data.result) {
					var images = $form.find('input[name="pimages"]:checked').length;
					var pdf = $form.find('input[name="ppdf"]:checked').length;
					fwfm_alert(images?'<?php echo JText::_('FWFM_ZIPPING_DATA_IMAGES', true); ?>':'<?php echo JText::_('FWFM_ZIPPING_DATA', true); ?>');
					$.ajax({
						dataType: 'json',
						data: {
							format: 'json',
							view: 'data',
							layout: 'store_export_data',
							images: images,
							pdf: pdf,
							cids: $form.find('select[name="cids[]"]').val(),
							folder: data.result
						}
					}).done(function(data) {
						$btn.attr('disabled', false);
						if (data.result) {
							fwfm_alert('<?php echo JText::_('FWFM_EXPORT_FILE_CREATED', true); ?> <a href="<?php echo JURI::root(true); ?>/media/com_fwfoodmenu/backups/'+data.result+'">'+data.result+'</a>');
							var $row = $('<tr>\
	<td><a href="<?php echo JURI::root(true); ?>/media/com_fwfoodmenu/backups/'+data.result+'">'+data.result+'</a></td>\
	<td>\
		<button type="button" class="uk-button uk-button-primary"><?php echo JText::_('FWFM_RESTORE', true); ?></button>\
		<button type="button" class="uk-button uk-button-danger"><?php echo JText::_('FWFM_DELETE', true); ?></button>\
	</td>\
</tr>');
							$('#fwfm-import-files').append($row);
						}
						if (data.msg) {
							fwfm_alert(data.msg);
						}
					});
				}
				if (data.msg) {
					fwfm_alert(data.msg);
				}
			});
		} else {
			fwfm_alert('<?php echo JText::_('FWFM_SELECT_WHAT_TO_EXPORT', true); ?>');
		}
	});
	})(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);
