<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

JHTML::_('behavior.core');
JHTML::_('formbehavior.chosen');
fwFoodMenuHelper::colorpicker();

JToolBarHelper::title(JText::_('FWFM_ADMIN_CATEGORYEDIT_TOOLBAR_TITLE'), 'folder');

fwfmButtonsHelper::apply('apply', 'FWFM_DOC_ADMIN_CATEGORYEDIT_TOOLBAR_BTN_SAVE');
fwfmButtonsHelper::save('save', 'FWFM_DOC_ADMIN_CATEGORYEDIT_TOOLBAR_BTN_SAVECLOSE');
fwfmButtonsHelper::save2New('save2new', 'FWFM_DOC_ADMIN_CATEGORYEDIT_TOOLBAR_BTN_SAVENEW');
fwfmButtonsHelper::save2Copy('save2copy', 'FWFM_DOC_ADMIN_CATEGORYEDIT_TOOLBAR_BTN_SAVECOPY');
fwfmButtonsHelper::cancel('cancel', 'FWFM_DOC_ADMIN_CATEGORYEDIT_TOOLBAR_BTN_CANCEL');

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => $this->object->id?JText::sprintf('FWFM_ADMIN_CATEGORYEDIT_EDIT', $this->object->name):JText::_('FWFM_ADMIN_CATEGORYEDIT_NEW'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_HINT'),
	'view' => $this), JPATH_COMPONENT);
$editor = fwFoodMenuHelper::getEditor();
?>
<form id="adminForm" name="adminForm" method="post" action="index.php?option=com_fwfoodmenu&view=category" enctype="multipart/form-data">
	<div class="fwa-separate-box fwa-filter-bar">
<?php
$this->app->triggerEvent('onShowLanguageFiltersEdit', array('com_fwfoodmenu', $this));
?>
    </div>
	<div class="fwa-separate-box">
	<ul uk-tab>
		<li class="uk-active">
			<a href="#fwg-menu-general"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL'); ?></a>
		</li>
		<li class="nav-item">
			<a href="#fwg-menu-category-design"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN'); ?></a>
		</li>
	</ul>
    <div class="uk-switcher">
        <div id="fwg-menu-general">
			<div class="uk-child-width-1-2@l fwa-mb-cardbox uk-grid-small" uk-grid>
				<div>
					<div class="uk-card">
						<div class="uk-card-header">
							<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL'); ?></h4>
						</div>
						<div class="uk-card-body">
							<div uk-grid>
								<div class="uk-width-2-5@s">
									<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_PUBLISHED'); ?>
									<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_PUBLISHED_HINT')); ?>"></i>
								</div>
								<div class="uk-width-3-5@s">
									<?php echo JHTMLfwView::radioGroup('published', $this->object->id?$this->object->published:1, array(
										'wrapper_class' => 'uk-margin-right',
										'buttons' => array(array(
											'active_class' => 'uk-button-success',
											'title' => JText::_('JYES'),
											'value' => 1
										), array(
											'active_class' => 'uk-button-danger',
											'title' => JText::_('JNO'),
											'value' => 0
										))
									)); ?>
								</div>
							</div>
							<div uk-grid>
								<div class="uk-width-2-5@s">
									<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_NAME'); ?>
									<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_NAME_HINT')); ?>"></i>
								</div>
								<div class="uk-width-3-5@s">
									<input class="uk-input" value="<?php echo $this->escape($this->object->name); ?>" id="fwfm-name" type="text" name="name"/>
								</div>
							</div>
							<div uk-grid>
								<div class="uk-width-2-5@s">
									<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_ALIAS'); ?>
									<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_ALIAS_HINT')); ?>"></i>
								</div>
								<div class="uk-width-3-5@s">
									<input class="uk-input" value="<?php echo $this->escape($this->object->alias); ?>" id="fwfm-alias" type="text" name="alias"/>
								</div>
							</div>
							<div uk-grid>
								<div class="uk-width-2-5@s">
									<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_CATEGORY'); ?>
									<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_CATEGORY_HINT')); ?>"></i>
								</div>
								<div class="uk-width-3-5@s">
									<?php echo JHTML::_('fwfCategory.parent', $this->object->id?$this->object:(object)array('parent'=>$this->category), 'parent', 'class="form-control advancedSelect"'); ?>
								</div>
							</div>
<?php
$this->app->triggerEvent('onShowCategoryEditExtraFields', array('com_fwfoodmenu', $this));
?>
							<div uk-grid>
								<div class="uk-width-2-5@s">
									<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_DESCRIPTION'); ?>
									<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_GENERAL_DESCRIPTION_HINT')); ?>"></i>
								</div>
								<div class="uk-width-3-5@s">
									<textarea class="uk-textarea" id="fwfm-short_description" cols="60" rows="4" name="short_description"><?php echo $this->escape($this->object->short_description); ?></textarea>
								</div>
							</div>
						</div>
					</div>
<?php
$this->app->triggerEvent('onShowCategoryEditExtraCards', array('com_fwfoodmenu', $this));
?>
				</div>
				<div>
					<div class="uk-card">
						<div class="uk-card-header">
							<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_DESCRIPTION'); ?></h4>
							<div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_GENERAL_SECTION_DESCRIPTION_DESCRIPTION_HINT'); ?></div>
						</div>
						<div class="uk-card-body">
							<div uk-grid>
								<div class="col">
									<?php echo $editor->display('description', $this->object->description, 600, 300, 60, 10, $buttons = false); ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div id="fwg-menu-category-design">
			<div class="">
				<div class="fwa-mb-cardbox">
                        <div class="uk-card">
                            <div class="uk-card-header">
                                <h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY'); ?></h4>
                                <div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_HINT'); ?></div>
                            </div>
                            <div class="uk-card-body">
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_THEME'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_THEME_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTML::_('select.genericlist', array_merge(array(
											JHTML::_('select.option', 'def', JText::_('FWFM_DEFAULT'), 'id', 'name')
										), fwFoodMenuHelper::getThemesList()), 'params[template]', ' class="uk-select"', 'id', 'name', $this->object->params->get('template', 'def')); ?>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_SHOWTITLE'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_SHOWTITLE_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTMLfwView::radioGroup('params[display_category_title]', $this->object->params->get('display_category_title', 'def'), array(
											'wrapper_class' => 'uk-margin-right',
											'buttons' => array(array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_DEFAULT'),
												'value' => 'def'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('JYES'),
												'value' => '1'
											), array(
												'active_class' => 'uk-button-danger',
												'title' => JText::_('JNO'),
												'value' => '0'
											))
										)); ?>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_SHORTDESCRIPTION'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_SHORTDESCRIPTION_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTMLfwView::radioGroup('params[display_category_shortdescription]', $this->object->params->get('display_category_shortdescription', 'def'), array(
											'wrapper_class' => 'uk-margin-right',
											'buttons' => array(array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_DEFAULT'),
												'value' => 'def'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_SHOW'),
												'value' => '1'
											), array(
												'active_class' => 'uk-button-danger',
												'title' => JText::_('FWFM_HIDE'),
												'value' => '0'
											))
										)); ?>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_POSITION'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_POSITION_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTMLfwView::radioGroup('params[category_descr_position]', $this->object->params->get('category_descr_position', 'def'), array(
											'wrapper_class' => 'uk-margin-right',
											'buttons' => array(array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_DEFAULT'),
												'value' => 'def'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_TOP'),
												'value' => 'top'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_LEFT'),
												'value' => 'left'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_RIGHT'),
												'value' => 'right'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_BOTTOM'),
												'value' => 'bottom'
											))
										)); ?>
									</div>
								</div>
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_ALIGNMENT'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_CATEGORY_ALIGNMENT_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTMLfwView::radioGroup('params[category_text_alignment]', $this->object->params->get('category_text_alignment', 'def'), array(
											'wrapper_class' => 'uk-margin-right',
											'buttons' => array(array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_DEFAULT'),
												'value' => 'def'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_LEFT'),
												'value' => 'left'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_CENTER'),
												'value' => 'center'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_RIGHT'),
												'value' => 'right'
											))
										)); ?>
									</div>
								</div>
<?php
$this->app->triggerEvent('onShowCategoryEditDesignCategoryExtraSettings', array('com_fwfoodmenu', $this));
?>
							</div>
						</div>
<?php
$this->app->triggerEvent('onShowCategoryEditDesignCategoryExtraCards', array('com_fwfoodmenu', $this));
?>
                        <div class="uk-card">
                            <div class="uk-card-header">
                                <h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_MEALLAYOUT'); ?></h4>
                                <div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_MEALLAYOUT_HINT'); ?></div>
                            </div>
                            <div class="uk-card-body">
								<div uk-grid>
									<div class="uk-width-2-5@s">
										<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_MEALLAYOUT_MEALCONTENT'); ?>
										<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORYEDIT_TAB_DESIGN_SECTION_MEALLAYOUT_MEALCONTENT_HINT')); ?>"></i>
									</div>
									<div class="uk-width-3-5@s">
										<?php echo JHTMLfwView::radioGroup('params[meal_text_alignment]', $this->object->params->get('meal_text_alignment', 'def'), array(
											'wrapper_class' => 'uk-margin-right',
											'buttons' => array(array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_DEFAULT'),
												'value' => 'def'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_LEFT'),
												'value' => 'left'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_CENTER'),
												'value' => 'center'
											), array(
												'active_class' => 'uk-button-success',
												'title' => JText::_('FWFM_RIGHT'),
												'value' => 'right'
											))
										)); ?>
									</div>
								</div>
<?php
$this->app->triggerEvent('onShowCategoryEditDesignMenuExtraSettings', array('com_fwfoodmenu', $this));
?>
							</div>
						</div>
				</div>
			</div>
		</div>
	</div>
	</div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="view" value="category" />
	<input type="hidden" name="oid" value="<?php echo $this->object->id; ?>" />
	<input type="hidden" name="limitstart" value="<?php echo $this->input->getInt('limitstart'); ?>" />
<?php
foreach ($this->fields as $field) {
	if ($this->$field) {
?>
    <input type="hidden" name="<?php echo $field; ?>" value="<?php echo $this->escape($this->$field); ?>" />
<?php
	}
}
?>
</form>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
    $('button:has(\'[uk-icon="paint-brush"]\')').click(function() {
        $(this).parent().find('input').focus();
    });
	})(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);
