<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

JHTML::_('behavior.core');
JHTML::_('formbehavior.chosen');
$save_ordering_url = 'index.php?option=com_fwfoodmenu&view=category&layout=save_order&format=raw';
$icon_class = '';
if ($this->list) {
	if (defined('JVERSION') and version_compare(JVERSION, '4', '>=')) {
		JHTML::_('draggablelist.draggable');
		$icon_class = 'icon-ellipsis-v d-inline-block px-2';
	} else {
		JHTML::_('sortablelist.sortable', 'fwfm-list-to-sort', 'adminForm', 'asc', $save_ordering_url);
		$icon_class = 'icon-menu';
	}
}

JToolBarHelper::title(JText::_('FWFM_ADMIN_CATEGORIES_TOOLBAR_TITLE'), 'folder');

fwfmButtonsHelper::addNew('add', 'FWFM_DOC_ADMIN_CATEGORIES_TOOLBAR_BTN_NEW');
fwfmButtonsHelper::custom('upload', '', 'FWFM_DOC_ADMIN_CATEGORIES_TOOLBAR_BTN_QUICKCATEGORIES', 'quick', false);
fwfmButtonsHelper::publish('publish', 'FWFM_DOC_ADMIN_CATEGORIES_TOOLBAR_BTN_PUBLISH');
fwfmButtonsHelper::unpublish('unpublish', 'FWFM_DOC_ADMIN_CATEGORIES_TOOLBAR_BTN_UNPUBLISH');
fwfmButtonsHelper::custom('check', '', 'FWFM_DOC_ADMIN_CATEGORIES_TOOLBAR_BTN_BATCH', 'batch', true);
fwfmButtonsHelper::editList('edit', 'FWFM_DOC_ADMIN_CATEGORIES_TOOLBAR_BTN_EDIT');
fwfmButtonsHelper::custom('copy', '', 'FWFM_DOC_ADMIN_CATEGORIES_TOOLBAR_BTN_COPY', 'copy', true);
fwfmButtonsHelper::deleteList(JText::_('FWFM_ADMIN_CATEGORIES_TOOLBAR_BTN_DELETE_MSG'), 'remove', 'FWFM_DOC_ADMIN_CATEGORIES_TOOLBAR_BTN_DELETE');

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => JText::_('FWFM_DOC_ADMIN_CATEGORIES'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_CATEGORIES_HINT'),
	'view' => $this
), JPATH_COMPONENT);
?>
<form id="adminForm" name="adminForm" method="post" action="index.php?option=com_fwfoodmenu&view=category">
    <div class="fwa-separate-box fwa-filter-bar uk-grid-small" uk-grid>
        <div class="uk-width-1-6@l" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORIES_FILTER_CATEGORY_HINT')); ?>">
			<?php echo
			JHTML::_('fwfCategory.getCategories', 'category', $this->category, 'class="uk-select advancedSelect" onchange="with(this.form){limitstart.value=0;submit();}"', false, 'FWFM_DOC_ADMIN_CATEGORIES_FILTER_CATEGORY', true); ?>
        </div>
        <div class="uk-width-1-2@l" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORIES_FILTER_SEARCH_HINT')); ?>">
            <div class="uk-flex">
                <input class="form-control" placeholder="<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_FILTER_SEARCH'); ?>" type="text" name="search" value="<?php echo $this->escape($this->search); ?>" />
				<button class="uk-button uk-button-outline-secondary" type="button" onclick="with(this.form){limitstart.value=0;search.value='';submit();}"><span uk-icon="close"></span></button>
				<button class="uk-button uk-button-primary" type="submit"><span uk-icon="search"></span></button>
            </div>
        </div>
        <div class="uk-width-1-6@l" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORIES_FILTER_STATE_HINT')); ?>">
			<?php echo JHTML::_('select.genericlist', array(
				JHTML::_('select.option', '', JText::_('FWFM_DOC_ADMIN_CATEGORIES_FILTER_STATE'), 'id', 'name'),
				JHTML::_('select.option', 'published', JText::_('FWFM_ADMIN_PUBLISHED'), 'id', 'name'),
				JHTML::_('select.option', 'unpublished', JText::_('FWFM_ADMIN_UNPUBLISHED'), 'id', 'name'),
			), 'state', 'class="uk-select advancedSelect" onchange="with(this.form){limitstart.value=0;submit();}"', 'id', 'name', $this->state); ?>
        </div>
<?php
$this->app->triggerEvent('onShowCategoryListFilters', array('com_fwfoodmenu', $this));
$this->app->triggerEvent('onShowLanguageFilters', array('com_fwfoodmenu', $this));
?>
    </div>
	
	<div class="fwa-separate-box">
	<div class="table-responsive">
	<table class="table table-striped" id="fwfm-list-to-sort">
		<thead>
			<tr>
				<th style="width:20px;"><input class="uk-checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);" type="checkbox"></th>
				<th style="width:20px;" class="uk-text-center"><i uk-icon="sort"></i></th>
<?php
$this->app->triggerEvent('onShowCategoryListBeginExtraHeaders', array('com_fwfoodmenu', $this));
?>
				<th uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORIES_COLUMN_CATEGORY_HINT')); ?>">
					<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_COLUMN_CATEGORY'); ?>
				</th>
				<th uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORIES_COLUMN_PUBLISHED_HINT')); ?>">
					<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_COLUMN_PUBLISHED'); ?></th>
<?php
$this->app->triggerEvent('onShowCategoryListEndExtraHeaders', array('com_fwfoodmenu', $this));
?>
			</tr>
		</thead>
		<tbody class="js-draggable" data-url="<?php echo $save_ordering_url; ?>" data-direction="asc" data-nested="false">
<?php
if ($this->list) {
	foreach ($this->list as $num=>$row) {
		$description = strip_tags($row->description);
		$total = strlen($description);
		if ($total > 100) $description = mb_substr($description, 0, 96).'...('.$total.')';
?>
			<tr data-draggable-group="<?php echo $row->parent; ?>" data-item-id="<?php echo $row->id; ?>" data-parents="<?php echo $row->parent; ?>">
				<td>
					<?php echo JHTML :: _('grid.id', $num, $row->id); ?>
					<input type="hidden" name="order[]" value="<?php echo (int)$row->ordering; ?>">
				</td>
				<td>
					<span class="sortable-handler">
						<span class="<?php echo $icon_class; ?>"></span>
					</span>
				</td>
<?php
$this->app->triggerEvent('onShowCategoryListBeginExtraColumns', array('com_fwfoodmenu', $this, $row, $num));
?>
				<td>
					<a class="mb-2" href="index.php?option=com_fwfoodmenu&amp;view=category&amp;task=edit&amp;cid[]=<?php echo $row->id.$this->extra_link; ?>">
						<?php echo $row->treename; ?>
					</a> 
					<?php if (strlen($row->short_description)) : ?>
					<div class=" uk-margin-small-top text-muted font-italic"><?php echo $row->short_description; ?></div>
					<?php endif; ?>
					<div class=" uk-margin-small-top"><?php echo $description; ?></div>
					<div class=" uk-margin-top small ">
						<span class="text-muted d-inline-block" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORIES_COLUMN_ID_HINT')); ?>">
							<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_COLUMN_ID'); ?>: <?php echo $row->id; ?></span>
						<span class="uk-margin-left" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORIES_COLUMN_CATEGORIES_HINT')); ?>">
							<i uk-icon="folder-tree" class="uk-margin-small-right"></i>
							<a href="index.php?option=com_fwfoodmenu&view=category&category=<?php echo $row->id; ?>">
								<?php echo fwFoodMenuHelper::countCategoriesQty($row->id); ?></a>
						</span>
						<span class="uk-margin-left" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORIES_COLUMN_MEALS_HINT')); ?>">
							<i uk-icon="utensils" class="uk-margin-small-right"></i>
							<a href="index.php?option=com_fwfoodmenu&view=items&category=<?php echo $row->id; ?>">
								<?php echo fwFoodMenuHelper::countMealsQty($row->id); ?></a>
						</span>
<?php
$this->app->triggerEvent('onShowCategoryListBeginExtraIcons', array('com_fwfoodmenu', $this, $row, $num));
?>

					</div>
				</td>
				<td class="uk-text-center">
					<?php echo JHTMLfwView::booleanListLink(array(
						'num' => $num,
						'value' => $row->published,
						'task_on' => 'publish',
						'task_off' => 'unpublish',
						'title_on' => JText::_('FWFM_CATEGORY_PUBLISH'),
						'title_off' => JText::_('FWFM_CATEGORY_UNPUBLISH')
					)); ?>
				</td>
<?php
$this->app->triggerEvent('onShowCategoryListEndExtraColumns', array('com_fwfoodmenu', $this, $row, $num));
?>
			</tr>
<?php
	}
} else {

}
?>
		</tbody>
	</table>
	</div>
	<div class="fwa-pagination">
		<div class="fwa-pagination-total">
			<?php echo $this->pagination->getResultsCounter(); ?>
		</div>
		<div class="fwa-pagination-pages">
			<?php echo $this->pagination->getListFooter(); ?>
		</div>
		<div class="fwa-pagination-limit">
			<div class="d-inline-block">
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
		</div>
	</div>
	</div>
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="task" value="" />
</form>
<div id="fwfm-batch-operations" class="uk-modal-container" uk-modal>
	<div class="uk-modal-dialog">
		<div class="uk-modal-header">
			<h5 class="uk-modal-title">
				<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_BATCH'); ?>
				<div class="uk-modal-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_BATCH_HINT'); ?></div>
			</h5>
			<button class="uk-modal-close-default" type="button" uk-close></button>
		</div>
		<form action="index.php?option=com_fwfoodmenu&amp;view=category" method="post" name="operationsForm" id="operationsForm">
			<div class="uk-modal-body">
				<div class="uk-child-width-1-2@m" uk-grid>
					<div>
						<label for="fwfm-category-batch"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_BATCH_CATEGORY'); ?></label>
						<i uk-icon="question" class="uk-margin-left" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_BATCH_CATEGORY_HINT')); ?>"></i>
						<?php echo JHTML::_('fwfCategory.parent', array('category_id' => -1), 'category_id', 'class="form-control advancedSelect"', 'FWFM_ADMIN_CATEGORIES_MODAL_BATCH_CATEGORY_ROOT', false, null, 'FWFM_ADMIN_CATEGORIES_MODAL_BATCH_CATEGORY_SAME', -1); ?>
					</div>
<?php
$this->app->triggerEvent('onShowCategoriesBachProcessingExtraFields', array('com_fwfoodmenu', $this));
?>
				</div>
			</div>
			<div class="uk-modal-footer">
				<button type="button" class="uk-button uk-button-secondary uk-modal-close"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_BATCH_BTN_CANCEL'); ?></button>
				<button type="submit" class="uk-button uk-button-success"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_BATCH_BTN_PROCESS'); ?></button>
			</div>
			<input type="hidden" name="task" value="dobatch" />
<?php
foreach ($this->fields as $field) {
	if ($this->$field) {
?>
			<input type="hidden" name="<?php echo $field; ?>" value="<?php echo $this->escape($this->$field); ?>" />
<?php
	}
}
?>
		</form>
	</div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
		Joomla.submitbutton = function(pressbutton) {
			if (pressbutton == 'quick') {
				UIkit.modal('#fwfm-quick-categories').show()
			} else if (pressbutton == 'batch') {
				UIkit.modal('#fwfm-batch-operations').show()
			} else {
				document.adminForm.task.value=pressbutton;
				document.adminForm.submit();
			}
		}
		$('#fwfm-batch-operations').on('show', function() {
			var $form = $(this).find('form');
			$form.find('input[name="cid[]"]').remove();
			var $cids = $('#adminForm input[name="cid[]"]:checked').each(function() {
				var $inp = $('<input />', {
					type: 'hidden',
					name: 'cid[]',
					'value': this.value
				});
				$form.append($inp);
			});
		});
		$('#toolbar-upload button').addClass('uk-button-primary');

		var $limitstart = $('#adminForm input[name="limitstart"]');
		if (!$limitstart.length) {
			$limitstart = $('<input type="hidden" name="limitstart" />');
			$('#adminForm').append($limitstart);
		}
	})(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);
