<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

class menuViewBadges extends JViewLegacy {
    function display($tmpl = null) {
        $this->menu = 'badges';
        $model = $this->getModel();

        JHTML::_('behavior.core');
        $this->app = JFactory::getApplication();

        $this->plugin_installed = fwFoodMenuHelper::pluginInstalled('mealbadges');
        $this->plugin_enabled = fwFoodMenuHelper::pluginEnabled('mealbadges');

		$this->fields = array('search', 'limit', 'limitstart');

        switch ($this->getLayout()) {
            case 'edit' :
			$this->object = $model->loadObject();
            foreach ($this->fields as $field) {
                $this->$field = (string)$this->app->input->getString($field);
            }
			fwFoodMenuHelper::triggerEvent('onLoadMainMenu', array('com_fwfoodmenu', 'badge', $this));
            break;
            default:
			$this->list = $model->loadList();
			$this->pagination = $model->getPagination();
			$this->extra_link = '';
            foreach ($this->fields as $field) {
                $this->$field = (string)$this->app->input->getString($field);
				if (is_string($this->$field)) {
					$this->extra_link .= '&amp;'.$field.'='.urlencode($this->$field);
    				$this->pagination->setAdditionalUrlParam($field, $this->$field);
    			}
            }
			fwFoodMenuHelper::triggerEvent('onLoadMainMenu', array('com_fwfoodmenu', 'badges', $this));
        }
		$this->params = JComponentHelper::getParams('com_fwfoodmenu');
        parent::display($tmpl);
    }
}
