<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2019 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

JToolBarHelper::title(JText::_('FWFM_ADMIN_ADDONS_TOOLBAR_TITLE'), ' puzzle-piece');

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => JText::_('FWFM_DOC_ADMIN_ADDONS'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_ADDONS_HINT'),
	'view' => $this
), JPATH_COMPONENT);
?>
<form action="index.php?option=com_fwfoodmenu&amp;view=addon" id="adminForm" name="adminForm" method="post">
	<div uk-grid>
		<div class="uk-width-3-4@m">
<?php
$have_services = false;
$comp_version = '';
$main_not_updated = $count_services = $addon_not_updated = $addon_installed = $addon_not_installed = $count_addons = 0;
foreach ($this->addons as $row) {
    if ($row->update_name == FWA_UPDATE_NAME) {
        $comp_version = $row->loc_version;
    } else {
        if ($row->type and !$row->installed and !empty($row->installable)) {
            $addon_not_installed = 1;
        }
        if ($row->type and $row->installed) {
            $addon_installed = 1;
        }
        if ($row->loc_version and $row->rem_version and $row->loc_version != 'x.x.x' and $row->loc_version != $row->rem_version) {
            $addon_not_updated = true;
        }
        if ($row->subtype == 'service') {
            $have_services = true;
            $count_services++;
        } elseif (!((!$row->installed and !$row->installable) or !$row->type)) {
            $count_addons++;
        }
    }
}

if ($addon_installed) {
?>
<div class="uk-card uk-card-default uk-padding fws-extension-addon">
    <div class="uk-h3"><?php echo JText::_('FWFM_DOC_ADMIN_ADDONS_INSTALLED_ADDONS'); ?></div>
    <div class="uk-child-width-1-3@l uk-child-width-1-2@m uk-grid-small uk-grid-match" uk-grid>
<?php
foreach ($this->addons as $row) {
    if ($row->type and $row->installed and $row->update_name != FWA_UPDATE_NAME) {
?>
        <div>
            <div class="uk-card uk-card-default uk-border-rounded uk-position-relative uk-padding-remove fwshop-item uk-margin-small-bottom" data-ext="<?php echo $this->escape($row->update_name); ?>">
                <div class="uk-card-media-top fwshop-addon-img">
                    <a href="javascript:" data-lightbox="html" data-lightbox-title="<?php echo $this->escape($row->name); ?> <?php echo $this->escape(JText::_('FWA_ADDON')); ?>">
                        <img class="" src="<?php echo $row->image; ?>" alt="<?php echo $this->escape($row->name); ?>">
                    </a>
                </div>
                <div class="uk-padding-small">
                    <div class="uk-h4 uk-margin-small-bottom fwshop-addon-title">
                        <a class="uk-h4 uk-margin-small-bottom" href="javascript:" data-lightbox="html" data-lightbox-title="<?php echo $this->escape($row->name); ?> <?php echo $this->escape(JText::_('FWA_ADDON')); ?>">
                            <?php echo $row->name;?>
                        </a>
                    </div>
                    <div class="uk-margin-small-bottom uk-grid-small" uk-grid>
<?php
        if (!empty($row->_required)) {
?>
                        <span class="fws-extension-addon-required">
                            <span class="uk-label uk-label-danger" uk-tooltip title="<?php echo JText::_('FWFM_REQUIRED'); ?>: <?php echo implode(', ', $row->_required); ?>">
                                <i uk-icon="icon: warning; ratio: .7;"></i>
                            </span>
                        </span>
<?php
        }
?>
                        <span class="fws-extension-addon-version">
                            <span class="uk-label uk-label-<?php if ($addon_not_updated) { ?>danger<?php } else { ?>success<?php } ?>" uk-tooltip title="<?php echo JText::_('FWFM_ADMIN_ADDONS_COMPONENT_INSTALLEDVERSION'); ?>: <?php echo $row->loc_version; ?>">
                                <i uk-icon="icon:git-branch; ratio: .65;"></i>
                                <?php echo $row->loc_version; ?>
                            </span>
                        </span>
<?php
        if (!empty($row->_comp_version)) {
            $version_match = true;
            $buff1 = explode('.', $comp_version, 3);
            $buff2 = explode('.', $row->_comp_version, 3);
            if (count($buff1) > 2 and count($buff2) > 2 and $buff1[0] != 'x' and ($buff1[0] < $buff2[0] or ($buff1[0] == $buff2[0] and $buff1[1] < $buff2[1]))) {
                $version_match = false;
            }
?>
                        <span>
                            <span class="uk-label uk-label-<?php if ($version_match) { ?>success<?php } else { ?>danger<?php } ?>" uk-tooltip title="<?php echo JText::_('FWFM_MAIN_COMPONENT_REQUIRED_VERSION'); ?>: <?php echo $row->_comp_version; ?>">
                                <i uk-icon="icon:cube; ratio: .6;"></i>
                            </span>
                        </span>
<?php
        }
?>
                    </div>
                    <div class="uk-text-small uk-text-muted fwshop-addon-description">
<?php 
        $desc = trim(strip_tags($row->description));
        if (strlen($desc) > 147 ) $desc = substr($desc, 0, 147).'...';
        echo $desc;
?>
                    </div>
                    <div class="uk-flex-middle uk-flex-between uk-grid-collapse" uk-grid>
                        <div class="fwshop-addon-btn">
<?php
       if ($addon_not_updated) {
?>
                            <button type="button" class="uk-button uk-button-small uk-button-warning fwfm-addon-update"><i uk-icon="icon:cog; ratio: .75;" class="uk-margin-small-right"></i><?php echo JText::_('FWFM_UPDATE_TO'); ?> <?php echo $row->rem_version; ?></button>
<?php
        }
        if ($row->enabled) {
?>
                            <button type="button" class="uk-button uk-button-small uk-button-danger fwfm-addon-disable"><i uk-icon="icon:cog; ratio: .75;" class="uk-margin-small-right"></i><?php echo JText::_('FWFM_DISABLE'); ?></button>
<?php
        } else {
?>
                            <button type="button" class="uk-button uk-button-small uk-button-success fwfm-addon-enable"><i uk-icon="icon:cog; ratio: .75;" class="uk-margin-small-right"></i><?php echo JText::_('FWFM_ENABLE'); ?></button>
<?php
        }
?>
                        </div>
<?php
        if (!empty($row->doc_link) or !empty($row->frontend_demo_link)) {
?>
                        <div class="fws-extension-addon-links">
<?php
            if (!empty($row->doc_link)) {
?>
                            <a href="<?php echo $row->doc_link; ?>" target="_blank" uk-tooltip title="<?php echo JText::_('FWFM_DOCUMENTATION'); ?>">
                                <i uk-icon="book"></i>
                            </a>
<?php
            }
            if (!empty($row->frontend_demo_link)) {
?>
                            <a href="<?php echo $row->frontend_demo_link; ?>" target="_blank" uk-tooltip title="<?php echo JText::_('FWFM_DEMO_LINK'); ?>">
                                <i uk-icon="presentation" class="uk-margin-small-left"></i>
                            </a>
<?php
            }
?>
                        </div>
<?php
        }
?>                        
                    </div>
                </div>
            </div>
        </div>
<?php
    }
}
?>
    </div>
</div>
<?php
}
if ($addon_not_installed) {
?>
<div class="uk-card uk-card-default uk-padding fws-extension-addon<?php if ($addon_installed) { ?> uk-margin-medium-top<?php } ?>">
    <div class="uk-h3"><?php echo JText::_('FWFM_DOC_ADMIN_ADDONS_NOTINSTALLED_ADDONS'); ?></div>
    <div class="uk-child-width-1-3@m uk-grid-small" uk-grid>
<?php
foreach ($this->addons as $row) {
    if ($row->type and !$row->installed and $row->installable) {
?>
        <div>
            <div class="uk-card uk-card-default uk-position-relative uk-margin fwshop-item" data-ext="<?php echo $this->escape($row->update_name); ?>">
                <div class="uk-card-media-top fwshop-addon-img">
                    <a href="javascript:" data-lightbox="html" data-lightbox-title="<?php echo $this->escape($row->name); ?> <?php echo $this->escape(JText::_('FWA_ADDON')); ?>">
                        <img class="img-thumbnail" src="<?php echo $row->image; ?>" alt="<?php echo $this->escape($row->name); ?>">
                    </a>
                </div>
                <div class="uk-card-body uk-padding-small">
                    <div class="uk-h4 uk-margin-small-bottom fwshop-addon-title">
                        <a class="uk-h4 uk-margin-small-bottom" href="javascript:" data-lightbox="html" data-lightbox-title="<?php echo $this->escape($row->name); ?> <?php echo $this->escape(JText::_('FWA_ADDON')); ?>">
                            <?php echo $row->name;?>
                        </a>
                    </div>
                    <div class="uk-margin-small-bottom">
<?php
        if (!empty($row->_required)) {
?>
                        <div class="fws-extension-addon-required small uk-text-danger"><i uk-icon="warning"></i> <?php echo implode(', ', $row->_required); ?> <?php echo JText::_('FWFM_REQUIRED'); ?></div>
<?php
        }
?>
<?php
        if (!empty($row->_comp_version)) {
            $version_match = true;
            $buff1 = explode('.', $comp_version, 3);
            $buff2 = explode('.', $row->_comp_version, 3);
            if (count($buff1) > 2 and count($buff2) > 2 and $buff1[0] != 'x' and ($buff1[0] < $buff2[0] or ($buff1[0] == $buff2[0] and $buff1[1] < $buff2[1]))) {
                $version_match = false;
            }
?>
                        <div>
                            <?php echo JText::_('FWFM_MAIN_COMPONENT_REQUIRED_VERSION'); ?>: <span class="uk-badge uk-badge-<?php if ($version_match) { ?>success<?php } else { ?>danger<?php } ?>"><?php echo $row->_comp_version; ?></span>
                        </div>
<?php
        }
?>
                    </div>
                    <div class="uk-text-small fwshop-addon-description">
<?php 
        $desc = trim(strip_tags($row->description));
        if (strlen($desc) > 147 ) $desc = substr($desc, 0, 147).'...';
        echo $desc;
?>
                    </div>
<?php
        if (!empty($row->doc_link) or !empty($row->frontend_demo_link)) {
?>
                    <div class="uk-margin-small-bottom fws-extension-addon-links">
<?php
            if (!empty($row->doc_link)) {
?>
                        <a href="<?php echo $row->doc_link; ?>" target="_blank">
                            <i uk-icon="book" class="uk-margin-small-right"></i>
                            <?php echo JText::_('FWFM_DOCUMENTATION'); ?>
                        </a>
<?php
            }
            if (!empty($row->frontend_demo_link)) {
?>
                        <a href="<?php echo $row->frontend_demo_link; ?>" target="_blank">
                            <i uk-icon="presentation" class="uk-margin-small-right"></i>
                            <?php echo JText::_('FWFM_DEMO_LINK'); ?>
                        </a>
<?php
            }
?>
                    </div>
<?php
        }

?>
                    <div class="fwshop-addon-btn">
                        <button type="button" class="uk-button uk-button-warning fwfm-addon-install"><?php echo JText::_('FWFM_INSTALL_VERSION'); ?> <?php echo $row->rem_version; ?></button>
                    </div>
                </div>
            </div>
        </div>
<?php
    }
}
?>
    </div>
</div>
<?php
}
?>
		</div>
		<div class="uk-width-1-4@m">
			<div class="uk-card uk-card-default uk-margin-medium">
<?php
$addons_installed = $addons_total = 0;
if ($this->addons) {
	foreach ($this->addons as $row) {
        if ($row->type and $row->update_name != FWA_UPDATE_NAME) {
            $addons_total++;
        }
        if ($row->installed and $row->update_name != FWA_UPDATE_NAME) {
            $addons_installed++;
        }
    }

	foreach ($this->addons as $row) {
		if ($row->update_name == FWA_UPDATE_NAME) {
            $main_not_updated = ($row->loc_version and $row->rem_version and $row->loc_version != 'x.x.x' and $row->loc_version != $row->rem_version);
?>
                <!-- <div class="uk-card-media-top uk-padding-small uk-text-center fws-ext-item-img">
                    <img class="uk-width-small" src="<?php echo $row->image; ?>" />
                </div> -->
    			<div class="uk-card-body">
                    <h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_ADDONS_COMPONENT_NOPARAMS'); ?></h4>
					<div class="" data-ext="<?php echo $this->escape($row->update_name); ?>" uk-margin="uk-margin-small">
						<div class="fws-ext-stats">
							<div class="fws-ext-latest">
								<i uk-icon="git-branch" class="uk-margin-small-right"></i>
								<?php echo JText::_('FWFM_ADMIN_ADDONS_COMPONENT_INSTALLEDVERSION'); ?>
								<span class="uk-badge uk-badge-<?php if ($main_not_updated) { ?>warning<?php } else { ?>success<?php } ?>"><?php echo $row->loc_version; ?></span>
							</div>
							<!-- <div class="fws-show-addons-owned">
								<i uk-icon="puzzle-piece" class="uk-margin-small-right"></i>
								<?php echo JText::sprintf('FWFM_ADDONS_OWNED_OF', $addons_installed, $addons_total); ?>
							</div> -->
<?php
            if ($main_not_updated) {
                $release = $descr = '';
                if (strpos($row->rem_version, '.0.0')) {
                    $release = 'FWA_MAJOR_RELEASE_TITLE';
                    $descr = 'FWA_MAJOR_RELEASE_IMPACT';
                } elseif (strpos($row->rem_version, '.0')) {
                    $release = 'FWA_MINOR_RELEASE_TITLE';
                    $descr = 'FWA_MINOR_RELEASE_IMPACT';
                } else {
                    $release = 'FWA_MAINTENACE_RELEASE_TITLE';
                    $descr = 'FWA_MAINTENACE_RELEASE_IMPACT';
                }
?>
							<div class="fws-ext-update">
								<button type="button" class="uk-button uk-button-warning fwfm-addon-update"><?php echo JText::_('FWFM_UPDATE_TO'); ?> <?php echo $row->rem_version; ?></button>
							</div>
<?php
            }
?>

							<div>
								<a href="https://fastw3b.com/products/fw-food-menu" target="_blank">
									<i uk-icon="cube" class="uk-margin-small-right"></i>
									<?php echo JText::_('FWFM_PRODUCT_PAGE') ?>
								</a>
							</div>
							<div>
								<a href="javascript:">
									<i uk-icon="file" class="uk-margin-small-right"></i>
									<?php echo JText::_('FWFM_CHANGELOG'); ?>
								</a>
							</div>
							<div>
								<a href="https://fastw3b.com/documentation/fw-food-menu/" target="_blank">
									<i uk-icon="book" class="uk-margin-small-right"></i>
									<?php echo JText::_('FWFM_DOCUMENTATION'); ?>
								</a>
							</div>
						</div>

					</div>
<?php
			if ($main_not_updated) {
?>
					<div class="uk-alert uk-alert-info fws-ext-update-info" uk-tooltip="<?php echo $this->escape(JText::_($descr)); ?>">
						<?php echo JText::_($release); ?>
					</div>
<?php
			}

			break;
		}
	}
}
?>
				</div>
			</div>
<?php
if ($have_services) {
?>
            <div class="uk-card uk-card-default">
                <div class="uk-card-header">
                    <h4 class="uk-card-title" uk-tooltip title="<?php echo JText::_('FWFM_DOC_ADMIN_ADDONS_SERVICES_HINT'); ?>">
                        <?php echo JText::_('FWFM_DOC_ADMIN_ADDONS_SERVICES_NOPARAMS'); ?>
                    </h4>
                    <!-- <div>
                        <span class="uk-badge uk-badge-default"><i uk-icon="cog" class="uk-margin-small-right"></i>  <?php echo $count_services.' '.JText::_('FWFM_ADMIN_ADDONS_SERVICES_AVAILABLE'); ?></span>
                    </div> -->
                </div>
                <div class="uk-padding-small">
<?php
	foreach ($this->addons as $row) {
		if ($row->subtype == 'service') {
			$image = $row->image?$row->image:(JURI::root(true).'/administrator/components/com_fwfoodmenu/assets/images/'.$row->update_name.'.jpg');
?>
                    <div class="uk-margin">
                        <div class="uk-card uk-card-default">
                            <div class="uk-card-media-top">
                                <img class="" src="<?php echo $image; ?>" alt="<?php echo $this->escape($row->name); ?>">
                            </div>
                            <div class="uk-padding-small">
                                <div class="uk-h4 fwa-service-name"><?php echo $this->escape($row->name); ?></div>
                                <div class="uk-text-muted fwa-service-description"><?php echo $row->description; ?></div>
                                <div class="uk-grid-collapse uk-flex-between" uk-grid>
                                    <div class="">
                                        <div class="uk-text-bold">$<?php echo ((int)$row->price) ? number_format($row->price, 2) : 'TBD'; ?></div>
                                        <div><?php echo ($row->days) ? $row->days.' '.JText::_('FWA_DAYS') : 'TBD'; ?></div>
                                    </div>
                                    <div>
                                        <a class="uk-button uk-button-small uk-button-secondary" href="<?php echo $row->link; ?>" target="_blank">
                                            <i uk-icon="icon: file-invoice; ratio: .75" class="uk-margin-small-right"></i> <?php echo JText::_('FWFM_ADMIN_ADDONS_PREORDER_SERVICE'); ?>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
				
<?php
		}
	}
?>
                </div>
            </div>
<?php
}
?>
		</div>
	</div>
    <input type="hidden" name="task" value="" />
    <input type="hidden" name="boxchecked" value="" />
</form>
<div id="fwfm-changelog" class="uk-modal-container" uk-modal>
  <div class="uk-modal-dialog">
      <div class="uk-modal-header">
        <h5 class="uk-modal-title"><?php echo JText::_('FWFM_CHANGELOG'); ?></h5>
        <button class="uk-modal-close-default" type="button" uk-close></button>
      </div>
      <div class="uk-modal-body">
      </div>
      <div class="uk-modal-footer">
        <button type="button" class="uk-button uk-button-outline-secondary uk-modal-close"><?php echo JText::_('FWFM_CLOSE'); ?></button>
      </div>
  </div>
</div>
<div id="fwa-addon-description" class="uk-modal-container" uk-modal>
  <div class="uk-modal-dialog">
      <div class="uk-modal-header">
        <h5 class="uk-modal-title"></h5>
        <button class="uk-modal-close-default" type="button" uk-close></button>
      </div>
      <div class="uk-modal-body"></div>
  </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    (function($) {
        $('#fwfm-install-all').click(function() {
            var $btn = $(this);
            var $wrp = $btn.parent();
            $btn.remove();
            if (!$wrp.find('button').length) {
                $wrp.remove();
            }
            $('.fwfm-addon-install').click();
        });
        $('#fwfm-update-all').click(function() {
            var $btn = $(this);
            var $wrp = $btn.parent();
            $btn.remove();
            if (!$wrp.find('button').length) {
                $wrp.remove();
            }
            $('.fwfm-addon-update').click();
        });
        $('.fws-ext-stats a:has(\'[uk-icon="file"]\')').click(function(ev) {
            ev.stopPropagation();
            var $btn = $(this);
			var $popup = $('#fwfm-changelog');
			$popup.find('.uk-modal-body').html('<div uk-spinner></div>');
			UIkit.modal($popup[0]).show()
            $.ajax({
                type: 'post',
                dataType: 'json',
            	data: {
                    format: 'json',
                    view: 'menu',
                    layout: 'get_changelog'
                }
            }).done(function(data) {
                $popup.find('.uk-modal-body').html(data.result?data.result:data.msg?data.msg:'<?php echo JText::_('FWFM_NO_CHANGELOG', true); ?>');
            });
        });
        $('.fwshop-item a[data-lightbox="html"]').click(function(ev) {
            ev.preventDefault();
            var $link = $(this);
            var $wrapper = $link.closest('.fwshop-item');
            var name = $wrapper.data('ext');
            var $popup = $('#fwa-addon-description');
            $popup.find('.uk-modal-title').html($link.data('lightbox-title'));
            $popup.find('.uk-modal-body').html('');
            UIkit.modal($popup[0]).show()

            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'addon',
                    layout: 'load_addon_description',
                    update_name: name
                }
            }).done(function(data) {
                if (data.html) {
                    $popup.find('.uk-modal-body').html(data.html);
                } else {
                    UIkit.modal($popup[0]).hide()
                }
                if (data.msg) {
                    alert(data.msg)
                }
            });
        });
        $('.fws-extension-addon,.fws-ext-update').on('click', '.fwfm-addon-install,.fwfm-addon-update,.fwfm-addon-enable,.fwfm-addon-disable', function() {
            var $btn = $(this);
            if ($btn.attr('disabled')) return;

            var action = '';
            if ($btn.hasClass('fwfm-addon-install')) {
                action = 'install';
            } else if ($btn.hasClass('fwfm-addon-enable')) {
                action = 'enable';
            } else if ($btn.hasClass('fwfm-addon-disable')) {
                action = 'disable';
            } else if ($btn.hasClass('fwfm-addon-update')) {
                action = 'update';
            }

            if (action == '') return;

            $btn.attr('disabled', true);

            var $wrp = $btn.closest('*[data-ext]');
            var $img = $('<div style="position:absolute" uk-spinner></div>');
            $btn.after($img);
            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'addon',
                    layout: action,
                    ext: [$wrp.data('ext')]
                }
            }).done(function(data) {
                $btn.attr('disabled', false);
                $img.remove();
                var msg_title = '';
                switch (action) {
                    case 'install' :
                    msg_title = '<?php echo JText::_('FWFM_INSTALLING_RESULT', true); ?>';
                    break;
                    case 'enable' :
                    msg_title = '<?php echo JText::_('FWFM_ENABLING_RESULT', true); ?>';
                    break;
                    case 'disable' :
                    msg_title = '<?php echo JText::_('FWFM_DISABLING_RESULT', true); ?>';
                    break;
                    case 'update' :
                    msg_title = '<?php echo JText::_('FWFM_UDPATING_RESULT', true); ?>';
                    break;
                }

                if (data.result) {
                    var row = data.result;
                    $btn.html(row.button);
                    switch (action) {
                        case 'install' :
                        $btn.removeClass('fwfm-addon-install uk-button-warning').addClass('fwfm-addon-disable uk-button-danger').html('<?php echo JText::_('FWFM_DISABLE', true); ?>');
                        break;
                        case 'enable' :
                        $btn.removeClass('fwfm-addon-enable').addClass('fwfm-addon-disable').removeClass('uk-button-success').addClass('uk-button-danger').html('<?php echo JText::_('FWFM_DISABLE', true); ?>');
                        break;
                        case 'disable' :
                        $btn.removeClass('fwfm-addon-disable').addClass('fwfm-addon-enable').removeClass('uk-button-danger').addClass('uk-button-success').html('<?php echo JText::_('FWFM_ENABLE', true); ?>');
                        break;
                        case 'update' :
                        $btn.remove();
                        break;
                    }
                }
                if (data.msg) {
                    fwfm_alert(data.msg);
                }
            });
        });
    })(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);
