<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2022 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined ('_JEXEC') or die();

class TableProfile extends JTable {
    var $user_id = null,
    	$logo = null,
    	$tel = null,
    	$mobile = null,
		$address = null;

	var $_system_user_name = null,
		$_user_name = null,
		$_user_email = null,
		$_user_username = null;

    function __construct( &$db ) {
        parent::__construct( '#__fwfoodmenu_profile', 'user_id', $db );
    }

    function load($oid=null, $reset = true) {
    	if (!$oid) {
    		$user = JFactory::getUser();
    		$oid = $user->id;
    	}
    	if ($oid) {
    		$db = JFactory::getDBO();
    		$db->setQuery('
SELECT
	u.id AS user_id,
	u.name AS _system_user_name,
	u.username AS _user_username,
	u.email AS _user_email,
	p.logo,
	p.tel,
	p.mobile,
	p.address
FROM
	`#__users` AS u
	LEFT JOIN `#__fwfoodmenu_profile` AS p ON u.id = p.user_id
WHERE
	u.id = '.(int)$oid);
			if ($obj = $db->loadObject()) {
				foreach ($obj as $key=>$value) $this->$key = $value;
				return true;
			}
    	}
    }
    function check() {
		$app = JFactory::getApplication();
		$input = $app->input;
		if ($app->isClient('administrator')) {
			if ($this->user_id) {
				$user = JFactory::getUser($this->user_id);
				$post = array(
					'name' => $input->getVar('system_user_name')
				);
				if ($buff = $input->getVar('username')) {
					$post['username'] = $buff;
				}
				if ($buff = $input->getVar('email')) {
					$post['email'] = $buff;
				}
				$password = $input->getVar('password');
				$password2 = $input->getVar('password2');

				if ($password and $password2) {
					if ($password != $password2) {
						$this->setError('FWFM_PASSWORDS_NOT_MATCH');
						return false;
					}
					$post['password'] = $password;
					$post['password2'] = $password2;
				}
				$user->bind($post);
				if (!$user->save()) {
					$this->setError($user->getError());
					return false;
				}
			} else {
				$conf = JComponentHelper::getParams('com_users');
				$post = array(
					'id' => null,
					'name' => $input->getVar('system_user_name'),
					'username' => $input->getVar('username'),
					'email' => $input->getVar('email'),
					'password' => $input->getVar('password'),
					'password2' => $input->getVar('password2'),
					'block' => 0,
					'groups' => array($conf->get('new_usertype', 2)),
					'registerDate' => date('Y-m-d H:i:s')
				);

				if ($post['password'] != $post['password2']) {
					$this->setError('FWFM_PASSWORDS_NOT_MATCH');
					return false;
				}

				$user = clone(JFactory::getUser(0));
				$user->bind($post);

				if ($user->save()) {
					$this->user_id = $user->id;
				} else {
					$this->setError($user->getError());
					return false;
				}
			}
		} else {
			$user = JFactory::getUser();
			if ($user->id) {
				$this->user_id = $user->id;
			} else {
				$this->setError(JText::_('FWFM_USER_ID_IS_NOT_SET'));
				return false;
			}
		}
		$db = JFactory::getDBO();
		$db->setQuery('SELECT COUNT(*) FROM `#__fwfoodmenu_profile` WHERE user_id = '.$this->user_id);
		if (!$db->loadResult()) {
			$db->setQuery('INSERT INTO `#__fwfoodmenu_profile` SET user_id = '.$this->user_id);
			$db->execute();
		}
		return true;
    }
}
