<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

class TableCategory extends JTable {
    var $id = null,
        $parent = null,
    	$name = null,
		$alias = null,
		$ordering = null,
		$published = null,
		$image = null,
        $image_size = null,
		$short_description = null,
		$description = null,
		$pdf_menu = null,
        $lang = null,
		$params = null;

    function __construct(&$db) {
		$this->params = new JRegistry();
        parent::__construct('#__fwfoodmenu_category', 'id', $db);
    }

	function load($oid = null, $reset = null) {
		if (parent::load($oid, $reset)) {
			$this->params = new JRegistry($this->params);
			JFactory::getApplication()->triggerEvent('onLoadCategory', array('com_fwfoodmenu', $this));
			return true;
		}
	}

    function bind($data, $skip=array()) {
        if ($data) {
            $app = JFactory::getApplication();
            $app->triggerEvent('onBindCategory', array('com_fwfoodmenu', $data, &$skip, $this));

			$keys = array_keys($this->getProperties());
            foreach ($data as $key=>$val) {
                if (!in_array($key, $keys) or ($skip and in_array($key, $skip))) {
                    continue;
                }
                $this->$key = $val;
            }
        }
        return true;
    }
    function check() {
		if (!$this->name) {
			$this->setError(JText :: _('FWFM_EMPTY_NAME'));
			return false;
		}

		$db = JFactory :: getDBO();
		if (!$this->id) {
			if (!$this->ordering) {
				$db->setQuery('SELECT MAX(ordering) FROM `#__fwfoodmenu_category` WHERE parent = '.(int)$this->parent);
				$this->ordering = 1 + (int)$db->loadResult();
			}
		}

		if (!$this->alias) $this->alias = $this->name;
		$this->alias = fwFoodMenuHelper::getCategoryAlias($this->id, $this->alias);

		$params = new JRegistry($this->params);
		$this->params = $params->toString();

        $app = JFactory::getApplication();
		$data = $app->triggerEvent('onCheckCategory', array('com_fwfoodmenu', $this));
		if ($data) {
			foreach ($data as $row) {
				if (!$row) {
					return;
				}
			}
		}
		return true;
    }
	function store($updn = null) {
		if (parent::store($updn)) {
			$input = JFactory::getApplication()->input;
			if ($input->getCmd('task') != 'copy') {
				JFactory::getApplication()->triggerEvent('onStoreCategory', array('com_fwfoodmenu', $this));
			}
			return true;
		}
	}
    function delete($oid = null) {
    	if ((int)$oid and $this->load($oid) and parent::delete($oid)) {
			jimport('joomla.filesystem.file');
			$path = JPATH_SITE.'/media/com_fwfoodmenu/menu/';
			if ($this->image and is_file($path.$this->image)) {
				JFile::delete($path.$this->image);
			}
			JFactory::getApplication()->triggerEvent('onDeleteCategory', array('com_fwfoodmenu', $this));
    		return true;
    	} else $this->setError(JText::_('FWFM_NO_CATEGORY_ID_PASSED'));
    }
}
