<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

class menuModelTranslation extends JModelLegacy {
    function getUserState($name, $def='', $type='cmd') {
        $app = JFactory::getApplication();
        $context = 'com_fwfoodmenu.language.';
        return $app->getUserStateFromRequest($context.$name, $name, $def, $type);
    }
	function getAddons() {
		$model = JModelLegacy::getInstance('addon', 'menuModel');
		$data = $model->getPluginsData();

		$params = JComponentHelper::getParams('com_fwfoodmenu');
		$params_changed = false;
		if ($remote_langs = json_decode($params->get('langs_data'))) {
			$list = fwFoodMenuHelper::getInstalledLanguages();
			foreach ($list as $row) {
				if ($params->get('translation_requested_'.$row->tag) and !empty($remote_langs->{$row->tag})) {
					$params->set('translation_requested_'.$row->tag, 0);
					$params_changed = true;
				}
			}
		}
		if ($params_changed) {
			fwFoodMenuHelper::storeConfig($params);
		}

		return $data;
	}
	function getLanguageData($ext) {
		jimport('joomla.filesystem.file');
		$langs = fwFoodMenuHelper::getInstalledLanguages();
		$lang = JArrayHelper::getValue($langs, fwFoodMenuHelper::getLanguage());

		$search = $this->getUserState('search', '', 'string');

		$path = '';
		$filename = '';

		switch ($ext->type) {
			case 'component' :
				$type = (int)$this->getUserState('type', 0, 'int');
				$path = $type?FWFM_LANGUAGE_SITE:FWFM_LANGUAGE_ADMINISTRATOR;
				$filename = $ext->_element;
			break;
			case 'module' :
			case 'template' :
				$path = FWFM_LANGUAGE_SITE;
				$filename = $ext->_element;
			break;
			case 'plugin' :
				$path = FWFM_LANGUAGE_ADMINISTRATOR;
				$filename = 'plg_'.$ext->folder.'_'.$ext->_element;
			break;
		}

		$prefix = class_exists('JVersion')?'':'.wp';

		$src_file = $path.'/language/en-GB/en-GB'.$prefix.'.'.$filename.'.ini';
		$src_buff = file_exists($src_file)?explode("\n", file_get_contents($src_file)):array();
		$result = array();
		foreach ($src_buff as $i=>$row) if (trim($row)) {
			$row = explode("=", trim($row), 2);
			if (count($row) < 2) continue;
			$row[1] = trim($row[1], '"');
			if (!empty($row[1]) and (!$search or ($search and (mb_stripos($row[0], $search) !== false or mb_stripos($row[1], $search) !== false)))) {
				$result[$row[0]] = array(
					'src' => $row[1],
					'trg' => ''
				);
			}
		}

		$trg_file = $path.'/language/'.$lang->tag.'/'.$lang->tag.$prefix.'.'.$filename.'.ini';
		$trg_buff = file_exists($trg_file)?explode("\n", file_get_contents($trg_file)):array();
		foreach ($trg_buff as $i=>$row) if (trim($row)) {
			$row = explode("=", trim($row), 2);
			if (!empty($row[1]) and (!$search or ($search and (mb_stripos($row[0], $search) !== false or mb_stripos($row[1], $search) !== false)))) {
				if (isset($result[$row[0]])) {
					$result[$row[0]]['trg'] = trim($row[1], '"');
				} else {
					$found = false;
					foreach ($src_buff as $srow) {
						$srow = explode('=', trim($srow), 2);
						if ($srow[0] == $row[0]) {
							$found = true;
							$result[$row[0]] = array(
								'src' => trim($srow[1], '"'),
								'trg' => trim($row[1], '"')
							);
							break;
						}
					}
					if (!$found) {
						$result[$row[0]] = array(
							'src' => '',
							'trg' => trim($row[1], '"')
						);
					}
				}
			}
		}

		/* load overrides */
		$trg_file = $path.'/language/overrides/'.$lang->tag.$prefix.'.override.ini';
		$trg_buff = file_exists($trg_file)?explode("\n", file_get_contents($trg_file)):array();

		foreach ($trg_buff as $i=>$row) if (trim($row)) {
			$row = explode("=", trim($row), 2);
			if (!empty($row[1]) and (isset($result[$row[0]]) or !$search or ($search and (mb_stripos($row[0], $search) !== false or mb_stripos($row[1], $search) !== false)))) {
				if (isset($result[$row[0]])) {
					$result[$row[0]]['trg'] = trim($row[1], '"');
					$result[$row[0]]['override'] = true;
				}
			}
		}

		return $result;
	}
	function getLanguageOverridesFilename() {
		$langs = fwFoodMenuHelper::getInstalledLanguages();
		$lang = JArrayHelper::getValue($langs, fwFoodMenuHelper::getLanguage());
		$exts = $this->loadExtensions();
		$ext = $this->getExtension($exts, $this->getUserState('extension', 'com_fwfoodmenu', 'string'));
		$path = '';
		$prefix = class_exists('JVersion')?'':'.wp';
		switch ($ext->type) {
			case 'component' :
				$type = (int)$this->getUserState('type', 0, 'int');
				$path = $type?FWFM_LANGUAGE_SITE:FWFM_LANGUAGE_ADMINISTRATOR;
			break;
			case 'module' :
			case 'template' :
				$path = FWFM_LANGUAGE_SITE;
			break;
			case 'plugin' :
				$path = FWFM_LANGUAGE_ADMINISTRATOR;
			break;
		}

		return $path.'/language/overrides/'.$lang->tag.$prefix.'.override.ini';
	}
	function getLanguageFilename() {
		$langs = fwFoodMenuHelper::getInstalledLanguages();
		$lang = JArrayHelper::getValue($langs, fwFoodMenuHelper::getLanguage());
		$type = (int)$this->getUserState('type', 0, 'int');
		$exts = $this->loadExtensions();
		$ext = $this->getExtension($exts, $this->getUserState('extension', 'com_fwfoodmenu', 'string'));
		$prefix = class_exists('JVersion')?'':'.wp';

		$path = '';
		$filename = '';

		switch ($ext->type) {
			case 'component' :
				$type = (int)$this->getUserState('type', 0, 'int');
				$path = $type?FWFM_LANGUAGE_SITE:FWFM_LANGUAGE_ADMINISTRATOR;
				$filename = $ext->_element;
			break;
			case 'module' :
			case 'template' :
				$path = FWFM_LANGUAGE_SITE;
				$filename = $ext->_element;
			break;
			case 'plugin' :
				$path = FWFM_LANGUAGE_ADMINISTRATOR;
				$filename = 'plg_'.$ext->folder.'_'.$ext->_element;
			break;
		}
		return $path.'/language/'.$lang->tag.'/'.$lang->tag.$prefix.'.'.$filename.'.ini';
	}
	function copy() {
		$input = JFactory::getApplication()->input;

		$cid = $input->getVar('cid');
		$lang_data = $input->getVar('lang_data');

		$tag = $input->getCmd('tag');
		$text = $input->gethtml('text');

		$langs = fwFoodMenuHelper::getInstalledLanguages();
		$lang = JArrayHelper::getValue($langs, fwFoodMenuHelper::getLanguage());

		$exts = $this->loadExtensions();
		$ext = $this->getExtension($exts, $this->getUserState('extension', 'com_fwfoodmenu', 'string'));
		$prefix = class_exists('JVersion')?'':'.wp';

		$path = '';
		switch ($ext->type) {
			case 'component' :
				$type = (int)$this->getUserState('type', 0, 'int');
				$path = $type?FWFM_LANGUAGE_SITE:FWFM_LANGUAGE_ADMINISTRATOR;
			break;
			case 'module' :
			case 'template' :
				$path = FWFM_LANGUAGE_SITE;
			break;
			case 'plugin' :
				$path = FWFM_LANGUAGE_ADMINISTRATOR;
			break;
		}

		$trg_file = $path.'/language/overrides/'.$lang->tag.$prefix.'.override.ini';

		$result = array();
/* load existing values */
		$trg_buff = file_exists($trg_file)?explode("\n", file_get_contents($trg_file)):array();
		foreach ($trg_buff as $i=>$row) {
			if (trim($row)) {
				$row = explode("=", trim($row), 2);
				if (!empty($row[1])) {
					$result[$row[0]] = trim($row[1], '"');
				}
			}
		}

		if (is_array($cid) and is_array($lang_data)) {
			foreach ($cid as $tag) {
				if (isset($lang_data[$tag])) {
					$result[$tag] = $lang_data[$tag];
				}
			}
		}

		$buff = '';
		foreach ($result as $const=>$val) {
			$buff .= $const.'="'.str_replace(array("\r", "\n", "\t"), ' ', $val).'"'."\n";
		}

/* store updated language file */
		jimport('joomla.filesystem.file');
		if (JFile::write($trg_file, $buff)) {
			$this->setError(JText::_('FWFM_LANGUAGE_FILE_SUCCESFULLY_UPDATED'));
			return true;
		} else {
			$this->setError(JText::_('FWFM_LANGUAGE_CANT_WRITE_FILE'));
		}

	}
	function _save() {
		$langs = fwFoodMenuHelper::getInstalledLanguages();
		$lang = JArrayHelper::getValue($langs, fwFoodMenuHelper::getLanguage());
		$input = JFactory::getApplication()->input;

		$exts = $this->loadExtensions();
		$ext = $this->getExtension($exts, $this->getUserState('extension', 'com_fwfoodmenu', 'string'));
		$prefix = class_exists('JVersion')?'':'.wp';

		$path = '';
		$filename = '';

		switch ($ext->type) {
			case 'component' :
				$type = (int)$this->getUserState('type', 0, 'int');
				$path = $type?FWFM_LANGUAGE_SITE:FWFM_LANGUAGE_ADMINISTRATOR;
				$filename = $ext->_element;
			break;
			case 'module' :
			case 'template' :
				$path = FWFM_LANGUAGE_SITE;
				$filename = $ext->_element;
			break;
			case 'plugin' :
				$path = FWFM_LANGUAGE_ADMINISTRATOR;
				$filename = 'plg_'.$ext->folder.'_'.$ext->_element;
			break;
		}

		$trg_file = $path.'/language/'.$lang->tag.'/'.$lang->tag.$prefix.'.'.$filename.'.ini';

		$result = array();
/* load existing values */
		$trg_buff = file_exists($trg_file)?explode("\n", file_get_contents($trg_file)):array();
		foreach ($trg_buff as $i=>$row) {
			if (trim($row)) {
				$row = explode("=", trim($row), 2);
				if (!empty($row[1])) {
					$result[$row[0]] = trim($row[1], '"');
				}
			}
		}

/* update changes */
		if ($data = (array)$input->getRaw('lang_data')) {
			foreach ($data as $const => $val) {
				$result[$const] = $val;
			}

/* collect language file */
			$buff = "\n";
			foreach ($result as $const=>$val) {
				$buff .= $const.'="'.str_replace(array("\r", "\n", "\t"), ' ', $val).'"'."\n";
			}

/* store updated language file */
			jimport('joomla.filesystem.file');
			if (JFile::write($trg_file, $buff)) {
				$this->setError(JText::_('FWFM_LANGUAGE_FILE_SUCCESFULLY_UPDATED'));
				return true;
			} else {
				$this->setError(JText::_('FWFM_LANGUAGE_CANT_WRITE_FILE'));
			}
		}
	}
	function getExtension($exts, $ext_element) {
		foreach ($exts as $ext) {
			if ($ext->element == $ext_element) {
				return $ext;
			}
		}
		return $exts[0];
	}
	function loadExtensions() {
		$db = JFactory::getDBO();
		$db->setQuery('SELECT `element`, `folder`, `type`, `name`, client_id FROM `#__extensions` WHERE (`element` LIKE \'%fwfm%\' OR `element` LIKE \'%fwfood%\' OR `folder` = \'fwfoodmenu\') ORDER BY `element`');
		if ($list = $db->loadObjectList()) {
			$prefix = class_exists('JVersion')?'':'.wp';
			foreach ($list as $i => $row) {
				$list[$i]->_name = $row->name;
				$list[$i]->_element = $row->element;
/*				if ($row->folder) {
					$list[$i]->element .= '-'.$row->folder;
				}*/

				$path = '';
				if (($row->type == 'template' or $row->type == 'module') and $row->client_id == 0) {
					$path = FWFM_LANGUAGE_SITE.'/language/en-GB/en-GB'.$prefix.'.';
				} else {
					$path = FWFM_LANGUAGE_ADMINISTRATOR.'/language/en-GB/en-GB'.$prefix.'.';
				}
				$name = '';
				if ($row->type == 'plugin') {
					$filename = $path.'plg_'.strtolower($row->folder).'_'.strtolower($row->element).'.sys.ini';
				} else {
					$filename = $path.strtolower($row->element).'.sys.ini';
				}

				if (file_exists($filename)) {
					$buff = file_get_contents($filename);
					if (preg_match('#'.$row->name.'\="(.+)"#i', $buff, $match)) {
						$name = $match[1];
					} elseif (preg_match('#FW_FOODMENU_'.$row->element.'\="(.+)"#i', $buff, $match)) {
						$name = $match[1];
					}
				}
				if ($name) {
					$list[$i]->name = $name;
				}
				if ($row->type) {
					$list[$i]->name .= ' ['.JText::_('FWFM_'.$row->type).']';
				}
			}

			JArrayHelper::sortObjects($list, array('name'), $direction = 1, $caseSensitive = false);

			return $list;
		}
	}
	function getPagination(&$data) {
		jimport('joomla.html.pagination');
		$app = JFactory::getApplication();

		$limitstart = (int)$app->input->getInt('limitstart');
		$limit = (int)$app->input->getInt('limit', $app->getCfg('list_limit', 20));
		$qty = count($data);

		if ($qty > $limit) {
			$data = array_slice($data, $limitstart, $limit);
		}

		return new JPagination(
			$qty,
			$limitstart,
			$limit
		);
	}
	function request($is_reinstall=false) {
		$langs = fwFoodMenuHelper::getInstalledLanguages();
		$lang = JArrayHelper::getValue($langs, fwFoodMenuHelper::getLanguage());
		$params = JComponentHelper::getParams('com_fwfoodmenu');

		$exts = $this->loadExtensions();
		$ext = $this->getExtension($exts, $this->getUserState('extension', 'com_fwfoodmenu', 'string'));
		$prefix = class_exists('JVersion')?'':'.wp';
		$version = $type = '';

		$path = array();
		$filename = '';
		$xml_filename = '';
		$result = false;

		switch ($ext->type) {
			case 'component' :
				$type = (int)$this->getUserState('type', 0, 'int');
				$path['site'] = FWFM_LANGUAGE_SITE;
				$path['admin'] = FWFM_LANGUAGE_ADMINISTRATOR;
				$filename = $ext->_element;
				$xml_filename = '/administrator/components/'.$filename.'/'.str_replace('com_', '', $filename).'.xml';
			break;
			case 'module' :
				$path['site'] = FWFM_LANGUAGE_SITE;
				$filename = $ext->_element;
				$xml_filename = '/modules/'.$filename.'/'.$filename.'.xml';
			break;
			case 'template' :
				$path['site'] = FWFM_LANGUAGE_SITE;
				$filename = $ext->_element;
				$xml_filename = '/templates/'.$filename.'/templateDetails.xml';
			break;
			case 'plugin' :
				$path['admin'] = FWFM_LANGUAGE_ADMINISTRATOR;
				$filename = 'plg_'.$ext->folder.'_'.$ext->_element;
				$xml_filename = '/plugins/'.$ext->folder.'/'.$filename.'/'.$filename.'.xml';
			break;
		}
		if ($xml_filename) {
			$xml_filename = JPATH_SITE.$xml_filename;
			if (file_exists($xml_filename)) {
				$buff = file_get_contents($xml_filename);
				if (preg_match('#<version>(.*)</version>#i', $buff, $match)) {
					$version = $match[1];
				}
			}
		}
		$data = json_decode(fwFoodMenuHelper::request(FWA_UPDATE_SERVER.'/index.php?option=com_fwtranslation&layout=translate&format=json&access_code='.$params->get('update_code').'&ext='.$filename.'&version='.$version.'&lang='.$lang->tag.'&cms='.(class_exists('JVersion')?'joomla':'wp')));

		if (!empty($data->result)) {
			$qty = 0;
			foreach ($data->result as $type=>$files) {
				foreach ($files as $lang_filename=>$text) {
					if (preg_match('#\.ini$#', $lang_filename) and !empty($path[$type])) {
						$trg_file = $path[$type].'/language/'.$lang->tag.'/'.$lang_filename;
						$folder = dirname($trg_file);
						if (!file_exists($folder)) {
							JFolder::create($folder);
						}
						if (file_exists($folder) and file_put_contents($trg_file, $text)) {
							$qty++;
						}
					}
				}
			}
			if ($qty) {
				$result = true;
				$this->setError(JText::_($is_reinstall?'FWFM_LANGUAGE_FILES_REINSTALLED':'FWFM_LANGUAGE_FILES_INSTALLED'));
			} else {
				$this->setError(JText::_('FWFM_NO_FILES_RECEIVED_FROM_TRANSLATION_SERVER'));
			}
		} else {
			$lang = false;
			if (!empty($data->msg)) {
				$this->setError($data->msg);
			} else {
				$this->setError(JText::_('FWFM_NO_RESPONSE_FROM_TRANSLATION_SERVER'));
			}
		}
		if ($lang) {
			$params->set('translation_requested_'.$lang->tag, 1);
			fwFoodMenuHelper::storeConfig($params);
		}
		return $result;
	}
	function upload() {
		$langs = fwFoodMenuHelper::getInstalledLanguages();
		$lang = JArrayHelper::getValue($langs, fwFoodMenuHelper::getLanguage());
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		$exts = $this->loadExtensions();
		$ext = $this->getExtension($exts, $this->getUserState('extension', 'com_fwfoodmenu', 'string'));
		// $prefix = class_exists('JVersion')?'':'.wp';
		$version = $type = '';

		$updatename = '';
		$xml_filename = '';

		switch ($ext->type) {
			case 'component' :
				$type = (int)$this->getUserState('type', 0, 'int');
				$path = $type?FWFM_LANGUAGE_SITE:FWFM_LANGUAGE_ADMINISTRATOR;
				$updatename = $ext->_element;
				$xml_filename = '/administrator/components/'.$updatename.'/'.str_replace('com_', '', $updatename).'.xml';
			break;
			case 'module' :
				$path = FWFM_LANGUAGE_SITE;
				$updatename = $ext->_element;
				$xml_filename = '/modules/'.$updatename.'/'.$updatename.'.xml';
			break;
			case 'template' :
				$path = FWFM_LANGUAGE_SITE;
				$updatename = $ext->_element;
				$xml_filename = '/templates/'.$updatename.'/templateDetails.xml';
			break;
			case 'plugin' :
				$path = FWFM_LANGUAGE_ADMINISTRATOR;
				$updatename = 'plg_'.$ext->folder.'_'.$ext->_element;
				$xml_filename = '/plugins/'.$ext->folder.'/'.$updatename.'/'.$updatename.'.xml';
			break;
		}
		if ($xml_filename) {
			$xml_filename = JPATH_SITE.$xml_filename;
			if (file_exists($xml_filename)) {
				$buff = file_get_contents($xml_filename);
				if (preg_match('#<version>(.*)</version>#i', $buff, $match)) {
					$version = $match[1];
				}
			}
		}

		$filename = $path.'/language/overrides/'.$lang->tag.'.override.ini';
		if ($filename and file_exists($filename)) {
			$params = JComponentHelper::getParams('com_fwfoodmenu');
			$data = array(
				'format' => 'json',
				'ext' => $updatename,
				'is_site' => $type,
				'lang' => $lang->tag,
				'version' => $version,
				'access_code' => $params->get('update_code'),
				'cms' => (class_exists('JVersion')?'joomla':'wp'),
				'file' => function_exists('curl_file_create')?curl_file_create($filename):('@'.realpath($filename))
			);
			$buff = json_decode(fwFoodMenuHelper::request(
				FWA_UPDATE_SERVER.'/index.php?option=com_fwtranslation&view=fwtranslation&layout=upload',
				'post',
				$data,
				array('Content-Type'=>'multipart/form-data')
			));
			if (!empty($buff->msg)) {
				$this->setError($buff->msg);
			}
			if (!empty($buff->result)) {
				$this->setError(JText::_('FWFM_LANGUAGE_FILE_SUCCESFULLY_UPLOADED'));
				return $buff->result;
			}
		} else $this->setError(JText::_('FWFM_LANGUAGE_FILE_NOT_FOUND'));
	}
}
