<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

if (!function_exists('com_install')) {
	function com_install() {
		com_fwfoodmenuInstallerScript :: update($adaptor = null);
	}
}

if (!class_exists('com_fwfoodmenuInstallerScript')) {
	class com_fwfoodmenuInstallerScript {
		function install($adaptor) {
			return $this->update($adaptor);
		}
		function update($adaptor) {
			$db = JFactory :: getDBO();
			$tables = $db->getTableList();

			if (in_array($db->getPrefix().'fwfoodmenu_badge', $tables)) {
				$db->setQuery('SHOW FIELDS FROM #__fwfoodmenu_badge');
				$fields = $db->loadColumn();
				if (!in_array('lang', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_badge` ADD COLUMN `lang` CHAR(5) NULL');
					$db->execute();
				}
				if (!in_array('image', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_badge` ADD COLUMN `image` VARCHAR(250) NULL');
					$db->execute();
				}
				if (!in_array('type', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_badge` ADD COLUMN `type` ENUM(\'promo\', \'ingredient\', \'allergen\', \'type\') NULL');
					$db->execute();
				}
			} else {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_badge` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`ordering` INT(10) UNSIGNED NOT NULL DEFAULT 0,
	`name` VARCHAR(50) NULL DEFAULT NULL,
	`icon` VARCHAR(50) NULL DEFAULT NULL,
	`color` VARCHAR(6) NULL DEFAULT NULL,
	`image` VARCHAR(250) NULL DEFAULT NULL,
	`type` ENUM(\'promo\', \'ingredient\', \'allergen\', \'type\') NULL,
	`lang` CHAR(5) NOT NULL DEFAULT \'en-GB\',
	PRIMARY KEY (`id`),
	INDEX `ordering` (`ordering`)
)'
				);
				if ($db->execute()) {
					$db->setQuery("INSERT INTO `#__fwfoodmenu_badge` (name, icon, ordering) VALUES ('vegan', 'seeding', 1), ('healthy food', 'child', 2), ('organic', 'pagelines', 3), ('farm fresh', 'tractor', 4), ('spicy', 'papper-hot', 5), ('eco', 'leaf', 6)");
					$db->execute();
				}
			}

			if (in_array($db->getPrefix().'fwfoodmenu_translations', $tables)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_translations` MODIFY `lang` CHAR(5) NOT NULL');
				$db->execute();
				$db->setQuery('SELECT DISTINCT `lang` FROM `#__fwfoodmenu_translations`');
				if ($buff = $db->loadColumn()) {
					$langs = array('en'=>'en-GB', 'ar'=>'ar-AA', 'de'=>'de-DE', 'el'=>'el-GR', 'es'=>'es-ES', 'fr'=>'fr-FR', 'it'=>'it-IT', 'pt'=>'pt-PT', 'ru'=>'ru-RU', 'tr'=>'tr-TR', 'uk'=>'uk-UA', 'zh'=>'zh-CN');
					foreach ($buff as $ln) {
						if (!empty($langs[$ln])) {
							$db->setQuery('UPDATE `#__fwfoodmenu_translations` SET `lang` = '.$db->quote($langs[$ln]).' WHERE `lang` = '.$db->quote($ln));
							$db->execute();
						}
					}
				}
			} else {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_translations` (
	`obj_id` INT(10) UNSIGNED NOT NULL,
	`key` VARCHAR(50) NOT NULL,
	`lang` CHAR(5) NOT NULL,
	`text` TEXT NULL,
	INDEX (`obj_id`),
	INDEX(`key`),
	INDEX(`lang`)
)'
				);
				$db->execute();
			}
			if (!in_array($db->getPrefix().'fwfoodmenu_menu_badge', $tables)) {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_menu_badge` (
	`menu_id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`badge_id` INT(10) UNSIGNED NOT NULL DEFAULT 0,
	INDEX (`menu_id`),
	INDEX (`badge_id`)
)'
				);
				$db->execute();
			}
			if (in_array($db->getPrefix().'fwfoodmenu_menu_price', $tables)) {
				$db->setQuery('SHOW FIELDS FROM #__fwfoodmenu_menu_price');
				$fields = $db->loadColumn();
				if (!in_array('lang', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_menu_price` ADD COLUMN `lang` CHAR(5)');
					$db->execute();
				}
			} else {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_menu_price` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`menu_id` INT(10) UNSIGNED NULL DEFAULT NULL,
	`ordering` INT(10) UNSIGNED NOT NULL DEFAULT 0,
	`name` VARCHAR(50) NULL DEFAULT NULL,
	`size` VARCHAR(50) NULL DEFAULT NULL,
	`price` DECIMAL(10,2) NULL DEFAULT NULL,
	`special_price` DECIMAL(10,2) NULL DEFAULT NULL,
	`energy` VARCHAR(20) NULL DEFAULT NULL,
	`lang` CHAR(5) NOT NULL DEFAULT \'en-GB\',
	PRIMARY KEY (`id`),
	INDEX `name` (`name`),
	INDEX `ordering` (`ordering`),
	INDEX `menu_id` (`menu_id`)
)'
				);
				if ($db->execute()) {
					$db->setQuery('INSERT INTO `#__fwfoodmenu_menu_price` (menu_id, size, price, special_price, energy) SELECT id, weight, price, special_price, energy FROM `#__fwfoodmenu_menu`');
					$db->execute();
				}
			}
			if (in_array($db->getPrefix().'fwfoodmenu_cart', $tables)) {
				$db->setQuery('SHOW FIELDS FROM #__fwfoodmenu_cart');
				$fields = $db->loadColumn();

                if (!in_array('params', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_cart` ADD COLUMN `params` TEXT NULL');
					$db->execute();
				}
			} else {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_cart` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`created` TIMESTAMP NOT NULL DEFAULT NOW(),
	`menu_price_id` INT(10) UNSIGNED NULL DEFAULT NULL,
	`session_id` VARCHAR(192) NULL,
	`qty` INT UNSIGNED NOT NULL DEFAULT 0,
	`params` TEXT NULL,
	PRIMARY KEY (`id`),
	INDEX `menu_price_id` (`menu_price_id`),
	INDEX `session_id` (`session_id`)
)'
				);
				$db->execute();
			}
			if (!in_array($db->getPrefix().'fwfoodmenu_order_statuschage', $tables)) {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_order_statuschage` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`order_id` INT(10) UNSIGNED NOT NULL,
	`created` TIMESTAMP NOT NULL DEFAULT NOW(),
	`status` ENUM(\'pending\', \'paid\', \'confirmed\', \'prepared\', \'shipped\', \'delivered\', \'completed\', \'cancelled\', \'refunded\') NOT NULL DEFAULT \'pending\',
	PRIMARY KEY (`id`),
	INDEX `order_id` (`order_id`)
)'
				);
				$db->execute();
			}
			if (!in_array($db->getPrefix().'fwfoodmenu_order_profile', $tables)) {
				$db->setQuery('
CREATE TABLE IF NOT EXISTS `#__fwfoodmenu_profile` (
	`user_id` int(10) unsigned NOT NULL,
	`logo` varchar(50) DEFAULT NULL,
	`tel` varchar(30) DEFAULT NULL,
	`mobile` varchar(30) DEFAULT NULL,
	`address` varchar(200) DEFAULT NULL,
	PRIMARY KEY (`user_id`)
)'
				);
				$db->execute();
			}

			if (in_array($db->getPrefix().'fwfoodmenu_order', $tables)) {
				$db->setQuery('SHOW FIELDS FROM #__fwfoodmenu_order');
				$fields = $db->loadColumn();

				if (!in_array('payment_gate_id', $fields)) {
					/* cash = 1, paypal - 2, stripe - 3 */
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `payment_gate_id` INT UNSIGNED NULL');
					$db->execute();
				}
				if (!in_array('delivery_option', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `delivery_option` VARCHAR(100) NULL');
					$db->execute();
				}
				if (!in_array('delivery_code', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `delivery_code` VARCHAR(20) NULL');
					if ($db->execute()) {
						$db->setQuery('UPDATE `#__fwfoodmenu_order` SET `delivery_code` = \'courier\' WHERE `delivery` > 0');
						$db->execute();
						$db->setQuery('UPDATE `#__fwfoodmenu_order` SET `delivery_code` = \'pickup\' WHERE `delivery` = 0');
						$db->execute();
					}
				}
				if (!in_array('address', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `address` TEXT NULL');
					$db->execute();
				}
				if (!in_array('params', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `params` TEXT NULL');
					$db->execute();
				}
				if (!in_array('lang', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `lang` CHAR(5)');
					$db->execute();
				}
				if (!in_array('delivery', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `delivery` DECIMAL(12,2) NOT NULL DEFAULT 0');
					$db->execute();
				}
				if (!in_array('tax', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `tax` DECIMAL(12,2) NOT NULL DEFAULT 0');
					$db->execute();
				}
				if (!in_array('paid', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `paid` datetime NULL');
					$db->execute();
				}
				if (!in_array('status_updated', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `status_updated` datetime NULL');
					$db->execute();
					$db->setQuery('UPDATE `#__fwfoodmenu_order` SET `status_updated` = `created`');
					$db->execute();
				}
				if (in_array('status', $fields)) {
					$db->setQuery('UPDATE `#__fwfoodmenu_order` SET `status` = \'pending\' WHERE `status` = \'paid\'');
					$db->execute();
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` CHANGE COLUMN `status` `status` ENUM(\'pending\', \'confirmed\', \'prepared\', \'shipped\', \'delivered\', \'completed\', \'cancelled\', \'refunded\') NOT NULL DEFAULT \'pending\'');
					$db->execute();
				} else {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order` ADD COLUMN `status` ENUM(\'pending\', \'confirmed\', \'prepared\', \'shipped\', \'delivered\', \'completed\', \'cancelled\', \'refunded\') NOT NULL DEFAULT \'pending\'');
					$db->execute();
				}
			} else {
				$db->setQuery('CREATE TABLE `#__fwfoodmenu_order` (
					`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
					`created` datetime NOT NULL,
					`payment_gate_id` INT UNSIGNED NULL,
					`delivery_code` VARCHAR(20) NULL,
					`delivery_option` VARCHAR(100),
					`booked_on` datetime NOT NULL,
					`paid` datetime NULL,
					`status` ENUM(\'pending\', \'confirmed\', \'prepared\', \'shipped\', \'delivered\', \'completed\', \'cancelled\', \'refunded\') NOT NULL DEFAULT \'pending\',
					`status_updated` datetime NULL,
					`amount` DECIMAL(12,2) NOT NULL,
					`delivery` DECIMAL(12,2) NOT NULL DEFAULT 0,
					`tax` DECIMAL(12,2) NOT NULL DEFAULT 0,
					`name` VARCHAR(100) NULL,
					`email` VARCHAR(200) NULL,
					`phone` VARCHAR(100) NULL,
					`address` TEXT NULL,
					`comments` TEXT NULL,
					`params` TEXT NULL,
					`lang` CHAR(5) NOT NULL DEFAULT \'en-GB\',
					PRIMARY KEY (`id`),
					INDEX `created` (`created`),
					INDEX `booked_on` (`booked_on`))'
				);
				$db->execute();
			}
			if (in_array($db->getPrefix().'fwfoodmenu_order_items', $tables)) {
				$db->setQuery('SHOW FIELDS FROM #__fwfoodmenu_order_items');
				$fields = $db->loadColumn();
				if (!in_array('subname', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order_items` ADD COLUMN subname VARCHAR(200) NULL');
					$db->execute();
				}
				if (!in_array('params', $fields)) {
					$db->setQuery('ALTER TABLE `#__fwfoodmenu_order_items` ADD COLUMN `params` TEXT NULL');
					$db->execute();
				}
			} else {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_order_items` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`order_id` INT(10) UNSIGNED NOT NULL,
	`menu_price_id` INT(10) UNSIGNED NOT NULL,
	`name` VARCHAR(200) NOT NULL,
	`subname` VARCHAR(200) NULL,
	`qty` INT UNSIGNED NOT NULL DEFAULT 0,
	`price` decimal(12,2) not null,
	`params` TEXT NULL,
	PRIMARY KEY (`id`),
	INDEX `order_id` (`order_id`)
)'
				);
				$db->execute();
			}
			if (!in_array($db->getPrefix().'fwfoodmenu_menu_modificator_group', $tables)) {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_menu_modificator_group` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`menu_id` INT(10) UNSIGNED NOT NULL,
	`name` VARCHAR(200) NOT NULL,
	`is_required` TINYINT UNSIGNED NOT NULL DEFAULT 0,
	`lang` CHAR(5) NOT NULL DEFAULT \'en-GB\',
	PRIMARY KEY (`id`),
	INDEX `menu_id` (`menu_id`)
)'
				);
				$db->execute();
			}
			if (!in_array($db->getPrefix().'fwfoodmenu_menu_modificator', $tables)) {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_menu_modificator` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`menu_modificator_group_id` INT(10) UNSIGNED NOT NULL,
	`name` VARCHAR(200) NOT NULL,
	`size` VARCHAR(200) NOT NULL,
	`price` decimal(12,2) not null,
	`special_price` decimal(12,2) not null,
	`lang` CHAR(5) NOT NULL DEFAULT \'en-GB\',
	PRIMARY KEY (`id`),
	INDEX `menu_modificator_group_id` (`menu_modificator_group_id`)
)'
				);
				$db->execute();
			}
			$db->setQuery('SHOW FIELDS FROM #__fwfoodmenu_category');
			$fields = $db->loadColumn();

			if (!in_array('lang', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN `lang` CHAR(5)');
				$db->execute();
			}
			if (!in_array('image', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN image VARCHAR(200)');
				$db->execute();
			}
			if (!in_array('image_size', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN image_size INT UNSIGNED DEFAULT NULL');
				$db->execute();
			}
			if (!in_array('parent', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN parent int unsigned not null default 0, add index(parent)');
				$db->execute();
			}
			if (!in_array('params', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN params TEXT NULL');
				$db->execute();
			}
			if (!in_array('alias', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN alias VARCHAR(200) NULL');
				if ($db->execute()) {
					$db->setQuery('SELECT id, name FROM `#__fwfoodmenu_category`');
					if ($list = $db->loadObjectList()) {
						foreach ($list as $row) {
							if (!$row->name) continue;
							$db->setQuery('UPDATE `#__fwfoodmenu_category` SET alias = '.$db->quote(JFilterOutput::stringURLSafe($row->name)).' WHERE id = '.(int)$row->id);
							$db->execute();
						}
					}
				}
			}
			if (!in_array('short_description', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN short_description varchar(250) null');
				$db->execute();
			}
			if (!in_array('pdf_menu', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN pdf_menu varchar(250) null');
				$db->execute();
			}

			if (!in_array('metadescr', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN metadescr varchar(250) null');
				$db->execute();
			}
			if (!in_array('metakey', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_category` ADD COLUMN metakey varchar(250) null');
				$db->execute();
			}

			$db->setQuery('SHOW FIELDS FROM #__fwfoodmenu_menu');
			$fields = $db->loadColumn();

			if (!in_array('is_online', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_menu` ADD COLUMN `is_online` TINYINT UNSIGNED NULL');
				if ($db->execute()) {
					$db->setQuery('UPDATE `#__fwfoodmenu_menu` SET `is_online` = 1');
					$db->execute();
				}
			}
			if (!in_array('has_vat', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_menu` ADD COLUMN `has_vat` TINYINT UNSIGNED NULL');
				if ($db->execute()) {
					$db->setQuery('UPDATE `#__fwfoodmenu_menu` SET `has_vat` = 1');
					$db->execute();
				}
			}
			if (!in_array('params', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_menu` ADD COLUMN params TEXT NULL');
				$db->execute();
			}
			if (!in_array('is_new', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_menu` ADD COLUMN is_new tinyint unsigned default NULL');
				$db->execute();
			}
			if (!in_array('is_recommended', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_menu` ADD COLUMN is_recommended tinyint unsigned default NULL');
				$db->execute();
			}
			if (!in_array('image_size', $fields)) {
				$db->setQuery('ALTER TABLE `#__fwfoodmenu_menu` ADD COLUMN image_size int unsigned default NULL');
				$db->execute();
				$db->setQuery('SELECT id, `image` FROM `#__fwfoodmenu_menu` WHERE image IS NOT NULL');
				if ($list = $db->loadObjectList()) {
					$path = JPATH_SITE.'/media/com_fwfoodmenu/menu/';
					foreach ($list as $row) {
						if ($row->image and file_exists($path.$row->image)) {
							$db->setQuery('UPDATE `#__fwfoodmenu_menu` SET image_size = '.(int)filesize($path.$row->image).' WHERE id = '.(int)$row->id);
							$db->execute();
						}
					}
				}
			}
			if (!in_array($db->getPrefix().'fwfoodmenu_menu_image', $tables)) {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_menu_image` (
	`id` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	`menu_id` INT(10) UNSIGNED NULL DEFAULT NULL,
	`image` varchar(200) default NULL,
	`image_size` int unsigned default NULL,
	`ordering` INT(10) UNSIGNED NOT NULL DEFAULT 0,

	PRIMARY KEY (`id`),
	INDEX `menu_id` (`menu_id`),
	INDEX `ordering` (`ordering`)
)'
				);
				if ($db->execute()) {
					$db->setQuery('SELECT id, `image`, image_size FROM `#__fwfoodmenu_menu` WHERE image IS NOT NULL');
					if ($list = $db->loadObjectList()) {
						$path = JPATH_SITE.'/media/com_fwfoodmenu/menu/';
						foreach ($list as $row) {
							if ($row->image and file_exists($path.$row->image)) {
								$db->setQuery('INSERT INTO `#__fwfoodmenu_menu_image` SET ordering = 1, `image` = '.$db->quote($row->image).', image_size = '.(int)$row->image_size.', menu_id = '.(int)$row->id);
								$db->execute();
							}
						}
					}
				}
			}

			if (!in_array($db->getPrefix().'fwfoodmenu_pwa', $tables)) {
				$db->setQuery('
CREATE TABLE `#__fwfoodmenu_pwa` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `user_type` enum(\'manager\',\'customer\') DEFAULT NULL,
  `type` enum(\'apple\',\'expo\',\'vapid\') DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `endpoint` varchar(250) DEFAULT NULL,
  `auth` varchar(250) DEFAULT NULL,
  `p256dh` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
)'
				);
				$db->execute();
			}


			jimport('joomla.filesystem.file');
			$path = JPATH_SITE.'/components/com_fwfoodmenu/views/menu/tmpl/grid.xml';
			if (file_exists($path)) {
				JFile::delete($path);
			}

			/* check extensions params size */
			$db->setQuery('SHOW FIELDS FROM `#__extensions` WHERE Field = \'params\'');
			if ($field = $db->loadObject() and strtolower($field->Type) == 'text') {
				$db->setQuery('ALTER TABLE `#__extensions` CHANGE COLUMN `params` `params` MEDIUMTEXT NULL');
				$db->execute();
			}

			$params = JComponentHelper::getParams('com_fwfoodmenu');
			if ($params) {
				if ($update_code = $params->get('verified_code')) {
					$db->setQuery('UPDATE `#__update_sites` SET extra_query = '.$db->quote('code='.urlencode(trim($update_code)).'&host='.urlencode(JURI::root(false))).', last_check_timestamp = 0 WHERE name LIKE \'FW Food%\'');
					$db->execute();
				}
				$data = array(
					'order_new_email_subj'=>'New order [number] for [meals_qty] item(s) and [total] total',
					'order_new_email_body'=>'<p>New order #[number]</p><p>order number:[number],<br />customer name:[name],<br />email: [email],<br />phone: [phone],<br />order created: [created],<br />order status: [status],<br />booked on: [booked_on],<br />payment date: [payment_date],<br />amount: [amount],<br />tax: [tax],<br />paid through: [payment_gate],<br />delivery: [delivery_option],<br />delivery address: [address],<br />total: [total],<br />customer comments: [comments],<br /> <br />meal ordered: [ordered_meal]</p>',
					'order_status_email_subj'=>'Order [number] status changed to [status]',
					'order_status_email_body'=>'<p>Order status changed</p><p>order number:[number],<br />customer name:[name],<br />email: [email],<br />phone: [phone],<br />order created: [created],<br />order status: [status],<br />booked on: [booked_on],<br />payment date: [payment_date],<br />amount: [amount],<br />tax: [tax],<br />paid through: [payment_gate],<br />delivery: [delivery_option],<br />delivery address: [address],<br />total: [total],<br />customer comments: [comments],<br /> <br />meal ordered: [ordered_meal]</p>',
					'order_paid_email_subj'=>'Order [number] was paid',
					'order_paid_email_body'=>'<p>Order paid!</p><p>order number:[number],<br />customer name:[name],<br />email: [email],<br />phone: [phone],<br />order created: [created],<br />order status: [status],<br />booked on: [booked_on],<br />payment date: [payment_date],<br />amount: [amount],<br />tax: [tax],<br />paid through: [payment_gate],<br />delivery: [delivery_option],<br />delivery address: [address],<br />total: [total],<br />customer comments: [comments],<br /> <br />meal ordered: [ordered_meal]</p>',
					'order_cancel_email_subj'=>'Order [number] has been cancelled',
					'order_cancel_email_body'=>'<p>Order cancelled</p><p>order number:[number],<br />customer name:[name],<br />email: [email],<br />phone: [phone],<br />order created: [created],<br />order status: [status],<br />booked on: [booked_on],<br />payment date: [payment_date],<br />amount: [amount],<br />tax: [tax],<br />paid through: [payment_gate],<br />delivery: [delivery_option],<br />delivery address: [address],<br />total: [total],<br />customer comments: [comments],<br /> <br />meal ordered: [ordered_meal]</p>',
					'order_complete_email_subj'=>'Order [number] was completed',
					'order_complete_email_body'=>'<p>Order complete!</p><p>order number:[number],<br />customer name:[name],<br />email: [email],<br />phone: [phone],<br />order created: [created],<br />order status: [status],<br />booked on: [booked_on],<br />payment date: [payment_date],<br />amount: [amount],<br />tax: [tax],<br />paid through: [payment_gate],<br />delivery: [delivery_option],<br />delivery address: [address],<br />total: [total],<br />customer comments: [comments],<br /> <br />meal ordered: [ordered_meal]</p>',
				);
				$params_updated = false;
				foreach ($data as $key=>$val) {
					if (!$params->get($key)) {
						$params->set($key, $val);
						$params_updated = true;
					}
				}
				if ($params_updated) {
					$db->setQuery('UPDATE `#__extensions` SET params = '.$db->quote($params->toString()).' WHERE `element` = \'com_fwfoodmenu\' AND `type` = \'component\'');
					$db->execute();
				}
			}

			return true;
		}
	}
}
