<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

class JHTMLfwView {
	static function orderingListLinks($params) {
		ob_start();
?>
<div class="uk-flex fwa-order-input">
<?php
		if (!empty($params['display_up'])) {
?>
	<a href="javascript:" onclick="return Joomla.listItemTask('cb<?php echo $params['num']; ?>','orderup')" class="uk-button uk-button-outline-secondary"><i uk-icon="angle-up"></i></a>
<?php
		}
?>
	<input class="uk-input uk-input-width-xsmall" placeholder="1" type="text" name="order[]" value="<?php echo $params['value']; ?>">
<?php
		if (!empty($params['display_down'])) {
?>
	<a href="javascript:" onclick="return Joomla.listItemTask('cb<?php echo $params['num']; ?>','orderdown')" class="uk-button uk-button-outline-secondary"><i uk-icon="angle-down"></i></a>
<?php
		}
?>
</div>
<?php
		return ob_get_clean();
	}
	static function radioListLinks($params) {
		ob_start();
?>
<div class="uk-button-group mb-1 <?php if (!empty($params['wrapper_class'])) echo $params['wrapper_class']; ?>">
<?php
		$row = $params['row'];
		foreach ($params['buttons'] as $button) {
			$key = $button['name'];
			$is_checked = $row->$key;
			$classes = array('uk-button', 'uk-button-outline-secondary', 'uk-button-small');
			if ($is_checked) {
				$classes[] = 'active';
				if (!empty($button['active_class'])) {
					$classes[] = $button['active_class'];
				}
			}
?>
	<a href="javascript:" onclick="return Joomla.listItemTask('cb<?php echo $params['num']; ?>','<?php echo $is_checked?$button['task_off']:$button['task_on']; ?>')" class="<?php echo implode(' ', $classes); ?>" uk-tootip="<?php echo JText::_($is_checked?$button['title_off']:$button['title_on']); ?>"><span uk-icon="<?php echo $button['icon_class']; ?>"></span></a>
<?php
		}
?>
</div>
<?php
		return ob_get_clean();
	}
	static function booleanListLink($params) {
		ob_start();
?>
<a href="javascript:" onclick="return Joomla.listItemTask('cb<?php echo $params['num']; ?>','<?php echo $params['value']?$params['task_off']:$params['task_on']; ?>')" uk-tooltip="<?php echo JText::_($params['value']?$params['title_off']:$params['title_on']); ?>"><span class="uk-badge uk-badge-pill badge-<?php echo $params['value']?'success':'danger'; ?>"><i uk-icon="<?php echo $params['value']?'check':'close'; ?>"></i></span></a>
<?php
		return ob_get_clean();
	}
	static function menuItem($params) {
		ob_start();
?>
<li class="fwa-menu-item<?php if (!empty($params['active'])) { ?> active<?php } ?>" uk-tooltip="<?php echo esc_attr($params['name']); ?>">
	<a href="<?php echo $params['link']; ?>"><i uk-icon="icon:<?php echo $params['icon_class']; ?>; ratio:1.25;"></i> <span><?php echo $params['name']; ?></span></a>
</li>
<?php
		return ob_get_clean();
	}
	static function radioGroup($name, $value, $params) {
		ob_start();
?>
<div class="uk-button-group<?php if (!empty($params['wrapper_class'])) { ?> <?php echo $params['wrapper_class']; } ?>">
<?php
		foreach ($params['buttons'] as $button) {
			$classes = array('uk-button uk-button-small');
			if (!empty($button['class'])) {
				$classes[] = $button['class'];
			}
			if ($value == $button['value']) {
				$classes[] = 'active';
				if (!empty($button['active_class'])) {
					$classes[] = $button['active_class'];
				}
			}
?>
	<button type="button" class="<?php echo implode(' ', $classes) ?>" data-name="<?php echo $name; ?>" data-value="<?php echo htmlspecialchars($button['value']); ?>" data-active-class="<?php echo htmlspecialchars($button['active_class']); ?>"><?php if (!empty($button['icon_class'])) { ?><i class="fa <?php echo $button['icon_class']; ?>"></i><?php } if (!empty($button['title'])) { echo $button['title']; } ?></button>
<?php
		}
?>
</div>
<input type="hidden" name="<?php echo $name; ?>" value="<?php echo htmlspecialchars($value); ?>" />
<?php
		if (!defined('FW_RADIO_HANDLER_LOADED')) {
			define('FW_RADIO_HANDLER_LOADED', 1);
			JHTML::_('jquery.framework');
?>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
	$('body').on('click', '.uk-button-group button', function() {
		var $button = $(this);
		var $input = $('input[name="'+$button.data('name')+'"]');
		if ($input.length && $input.val() != $button.data('value')) {
			$('button', $button.closest('.uk-button-group')).attr('class', 'uk-button uk-button-small');
			$button.addClass($button.data('active-class')).addClass('active');
			$input.val($button.data('value')).change();
		}
	});
	})(jQuery);
});
</script>
<?php
		}
		return ob_get_clean();
	}
	static function handleUploadButton($params) {
		JHTML::stylesheet('components/com_fwfoodmenu/assets/css/cropper.min.css');
		JHTML::_('jquery.framework');
		JHTML::script('components/com_fwfoodmenu/assets/js/cropper.min.js');
		ob_start();
		if (!empty($params['is_image']) and !defined('FWVIEW_UPLOAD_MODAL_LOADED')) {
?>
<div id="fwa-image-upload" class="uk-modal-container" uk-modal>
  <div class="uk-modal-dialog">
      <div class="uk-modal-header">
        <h5 class="uk-modal-title"><?php echo JText::_('FWFM_IMAGE_UPLOAD'); ?></h5>
        <button class="uk-modal-close-default" type="button" uk-close></button>
      </div>
      <div class="uk-modal-body"></div>
      <div class="uk-modal-footer">
		  <button type="button" class="uk-button uk-button-primary"><?php echo JText::_('FWFM_UPLOAD'); ?></button>
	  </div>
  </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
		$('#fwa-image-upload .uk-modal-footer button').click(function() {
			var $button = $(this).attr('disabled', true);
			var $wait = $('<div uk-spinner></div>');
			$button.after($wait);
			var $popup = $button.closest('.uk-modal');
			var crop = $popup.find('img').data('crop');
			crop.getCroppedCanvas().toBlob(function(blob) {
				var form = document.getElementById('adminForm');
				var $input = $('<?php echo $params['input']; ?>');
				var formdata = new FormData();
				<?php if (!empty($params['view'])) { ?>formdata.append('view', '<?php echo $params['view']; ?>');<?php } ?>
				formdata.append('layout', '<?php echo $params['layout']; ?>');
				formdata.append('format', 'json');
				formdata.append('oid', form.oid.value);
				formdata.append($input.attr('name'), blob);

<?php
		if (!empty($params['post_data'])) {
			foreach ($params['post_data'] as $key=>$val) {
?>
				formdata.append('<?php echo $key ?>', '<?php echo $val; ?>');
<?php
			}
		}
?>
				$.ajax({
					url: <?php if (empty($params['url'])) { ?>form.action<?php } else { ?>'<?php echo $params['url']; ?>'<?php } ?>,
					type: "POST",
					data: formdata,
					dataType: 'json',
					contentType: false,
					processData: false,
					error: function(xhr, err) {
						$wait.remove();
						$button.attr('disabled', false);
						fwfm_alert(err);
					},
					success: <?php if (empty($params['callback'])) { ?>function(data) {
						$wait.remove();
						$button.attr('disabled', false);
						UIkit.modal($popup[0]).hide()

						$input.next().html('<?php echo JText::_('FWFM_CHOOSE_FILE', false); ?>');
						var $parent = $input.parent();
						var input_html = $parent.html();
						$parent.html(input_html);
						if (data.id) {
							$('input[name="oid"]').val(data.id);
						}
						if (data.image) {
							$('<?php echo $params['image']; ?>').attr('src', data.image).parent().show();
						}
						if (data.msg) {
							alert(data.msg);
						}
					}
<?php
				} else echo $params['callback'];
?>
				});

			});
		});
	})(jQuery);
});
</script>
<?php
		}
?>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
<?php
		if (!defined('FWVIEW_UPLOAD_HANDLER_LOADED')) {
			define('FWVIEW_UPLOAD_HANDLER_LOADED', true);
?>
	$(document).on('change', '.fwcss input[type="file"]', function(ev) {
		var $inp = $(this);
		var files = $inp.prop('files');
		if (!$inp.attr('multiple') && files && files.length) {
			/* check is it an image */
			var match = files[0].name.match(/\.(png|jpg|jpeg|gif)$/i);
			if ($inp.data('is_image') && match && window.FileReader) {
				var $popup = $('#fwa-image-upload');
				UIkit.modal($popup[0]).show();
				var $body = $popup.find('.uk-modal-body').html('');
				setTimeout(function() {
					var $img = $('<img src="" id="fwa-cropped-image" style="display:block;max-width:90%;" />');
					$body.append($img);
					$img.on('load', function() {
						var crop = new Cropper($img[0], {
							viewMode: 3,
							minCropBoxWidth: 600,
							minCropBoxHeight: 600,
							aspectRatio: 1
						});
						$(this).data('crop', crop);
	
						$inp.next().html('<?php echo esc_js(JText::_('FWFM_CHOOSE_FILE', false)); ?>');
						var $parent = $inp.parent();
						var input_html = $parent.html();
						$parent.html(input_html);
					});
	
					var reader = new FileReader();
					reader.onload = function() {
						$('#fwa-cropped-image').attr('src', reader.result);
					}
					reader.readAsDataURL(files[0]);
				}, 500);
			} else {
				var buff = [];
				for (var i = 0; i < files.length; i++) {
					var file = files[i];
					if ('name' in file) {
						buff.push(file.name);
					} else {
						buff.push(file.fileName);
					}
				}
				$inp.next().html(buff.join(','));
			}
		} else {
			$inp.next().html('<?php echo JText::_('FWFM_CHOOSE_FILE', false); ?>');
		}
	});
	$('.fwcss input[type="file"]').change();
<?php
		}
?>
<?php
		if (!empty($params['is_image'])) {
?>
	$('<?php echo $params['input']; ?>').attr('data-is_image', '1');
<?php
		}
?>
	$(document).on('click', '<?php echo $params['button']; ?>', function() {
		var form = this.form;
		var $button = $(this);
		var $input = $('<?php echo $params['input']; ?>');
		var filename = $input.val();
		if (filename != '') {
			var exts = [<?php if (!empty($params['exts'])) { ?>'<?php echo implode("','", $params['exts']); ?>'<?php } ?>];
			if (exts) {
				var ext = filename.split('.').pop().toLowerCase();
				var ext_found = false;
				for (var i = 0; i < exts.length; i++) {
					if (exts[i] == ext) {
						ext_found = true;
						break;
					}
				}
				if (!ext_found) {
					alert('<?php echo JText::sprintf('FWFM_MENU_EXTENSIONS_ALLOWED', implode(", ", $params['exts'])); ?>');
					return;
				}
			}
<?php
		if (!empty($params['submit_code'])) echo $params['submit_code'];
?>
			var formdata = new FormData(form);
			<?php if (!empty($params['view'])) { ?>formdata.append('view', '<?php echo $params['view']; ?>');<?php } ?>
			formdata.append('layout', '<?php echo $params['layout']; ?>');
			formdata.append('format', 'json');
<?php
		if (!empty($params['post_data'])) {
			foreach ($params['post_data'] as $key=>$val) {
?>
			formdata.append('<?php echo $key ?>', '<?php echo $val; ?>');
<?php
			}
		}
?>
			var $progress_bar = $('<progress class="uk-progress" value="0" max="100"></progress>');
			$button.attr('disabled', true).after($progress_bar);

			$.ajax({
				xhr: function() {
					var xhr = new window.XMLHttpRequest();
					xhr.upload.addEventListener("progress", function(evt) {
						if (evt.lengthComputable) {
							var percentComplete = evt.loaded / evt.total;
							percentComplete = parseInt(percentComplete * 100);
							$progress_bar[0].value = percentComplete;
						}
					}, false);

					return xhr;
				},
				url: <?php if (empty($params['url'])) { ?>form.action<?php } else { ?>'<?php echo $params['url']; ?>'<?php } ?>,
				type: "POST",
				data: formdata,
				dataType: 'json',
				contentType: false,
				processData: false,
				error: function(xhr, err) {
					$progress_bar.remove();
					$button.attr('disabled', false);
					fwfm_alert(err);
				},
				success: <?php if (empty($params['callback'])) { ?>function(data) {
					$progress_bar.remove();
					$button.attr('disabled', false);
					$input.next().html('<?php echo JText::_('FWFM_CHOOSE_FILE', false); ?>');
					var $parent = $input.parent();
					var input_html = $parent.html();
					$parent.html(input_html);
					if (data && data.data && data.data[0]) {
						data = data.data[0];
					}
					if (data.id) {
						$('input[name="oid"]').val(data.id);
					}
					if (data.image) {
						$('<?php echo $params['image']; ?>').attr('src', data.image).parent().show();
					}
					if (data.msg) {
						fwfm_alert(data.msg);
					}
					if (data.msgs) {
						for (var i = 0; i < data.msgs.length; i++) {
							fwfm_alert(data.msgs[i].msg);
						}
					}
				}
<?php
				} else echo $params['callback'];
?>
			});
		}
	});
	})(jQuery);
});
</script>
<?php
		return ob_get_clean();
	}
	static function handleRemoveButton($params) {
		$id = empty($params['id_field'])?'oid':$params['id_field'];
		ob_start();
?>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
	$(document).on('click', '<?php echo $params['button']; ?>', function() {
		var form = this.form;
		var $button = $(this);
		if (form.<?php echo esc_js($id); ?>.value > 0) {
			var $img = $('<div style="position:absolute" uk-spinner></div>');
			$button.attr('disabled', true).after($img);
			$.ajax({
				url: <?php if (empty($params['url'])) { ?>form.action<?php } else { ?>'<?php echo $params['url']; ?>'<?php } ?>,
				type: 'post',
				dataType: 'json',
				data: {
					format: 'json',
					id: form.<?php echo esc_js($id); ?>.value,
					button_id: $button.data('id'),
					<?php if (!empty($params['view'])) { ?>view: '<?php echo $params['view']; ?>',<?php } ?>
					layout: '<?php echo $params['layout']; ?>'<?php if (!empty($params['add_request_params'])) echo $params['add_request_params']; ?>
				},
				error: function(xhr, err) {
					$img.remove();
					$button.attr('disabled', false);
					fwfm_alert(err);
				},
				success: <?php if (empty($params['callback'])) { ?>function(data) {
					$img.remove();
					$button.attr('disabled', false);

					if (data.result) {
						$('<?php echo $params['image']; ?>').parent().hide();
					}
					if (data.image) {
						$('<?php echo $params['image']; ?>').attr('src', data.image);
					}
					if (data.msg) {
						alert(data.msg);
					}
				}
<?php
				} else echo $params['callback'];
?>
			});
		}
	});
	})(jQuery);
});
</script>
<?php
		return ob_get_clean();
	}
}
