<?php
    /**
    * @package tcshortcodes plugin
    * @author themescreative http://www.themescreative.com
    * @copyright Copyright (c) 2010 - 2013 themescreative
    * @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or Later
    */
    //no direct accees
    defined ('_JEXEC') or die('resticted aceess');

    jimport('joomla.filesystem.file');
    jimport('joomla.filesystem.folder');

    class tcshortcodes {

        private static $_instance;
        private $document;
        private $importedFiles=array();
        private $_less;

 

        /**
        * making self object for singleton method
        * 
        */
        final public static function getInstance()
        {

            if( !self::$_instance ){

                self::$_instance = new self();
                self::getInstance()->getDocument();
                self::getInstance()->getDocument()->tcshortcodes = self::getInstance();

            } 
            return self::$_instance;
        }


        /**
        * Get Document
        * 
        * @param string $key
        */
        public static function getDocument($key=false)
        {
            self::getInstance()->document = JFactory::getDocument();
            $doc = self::getInstance()->document;
            if( is_string($key) ) return $doc->$key;

            return $doc;
        }

        /**
        * Get Template name
        * 
        * @return string
        */
        public static function themeName()
        {
            //return self::getInstance()->getDocument()->template;
            return JFactory::getApplication()->getTemplate();
        }

		

        /**
        * Get theme path
        * 
        * @param bool $base
        * @return string
        */
        public static function themePath($base=false)
        {
            if( $base==true ) return JURI::root(true).'/templates/'.self::getInstance()->themeName();

            return  JPATH_THEMES . '/' . self::getInstance()->themeName();
        }

        /**
        * Get theme path
        * @return string
        */
        public static function themeURL()
        {
            return self::getInstance()->themePath();
        }



        /**
        * Get tcshortcodes path
        * 
        */
        public static function frameworkPath($base=false)
        {
            if( $base==true ) return JURI::root(true).'/plugins/system/tcshortcodes';

            return JPATH_PLUGINS . '/system/tcshortcodes';
        }

        public static function pluginPath($base=false){
            return self::getInstance()->frameworkPath($base);
        }

   
        /**
        * Make string to slug
        * 
        * @param mixed $text
        * @return string
        */

        public static function slug($text)
        {
            return preg_replace('/[^a-z0-9_]/i','-', strtolower($text));
        }

  

        /**
        * Import required file/files
        * 
        * @param array | string $paths
        * @param object $tcshortcodes
        * @return self
        */
        public static function Import($paths, $tcshortcodes=false)
        {
            if( is_array($paths) ) foreach((array) $paths as $file) self::_Import( $file );
            else self::_Import( $paths, $tcshortcodes );
            return self::getInstance();
        }

        /**
        * Single file import
        * 
        * @param string $path
        * @return self
        */
        private static function _Import($path, $tcshortcodes)
        {
            $intheme  = self::getInstance()->themePath() . '/' . $path;
            $inplugin = self::getInstance()->frameworkPath() . '/' . $path;

            if( file_exists( $intheme ) && !is_dir( $intheme ) ){
                self::getInstance()->importedFiles[] = $intheme; 
                require_once $intheme;
            } elseif( file_exists( $inplugin ) && !is_dir( $inplugin ) ){
                self::getInstance()->importedFiles[] = $inplugin; 
                require_once $inplugin;
            }
            return self::getInstance();
        }

        /**
        * Get Imported file
        * @return array
        */
        public static function getImportedFiles()
        {
            return self::getInstance()->importedFiles;
        }

        /**
        * Saved layout
        * 
        * @var string
        * @access private
        */
        private $layout='';
        /**
        * Generating row
        * 
        * @param string $layout
        * @access private
        */
        private static function showRow($layout)
        {
            if( isset($layout->children) )
            {
                foreach( $layout->children as $i=>$v )
                {

                    if( !isset($v->type) or !isset($v->position) ) continue;
                    // hide component area
                    if( $v->type=='component' and  self::getInstance()->hideComponentArea()) continue;

                    if( $v->type=='component' or $v->type=='message' ) return true;

                    if( $v->position!='' ){
                        if( self::getInstance()->countModules( $v->position )  ) return true;
                        if( isset($v->children) ) self::getInstance()->showRow($v);
                    }
                }
            }
        }


        /**
        * Detact External URL
        * 
        * @param string $url
        * @return boolean
        */
        public function isExternalURL($url)
        {
            $parseurl = parse_url($url);
            $urlHost = isset($parseurl['host'])?$parseurl['host']:false;
            $currentHost = $_SERVER['HTTP_HOST'];
            $currentRemoteAddr = $_SERVER['REMOTE_ADDR'];

            if(false==$urlHost) return false;

            if( $currentHost===$urlHost or $currentRemoteAddr===$urlHost ) return false;
            else return true;
        } 



        /**
        * Add stylesheet
        * 
        * @param mixed $sources. string or array
        * @param string $seperator. default is , (comma)
        * @return self
        */
        public static function addCSS($sources, $seperator=',',$checkpath=true) {

            $srcs = array();
            if( is_string($sources) ) $sources = explode($seperator,$sources);
            if(!is_array($sources)) $sources = array($sources);

            foreach( (array) $sources as $source ) $srcs[] = trim($source);

            foreach ($srcs as $src) {

                if(self::getInstance()->isExternalURL($src)) self::getInstance()->document->addStyleSheet($src);
				
				if( $checkpath==false ){
                    self::getInstance()->document->addStyleSheet($src);
                    continue; 
                } 

                //cheack in template path
                if( file_exists( self::getInstance()->themePath() . '/css/'. $src)) { 
                    self::getInstance()->document->addStyleSheet( self::getInstance()->themePath(true) . '/css/' . $src );
                } 
                //if not found, then check from tcshortcodes path
                elseif( file_exists( self::getInstance()->frameworkPath() . '/css/' . $src ) ) { 
                    self::getInstance()->document->addStyleSheet( self::getInstance()->frameworkPath(true) . '/css/' . $src);
                }        
            }
            return self::getInstance();
        }    

        /**
        * Add javascript
        * 
        * @param mixed $sources. string or array
        * @param string $seperator. default is , (comma)
        * @return self
        */
        public static function addJS($sources, $seperator=',', $checkpath=true) {

            $srcs = array();
            if( is_string($sources) ) $sources = explode($seperator,$sources);
            if(!is_array($sources)) $sources = array($sources);

            foreach( (array) $sources as $source ) $srcs[] = trim($source);

            foreach ($srcs as $src) {

                if(self::getInstance()->isExternalURL($src)) self::getInstance()->document->addScript($src);
				
				if( $checkpath==false ){
                    self::getInstance()->document->addScript($src);
                    continue; 
                }

                //cheack in template path
                if( file_exists( self::getInstance()->themePath() . '/js/'. $src)) { 
                    self::getInstance()->document->addScript( self::getInstance()->themePath(true) . '/js/' . $src );
                } 
                //if not found, then check from tcshortcodes path
                elseif( file_exists( self::getInstance()->frameworkPath() . '/js/' . $src ) ) { 
                    self::getInstance()->document->addScript( self::getInstance()->frameworkPath(true) . '/js/' . $src);
                }        
            }
            return self::getInstance();
        }    

        /**
        * Add Inline Javascript
        * 
        * @param mixed $code
        * @return self
        */
        public function addInlineJS($code){
            self::getInstance()->document->addScriptDeclaration($code);
            return self::getInstance();
        }


        public static function getShortcodes()
        {
            return self::getInstance()->shtcode_tags;
        }

        private static $shtcode_tags = array();
        public static function importShortCodeFiles()
        {

            $shortcodes = array();

            $themeshortcodes = glob( self::getInstance()->themePath().'/shortcodes/*.php' );
            $pluginshortcodes = glob( self::getInstance()->pluginPath().'/shortcodes/*.php');

            foreach((array) $themeshortcodes as $value)  $shortcodes[] =  basename($value);
            foreach((array) $pluginshortcodes as $value)  $shortcodes[] =   basename($value);

            $shortcodes = array_unique($shortcodes);

            self::getInstance()->Import('core/tc_shtcodes.php', self::getInstance());

            foreach($shortcodes as $shortcode  ) self::getInstance()->Import('shortcodes/'.$shortcode);

            return self::getInstance();
        }



}