<?php
/**
 * FW Food Menu 4.0.0
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

if (!defined('FWFM_COMPONENT_SITE')) {
	define('FWFM_COMPONENT_SITE', JPATH_SITE.'/components/com_fwfoodmenu');
}
require_once(FWFM_COMPONENT_SITE.'/helpers/helper.php');

class plgFwFoodMenuColumns extends fwfmJPlugin {
	function __construct(&$subject, $config = array()) {
		JFactory::getLanguage()->load('com_fwfoodmenu', JPATH_ADMINISTRATOR);
		parent::__construct($subject, $config);
	}
	function onGetCategoryItemExtraClasses($ext, $view, &$classes) {
		if ($ext != 'com_fwfoodmenu' or fwFoodMenuHelper::pluginDisabledViaMenu('columns')) return;
		$add_params = $view->params->get('add_params');
		if (!empty($add_params['cols_qty']) and $add_params['cols_qty'] != 3) {
			$bs_cols = 12/$add_params['cols_qty'];
			$classes = str_replace('col-lg-4', 'col-lg-'.$bs_cols, $classes);
		}
	}
	function onGetCategoriesWrapperExtraClasses($ext, $view, &$categories_wrapper_classes) {
		if ($ext != 'com_fwfoodmenu' or fwFoodMenuHelper::pluginDisabledViaMenu('columns')) return;
		$params = fwfmGlobalParams::getInstance();
		if ($cols = $params->get('cols_qty') and $cols > 1 and $params->get('align_by') == 'category') {
			$categories_wrapper_classes[] = 'fwfm-global-cols-'.$cols;
		}
	}
	function onShowCategoryListBeginExtraIcons($ext, $view, $row, $num) {
		if ($ext != 'com_fwfoodmenu') return;
		echo fwFoodMenuHelper::loadTemplate('admin.columns.show_category_list_begin_extra_icons', array(
			'view' => $view,
			'row' => $row,
			'num' => $num
		), dirname(__FILE__).'/layouts/');
	}
	function onGetCategoryMenuParams($ext, $name, $value) {
		if ($ext != 'com_fwfoodmenu') return;
		return fwFoodMenuHelper::loadTemplate('admin.columns.get_categorymenuparams', array(
			'name' => $name,
			'value' => $value
		), dirname(__FILE__).'/layouts/');
	}
	function onSetExtraClasses($ext, $view) {
		if ($ext != 'com_fwfoodmenu' or fwFoodMenuHelper::pluginDisabledViaMenu('columns')) return;
		$view->params->set('col_qty', $view->params->get('cols_qty', 1));
	}
	function onSetCategoryExtraClasses($ext, $view, $cat) {
		if ($ext != 'com_fwfoodmenu' or fwFoodMenuHelper::pluginDisabledViaMenu('columns')) return;

		$view->params->set('col_qty', $view->params->get('cols_qty', 1));
	}
	function onSetSubCategoryExtraClasses($ext, $view, $cat) {
		if ($ext != 'com_fwfoodmenu' or fwFoodMenuHelper::pluginDisabledViaMenu('columns')) return;

		$view->params->set('col_qty', $view->params->get('cols_qty', 1));
	}
	function onGetFoodMenuColsQty($ext, &$layouts) {
		if ($ext != 'com_fwfoodmenu') return;
		$layouts = array_merge($layouts, array('1', '2', '3'));
		return $layouts;
	}
	function onShowCategoryEditDesignCategoryExtraSettings($ext, $view) {
		if ($ext != 'com_fwfoodmenu') return;
		echo fwFoodMenuHelper::loadTemplate('admin.columns.show_category_edit_design_category_extra_cards', array(
			'view' => $view
		), dirname(__FILE__).'/layouts/');
	}
	function onShowSettingsCategoryExtraFields($ext, $view) {
		if ($ext != 'com_fwfoodmenu') return;
		echo fwFoodMenuHelper::loadTemplate('admin.columns.show_settings_category_extra_fields', array(
			'view' => $view
		), dirname(__FILE__).'/layouts/');
	}
	function onShowCategoriesBachProcessingExtraFields($ext, $view) {
		if ($ext != 'com_fwfoodmenu') return;
		echo fwFoodMenuHelper::loadTemplate('admin.columns.batch_categories_extra_fields', array(
			'view' => $view
		), dirname(__FILE__).'/layouts/');
	}
	function onDoBatchCategoriesProcessing($ext, $cid, $changes_requested, $model) {
		if ($ext != 'com_fwfoodmenu') return;
		$input = JFactory::getApplication()->input;
		if ($cols_qty = $input->getString('cols_qty')) {
			$db = JFactory::getDBO();
			$db->setQuery('SELECT id, params FROM `#__fwfoodmenu_category` WHERE id IN ('.implode(',', $cid).')');
			if ($list = $db->loadObjectList()) {
				foreach ($list as $row) {
					$params = new JRegistry($row->params);
					if ($params->get('cols_qty') != $cols_qty) {
						$params->set('cols_qty', $cols_qty);
						$db->setQuery('UPDATE `#__fwfoodmenu_category` SET params = '.$db->quote($params->toString()).' WHERE id = '.$row->id);
						$db->execute();
					}
				}
			}
		}
	}
}
