<?php
/**
 * FW Food Menu Categories Module 4.0.0
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

if (!defined('FWFM_COMPONENT_SITE')) {
	define('FWFM_COMPONENT_SITE', JPATH_SITE.'/components/com_fwfoodmenu');
}
require_once(FWFM_COMPONENT_SITE.'/helpers/helper.php');
require_once('helper.php');
fwFoodMenuHelper::loadSiteStyles();

JFactory::getLanguage()->load('com_fwfoodmenu');

JHTML::stylesheet('modules/mod_fwfm_categories/assets/styles.css');

JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_fwfoodmenu/models');

$model = JModelLegacy::getInstance('Menu', 'MenuModel');

if ($model) {
	$tree = $cats_tree = array();
	$cids = (array)$params->get('category_id');
	if ($cids) {
		$tree = fwFoodMenuHelper::loadCategoriesTree($cids);
	} else {
		$tree = fwFoodMenuHelper::loadCategoriesTree(null);
	}

	if (class_exists('JVersion')) {
		$cids = array();
		$app = JFactory::getApplication();
		if ($app->input->getCmd('option') == 'com_fwfoodmenu' and $app->input->getCmd('view') == 'menu') {
			$cids = (array)$app->getParams()->get('category_id');
			$cats_tree = fwFoodMenuHelper::loadCategoriesTree($cids);
		}
	} else {
		$cats_tree = $tree;
	}
	if ($cids) {
		$cats = array();
		if ($cats_tree) {
			foreach ($cats_tree as $row) {
				$row->_items = array();
				$cats[] = $row;
			}
			$cids = fwFoodMenuHelper::getCategoriesIdBelow($cats, $cids);
		}
	}
	$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'), ENT_COMPAT, 'UTF-8');
	require(JModuleHelper::getLayoutPath('mod_fwfm_categories'));
}
