<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2019 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/
defined( '_JEXEC' ) or die( 'Restricted access' );

class menuViewUsersection extends JViewLegacy {
	function display($tpl = null) {
        $model = $this->getModel();

		$this->app = JFactory::getApplication();
		if ($this->getLayout() == 'logout') {
			$this->app->logout();
			$return = $this->app->input->getString('return');
			if ($return) {
				$return = base64_decode($return);
			} else {
				$return = JURI::root(true);
			}
			$this->app->redirect($return);
		}
        $this->user = JFactory::getUser();
		$this->params = new JFParams(new JRegistry);
		if ($buff = $this->params->get('menu-meta_description')) {
			JFactory::getDocument()->setDescription($buff);
		}
		if ($buff = $this->params->get('menu-meta_keywords')) {
			JFactory::getDocument()->setMetadata('keywords', $buff);
		}
		$this->profile = $model->loadProfile($this->user->id);
        $this->language = fwFoodMenuHelper::getLanguage();
		$this->setLayout($model->getActiveLayout($this));

		$this->app->triggerEvent('onbeforeUsersectionDisplay', array('com_fwfoodmenu', &$this));

        parent::display($tpl);
	}
	function getPaginationLinks($pagination, $options = array()) {
		$list = array(
			'prefix'       => $pagination->prefix,
			'limit'        => $pagination->limit,
			'limitstart'   => $pagination->limitstart,
			'total'        => $pagination->total,
			'limitfield'   => $pagination->getLimitBox(),
			'pagescounter' => $pagination->getPagesCounter(),
			'pages'        => $pagination->getPaginationPages(),
			'pagesTotal'   => $pagination->pagesTotal,
		);
		return fwFoodMenuHelper::loadTemplate('pagination.links', array('view' => $this, 'list' => $list, 'options' => $options));
	}
}
