<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

class MenuModelCategory extends JModelLegacy {
	function loadCategory($params = null) {
		if (is_null($params)) {
			$params = JFactory::getApplication()->getParams();
		}
		$category = $this->getTable('category');
		$ids = (array)$params->get('category_id');
		if (count($ids) == 1) {
			$category->load($ids[0]);
		}
		return $category;
	}
	function loadList($params = null) {
		$db = JFactory::getDBO();
		$app = JFactory::getApplication();
		if (is_null($params)) {
			$params = JFactory::getApplication()->getParams();
		}

		$where = array(
			'c.published = 1',
			'c.id IN ('.implode(',', (array)$params->get('category_id', 0)).')'
		);
		$app->triggerEvent('onGetCategoriesListWhere', array('com_fwfoodmenu', &$where));

		$db->setQuery('
SELECT
    c.*,
	\'\' AS _images,
	\'\' AS _cids
FROM
    #__fwfoodmenu_category AS c
WHERE
	'.implode(' AND ', $where).'
ORDER BY
	c.ordering,
	c.name'
		);
		if ($list = $db->loadObjectList()) {
			$ids = array();
			foreach ($list as $i=>$row) {
				$params = new JRegistry($row->params);
				$list[$i]->params = new JFParams($params, fwFoodMenuHelper::getParentCategories($row->parent));
			}

			$app->triggerEvent('onCalculateCategoryListExtraFields', array('com_fwfoodmenu', &$list, $ids));
		}
		return $list;
	}
}
