<?php
/**
* FW Food menu 5.1.1
* @copyright C 2019 Fastw3b
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @link http://www.fastw3b.net/ Official website
**/
defined( '_JEXEC' ) or die( 'Restricted access' );

$view = $displayData['view'];
$own_profile = ($view->user->id and $view->user->id == $view->profile->user_id);
?>
<div id="fwfm" class="fwfm-property fwcss">
<?php
if ($own_profile) {
?>
			<div class="fwfm-management-panel">
				<div class="fwfm-management-panel-wrapper">
					<button type="button" class="uk-button uk-button-default uk-margin">
						<span uk-icon="icon: menu" class="uk-margin-small-right"></span> <?php echo JText::_('FWFM_USER_MENU'); ?> 
					</button>
					<div uk-dropdown="mode: click">
						<?php echo fwFoodMenuHelper::loadTemplate('user.left', $displayData); ?>
<?php
	if ($view->user->id) {
?>
						<div class="uk-card uk-card-default uk-padding-small">
							<div class="fwfm-management-panel-section">
								<div class="uk-h6 uk-text-uppercase fwfm-management-panel-header"><?php echo JText::_('FWFM_MANAGE_ACCOUNT'); ?></div>
								<div class="uk-text-small uk-text-muted"><?php echo JText::_('FWFM_LOGGED_IN_AS'); ?> <?php echo esc_html($view->user->name); ?></div>
								<ul class="uk-nav uk-dropdown-nav">
									<li>
										<a href="javascript:"><span uk-icon="icon: lock" class="uk-margin-small-right"></span> <?php echo JText::_('FWFM_CHANGE_PASSWORD'); ?></a>
									</li>
									<li>
										<a href="<?php echo fwFoodMenuHelper::route('index.php?option=com_fwfoodmenu&view=usersection&layout=logout'); ?>"><span uk-icon="icon: sign-out" class="uk-margin-small-right"></span> <?php echo JText::_('FWFM_LOGOUT'); ?></a>
									</li>
								</ul>
							</div>
						</div>
<?php
	}
?>
					</div>
				</div>
			</div>
<?php
}	
?>
	</div>
	<div class="fwfm-management-body">
<?php
?>
		<div class="fwfm-management-section">
			<?php $view->app->triggerEvent('onshowUserSection', array('com_fwfoodmenu', $view)); ?>
		</div>
	</div>
<?php
if ($view->user->id) {
?>
	<div id="fwfm-change-password" uk-modal>
		<div class="uk-modal-dialog">
				<div class="uk-modal-header">
					<h5 class="uk-modal-title" id="exampleModalLabel"><?php echo JText::_('FWFM_CHANGE_PASSWORD'); ?></h5>
					<button class="uk-modal-close-default" type="button" uk-close></button>
				</div>
				<form>
					<div class="uk-modal-body">
						<div uk-grid>
							<label class="uk-width-1-2@m">
								<?php echo JText::_('FWFM_CURRENT_PASSWORD'); ?>
							</label>
							<div class="uk-width-1-2@m">
								<input type="password" class="uk-input" name="password" />
							</div>
						</div>
						<div uk-grid>
							<label class="uk-width-1-2@m">
								<?php echo JText::_('FWFM_NEW_PASSWORD'); ?>
							</label>
							<div class="uk-width-1-2@m">
								<input type="password" class="uk-input" name="password1" />
							</div>
						</div>
						<div uk-grid>
							<label class="uk-width-1-2@m">
								<?php echo JText::_('FWFM_RETYPE_NEW_PASSWORD'); ?>
							</label>
							<div class="uk-width-1-2@m">
								<input type="password" class="uk-input" name="password2" />
							</div>
						</div>
					</div>
					<div class="uk-modal-footer">
						<button type="button" class="uk-button uk-button-primary"><?php echo JText::_('FWFM_CHANGE_PASSWORD'); ?></button>
					</div>
				</form>
		</div>
	</div>
<?php
}
?>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    (function($) {
<?php
if ($view->user->id) {
?>
	$('.fwfm-management-panel-section a:has(\'[uk-icon="icon: lock"]\')').click(function() {
		UIkit.modal('#fwfm-change-password').show();
	});
	$('#fwfm-change-password button.uk-button-primary').click(function() {
		var form = this.form;
		var fields = ['password', 'password1', 'password2'];
		for (var i = 0; i < fields.length; i++) {
			if (form[fields[i]].value.trim() == '') {
				UIkit.modal.alert('<?php echo JText::_('FWFM_ALL_FIELDS_REQUIRED'); ?>', {stack: true});
				return;
			}
		}
		var $btn = $(this).attr('disabled', true);
		$.ajax({
			dataType: 'json',
			data: {
				format: 'json',
				view: 'usersection',
				layout: 'change_password',
				password: form.password.value,
				password1: form.password1.value,
				password2: form.password2.value
			}
		}).done(function(data) {
			$btn.attr('disabled', false);
			if (data.result) {
				var $popup = $('#fwfm-change-password');
				$popup.find('input').val('');
				UIkit.modal($popup[0]).hide();
			}
			if (data.msg) {
				UIkit.modal.alert(data.msg);
			}
		});
	});
<?php
}
if ($messages = fwFoodMenuHelper::getMessages()) {
    foreach($messages as $message) {
?>
        fwfm_alert('<?php echo esc_js($message->msg); ?>',
            '<?php echo esc_js(JText::_('FWFM_NOTIFICATION')); ?>',
            '<?php echo esc_js($message->status); ?>'
        );
<?php
    }
    fwFoodMenuHelper::clearMessages();
}
?>
    })(jQuery);
});
</script>
