<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

$view = $displayData['view'];
$cat = $displayData['cat'];

$view->app->triggerEvent('onSetCategoryExtraClasses', array('com_fwfoodmenu', $view, $cat));
$extra_classes = $view->params->get('extra_category_classes');

$align_by = $view->params->get('align_by', 'meal');
if (!in_array($align_by, array('meal', 'category'))) {
	$align_by = 'meal';
}
$cols_qty = $col_qty = $view->params->get('col_qty', 1);
$desc_pos = $view->params->get('category_descr_position', 'top');

/* count menu items, skip subcategories */
$qty = 0;
foreach ($cat->_items as $item) {
	if (empty($item->type)) $qty++;
}

if ($extra_classes) {
?>
		<div class="<?php echo $extra_classes; ?>">
<?php
}

$additional_classes = 'fwfm-category fwfm-category-align-'.$view->params->get('category_text_alignment', 'left');
$view->app->triggerEvent('onCollectCategoryStatus', array('com_fwfoodmenu', $view, $cat, &$additional_classes));
?>
		<div id="fwfm-category-<?php echo $cat->id; ?>" class="<?php echo $additional_classes; ?>" data-cid="<?php echo $cat->id; ?>" data-alias="<?php echo $cat->alias; ?>">
			<div id="fwfm-category-title-<?php echo $cat->id; ?>"></div>
<?php
if ($view->params->get('display_category_title', 1) or ($view->params->get('display_category_shortdescription', 1) and trim($cat->short_description))) {
?>
			<div class="fwfm-category-title-wrapper">
<?php
	$view->app->triggerEvent('onShowSubCategoryItemHeader', array('com_fwfoodmenu', $view, $cat));
	if (true or $view->params->get('display_category_title', 1)) {
?>
				<div class="fwfm-category-title">
					<a name="<?php echo $cat->alias; ?>"></a>
					<span><?php echo $cat->name; ?></span>
<?php
		if ($view->params->get('display_category_shortdescription', 1) and trim($cat->short_description)) {
?>
					<div class="fwfm-category-short-description"><?php echo $cat->short_description; ?></div>
<?php 
		}
?>					
				</div>
<?php
	}
?>
			</div>
<?php
}
?>
			<div class="fwfm-category-body-wrapper fwfm-category-body-<?php echo $desc_pos; ?>">
<?php
if (trim($cat->description)) {
?>
				<div class="fwfm-category-body">
					<div class="fwfm-category-description"><?php echo $cat->description; ?></div>
				</div>
<?php
}
?>
				<div class="fwfm-category-menu">
<?php
$cols_dir_horizontal = ($view->params->get('cols_dir') == 'horizontal');
echo fwFoodMenuHelper::loadTemplate('menu.pdf_menu_horizontal', array(
	'view' => $view,
	'cat' => $cat,
	'qty' => $qty,
	'col_qty' => 1, //$col_qty,
	'align_by' => $align_by
));
?>
				</div>
			</div>
		</div>
<?php
if ($extra_classes) {
?>
		</div>
<?php
}
