<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

$view = $displayData['view'];

$row = $view->row;

$additional_classes = ' fwfm-menu-item-'.$row->id;

$text_align = $row->params->get('meal_text_alignment');
if (!$text_align or $text_align == 'def') {
	$text_align = $view->params->get('meal_text_alignment');
}
if (in_array($text_align, array('center', 'right'))) {
	$additional_classes .= ' fwfm-menu-item-align-'.$text_align;
}
$view->app->triggerEvent('onCollectMenuStatus', array('com_fwfoodmenu', $view, $row, &$additional_classes));

$additional_styles = '';
$view->app->triggerEvent('onCollectMenuCustomStyles', array('com_fwfoodmenu', $view, $row, &$additional_styles));

$additional_attrs = 'data-cat="'.(int)$row->category_id.'" data-name="'.esc_attr($row->name).'" data-description="'.esc_attr(strip_tags($row->description)).'"';
if ($additional_styles) {
	$additional_attrs .= ' style="'.esc_attr($additional_styles).'"';
}
$view->app->triggerEvent('onCollectMenuCustomAttributes', array('com_fwfoodmenu', $view, $row, &$additional_attrs));

$price_block = '';
$view->app->triggerEvent('onGetMenuPriceBlock', array('com_fwfoodmenu', $view, $row, &$price_block));

$view->app->triggerEvent('onSetExtraClasses', array('com_fwfoodmenu', $view));
?>
<div id="fwfm" class="fwcss fwfm-bootstrap <?php echo $view->params->get('extra_classes'); ?>">
	<div class="fwfm-item <?php echo $additional_classes; ?>" <?php echo $additional_attrs; ?>>
<?php
$view->app->triggerEvent('onShowMenuItemHeader', array('com_fwfoodmenu', $view, $row));
?>
		<div class="fwfm-menu-item-text">
<?php
$additional_styles = '';
$view->app->triggerEvent('onCollectMenuTitleCustomStyles', array('com_fwfoodmenu', $view, $row, &$additional_styles));
?>
			<div class="fwfm-menu-item-title"<?php if ($additional_styles) { ?> style="<?php echo $additional_styles; ?>"<?php } ?>>
				<span>
					<?php echo $row->name; ?>
<?php
$view->app->triggerEvent('onShowMenuPromoHeaderIcons', array('com_fwfoodmenu', $view, $row));
?>
				</span>

				<div class="fwfm-menu-item-price">
<?php
if ($price_block) {
	/*echo $price_block;*/
} elseif (!empty($row->_prices[0]->price)) {
?>
					<div class="fwfm-item-price-block">
						<div class="fwfm-item-price-row">
							<span class="fwfm-item-price"><?php echo fwFoodMenuHelper::formatPrice($row->_prices[0]->price); ?></span>
						</div>
					</div>
<?php
}
$view->app->triggerEvent('onShowMenuPriceOptions', array('com_fwfoodmenu', $view, $row));
?>
				</div>
			</div>
<?php
$view->app->triggerEvent('onShowMenuPromoBlock', array('com_fwfoodmenu', $view, $row));
$view->app->triggerEvent('onShowMenuPromoTopBadges', array('com_fwfoodmenu', $view, $row));
?>
			<div class="fwfm-menu-item-description">
				<?php echo $row->description; ?>
			</div>
<?php
$view->app->triggerEvent('onShowMenuBelowDescription', array('com_fwfoodmenu', $view, $row));
$view->app->triggerEvent('onShowMenuPromoBottom', array('com_fwfoodmenu', $view, $row));
$view->app->triggerEvent('onShowMenuItemOrderButton', array('com_fwfoodmenu', $view, $row));
$view->app->triggerEvent('onShowMenuPromoEnd', array('com_fwfoodmenu', $view, $row));
?>
		</div>
	</div>
</div>
