<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2019 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldFwFmColsQty extends JFormField {
	var	$type = 'fwfmcolsqty';

	function getInput() {
		if (!defined('FWFM_COMPONENT_SITE')) {
			define('FWFM_COMPONENT_SITE', JPATH_SITE.'/components/com_fwfoodmenu');
		}
		require_once(FWFM_COMPONENT_SITE.'/helpers/helper.php');

		fwFoodMenuHelper::loadAdminStyles();

		$qty = array();
		JFactory::getApplication()->triggerEvent('onGetFoodMenuColsQty', array('com_fwfoodmenu', &$qty));

		ob_start();
		if ($qty) {
			$name = str_replace(array('[', ']'), array('_', ''), $this->name);
?>
		<fieldset id="jform_<?php echo $name; ?>" class="uk-button-group radio">
<?php
			foreach ($qty as $i=>$col) {
				$id = $name.$col;
				$active = ($this->value == $col or (!$this->value and !$i));
?>
			<input type="radio" id="jform_<?php echo $id; ?>" name="<?php echo $this->name; ?>" value="<?php echo $col; ?>"<?php if ($active) { ?> checked="checked"<?php } ?>>
			<label for="jform_<?php echo $id; ?>" class="uk-button<?php if ($active) { ?> active uk-button-success<?php } ?>">
				<?php echo $col; ?>
			</label>
<?php
			}
?>
		</fieldset>
<?php
		} else {
?>
<div id="fwfmcolsqty"></div>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
	$('#fwfmcolsqty').closest('.control-group').hide();
	})(jQuery);
});
</script>
<?php
		}
		return ob_get_clean();
	}
}
