<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2019 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.html.html');
jimport('joomla.form.formfield');

class JFormFieldFwAddons extends JFormField {
	var	$type = 'fwaddons';

	function getInput() {
		if (!defined('FWFM_COMPONENT_SITE')) {
			define('FWFM_COMPONENT_SITE', JPATH_SITE.'/components/com_fwfoodmenu');
		}
		$params = fwfmGlobalParams::getInstance();
		if (!$params->get('show_addons_menu_settings')) {
			return JText::_('FWFM_ALL_ENABLED_ADDONS_ARE_ENABLED');
		}
		require_once(FWFM_COMPONENT_SITE.'/helpers/helper.php');

		fwFoodMenuHelper::loadAdminStyles();
		
		if (!is_array($this->value)) {
			$this->value = array();
		}

		ob_start();
		if ($list = fwFoodMenuHelper::loadPlugins() and !empty($list['fwfoodmenu'])) {
			$name = str_replace(array('[', ']'), array('_', ''), $this->name);
			$menu_id = JFactory::getApplication()->input->getInt('id');
			$lang = JFactory::getLanguage();
			foreach ($list['fwfoodmenu'] as $row) {
				$lang->load('plg_'.$row->folder.'_'.$row->element.'.sys', JPATH_ADMINISTRATOR);
				$id = $name.$row->element;
				if (!isset($this->value[$row->element])) {
					$this->value[$row->element] = $menu_id?0:1;
				}
?>
<div class="control-group">
	<div class="control-label">
		<?php echo JText::_('FW_FOODMENU_'.$row->element); ?>
	</div>
	<div class="controls">
		<fieldset id="jform_<?php echo $id; ?>" class="uk-button-group radio">
			<input type="radio" id="jform_<?php echo $id; ?>0" name="<?php echo $this->name; ?>[<?php echo $row->element ?>]" value="0"<?php if (empty($this->value[$row->element])) { ?> checked="checked"<?php } ?>>
			<label for="jform_<?php echo $id; ?>0" class="uk-button<?php if (empty($this->value[$row->element])) { ?> active uk-button-danger<?php } ?>">
				<?php echo JText::_('JNO'); ?>
			</label>
			<input type="radio" id="jform_<?php echo $id; ?>1" name="<?php echo $this->name; ?>[<?php echo $row->element ?>]" value="1"<?php if (!empty($this->value[$row->element])) { ?> checked="checked"<?php } ?>>
			<label for="jform_<?php echo $id; ?>1" class="uk-button<?php if (!empty($this->value[$row->element])) { ?> active uk-button-success<?php } ?>">
				<?php echo JText::_('JYES'); ?>
			</label>
		</fieldset>
	</div>
</div>
<?php
			}
		}
		return ob_get_clean();
	}
}
