<?php
/**
 * FW Food menu 5.1.1
 * @copyright C 2019 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

JHTML::_('behavior.core');
JHTML::_('formbehavior.chosen');

JToolBarHelper::title(JText::_('FWFM_ADMIN_LANG_TOOLBAR_TITLE'), 'world');
fwfmButtonsHelper::custom('copy', '', 'FWFM_DOC_ADMIN_LANG_TOOLBAR_BTN_OVERRIDES', 'copy', true);
fwfmButtonsHelper::custom('download', '', 'FWFM_DOC_ADMIN_LANG_TOOLBAR_BTN_BACKUP', 'download', false);
if (file_exists($this->path_overrides)) {
	fwfmButtonsHelper::custom('upload', '', 'FWFM_UPLOAD_TRANSLATION', 'upload', false);
}

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => JText::_('FWFM_DOC_ADMIN_LANG_TOOLBAR_BTN_CORRECTTRANSLATIONS'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_LANG_TOOLBAR_BTN_CORRECTTRANSLATIONS_HINT'),
	'view' => $this
), JPATH_COMPONENT);
?>
<form action="index.php?option=com_fwfoodmenu&view=translation&layout=translation" method="post" class="form-validate" name="adminForm" id="adminForm" enctype="multipart/form-data">
	<div class="fwa-separate-box fwa-filter-bar uk-grid-small" uk-grid>
		<div class="uk-width-1-2@l">
			<div class="uk-flex">
				<input class="uk-input" placeholder="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_LANG_FILTER_SEARCH')); ?>" type="text" name="search" value="<?php echo $this->escape($this->search); ?>" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_LANG_FILTER_SEARCH_HINT')); ?>">
                <button class="uk-button uk-button-outline-secondary" type="button" onclick="with(this.form){search.value='';task.value='';submit();}" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_CLEAR')); ?>"><span uk-icon="close"></span></button>
                <button class="uk-button uk-button-primary" type="submit" onclick="with(this.form){task.value='';submit();}" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_SEARCH_TRANSLATION')); ?>"><span uk-icon="search"></span></button>
			</div>
		</div>
        <div class="uk-width-1-4@l" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_LANG_FILTER_LANG_HINT')); ?>">
			<div class="select-style">
				<?php echo JHTML::_('select.genericlist', $this->languages, 'lang', 'class="uk-select advancedSelect" onchange="this.form.task.value=\'\';this.form.limitstart.value=0;this.form.submit();" style="float:none;"', 'id', 'name', $this->language); ?>
			</div>
		</div>
		<div class="uk-width-1-4@l" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_LANG_FILTER_ADMINSITE_HINT')); ?>">
			<?php echo JHTMLfwView::radioGroup('type', $this->type, array(
				'wrapper_class' => 'mb-0',
				'buttons' => array(array(
					'active_class' => 'uk-button-success',
					'title' => JText::_('FWFM_FRONTEND'),
					'value' => 1
				), array(
					'active_class' => 'uk-button-success',
					'title' => JText::_('FWFM_BACKEND'),
					'value' => 0
				))
			)); ?>
		</div>
	</div>
<div class="fwa-separate-box">
    <div class="uk-alert uk-alert-info">
        <?php echo JText::_('FWFM_LANGUAGE_FILE_PATH'); ?>: <?php echo $this->path; ?>
    </div>
    <div class="uk-alert uk-alert-danger">
        <?php echo JText::_('FWFM_LANGUAGE_OVERRIDES_FILE_PATH'); ?>: <?php echo $this->path_overrides; ?>
    </div>
    <div class="table-responsive">
	<table class="table table-striped">
		<thead>
			<tr>
                <th width="20px"><input name="toggle" class="uk-checkbox" value="" onclick="Joomla.checkAll(this);" type="checkbox" /></th>
				<th width="25%" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_LANG_COLUMN_SOURCE_HINT')); ?>"><?php echo JText::_('FWFM_DOC_ADMIN_LANG_COLUMN_SOURCE'); ?> (en-GB)</th>
                <th width="30px" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_LANG_COLUMN_OVERRIDES_HINT')); ?>"><?php echo JText::_('FWFM_DOC_ADMIN_LANG_COLUMN_OVERRIDES'); ?></th>
				<th uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_LANG_COLUMN_OUTCOME_HINT')); ?>"><?php echo JText::_('FWFM_DOC_ADMIN_LANG_COLUMN_OUTCOME'); ?> (<?php echo $this->languages[$this->language]->tag; ?>)</th>
                <th width="12%" class="uk-text-center" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_LANG_COLUMN_TOOVERRIDES_HINT')); ?>"><?php echo JText::_('FWFM_DOC_ADMIN_LANG_COLUMN_TOOVERRIDES') ?></th>
			</tr>
		</thead>
		<tbody id="fwre-translations-list">
<?php
$num = 0;
foreach ($this->data as $const=>$row) {
?>
			<tr>
                <td><?php echo JHTML::_('grid.id', $num, $const); ?></td>
				<td>
                    <?php echo $row['src']; ?>
                    <div class="small text-muted uk-margin-small-top">
                        <?php echo $this->escape($const); ?>
                    </div>
                </td>
                <td class="uk-text-center"><?php if (isset($row['override'])) { ?><span uk-tooltip="<?php echo JText::_('FWFM_OVERRIDES_HINT'); ?>"><i uk-icon="warning" class="uk-text-danger"></i></span><?php } ?></td>
				<td><input type="text" class="uk-input" name="lang_data[<?php echo $const; ?>]" value="<?php echo htmlspecialchars($row['trg']); ?>" /></td>
                <td class="uk-text-center"><button class="uk-button uk-button-small uk-button-danger" type="button"><i uk-icon="copy" class="uk-margin-small-right"></i><?php echo JText::_('FWFM_BTN_TO_OVERRIDES') ?></button></td>
			</tr>
<?php
}
?>
		</tbody>
	</table>
    </div>
	<div class="fwa-pagination">
		<div class="fwa-pagination-total">
			<?php echo $this->pagination->getResultsCounter(); ?>
		</div>
		<div class="fwa-pagination-pages">
			<?php echo $this->pagination->getListFooter(); ?>
		</div>
		<div class="fwa-pagination-limit">
			<div class="d-inline-block">
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
		</div>
	</div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="format" value="html" />
	<input type="hidden" name="layout" value="translation" />
	<input type="hidden" name="boxchecked" value="0" />
</div>
</form>
<script>
document.addEventListener('DOMContentLoaded', function() {
    (function($) {
        Joomla.submitbutton = function(pressbutton) {
            if (pressbutton) {
                with (document.adminForm) {
                    if (pressbutton == 'download') {
                        layout.value = 'download';
                        format.value = 'raw';
                        task.value = '';
                        document.adminForm.submit();
                        layout.value = 'translation';
                        format.value = 'html';
                    } else if (pressbutton == 'upload') {
                        var $wait = $('<div uk-spinner></div>');
                        var $btn = $('.fwa-toolbar button:has(\'[uk-icon=[upload]]\')').attr('disabled', true).after($wait);
                        $.ajax({
                            dataType: 'json',
                            data: {
                                format: 'json',
                                view: 'translation',
                                layout: 'upload',
                                extension: '<?php echo $this->extension; ?>',
                                lang: '<?php echo $this->language ?>',
                                type: $('input[name="type"]').val()
                            }
                        }).done(function(data) {
                            $btn.attr('disabled', false);
                            $wait.remove();
                            if (data.msg) {
                                alert(data.msg);
                            }
                        });
                    } else {
                        layout.value = 'translation';
                        format.value = 'html';
                        task.value = pressbutton;
                        document.adminForm.submit();
                    }
                }
            }
        }
        $('input[name="type"]').change(function() {
            this.form.submit();
        });
        $('#fwre-translations-list button:has(\'[uk-icon="copy"]\')').click(function() {
            var $btn = $(this).attr('disabled', true);
            var $row = $btn.closest('tr');

            var id = $row.find('input[type="text"]').attr('name').replace('lang_data[', '').replace(']', '');
            var lang_data = {};
            lang_data[id] = $row.find('input[type="text"]').val();
            $.ajax({
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'translation',
                    layout: 'copy_to_overrides',
                    lang: '<?php echo $this->language ?>',
                    type: $('input[name="type"]').val(),
                    cid: [id],
                    lang_data: lang_data
                }
            }).done(function(data) {
                $btn.attr('disabled', false);
                if (data.result) {
                    var $icon = $('<i uk-icon="warning" class="uk-text-danger"></i>');
                    $btn.parent().prev().prev().html('<span uk-tooltip="<?php echo JText::_('FWFM_OVERRIDES_HINT', true); ?>"><i uk-icon="warning" class="uk-text-danger"></i></span>');
                }
                if (data.msg) {
                    alert(data.msg);
                }
            });
        });

		var $limitstart = $('#adminForm input[name="limitstart"]');
		if (!$limitstart.length) {
			$limitstart = $('<input type="hidden" name="limitstart" />');
			$('#adminForm').append($limitstart);
		}
    })(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);
