<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

JToolBarHelper::title(JText::_('FWFM_ADMIN_DASHBOARD_TOOLBAR_TITLE'), 'tachometer');

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => JText::_('FWFM_DOC_ADMIN_DASHBOARD'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_DASHBOARD_HINT'),
	'view' => $this
), JPATH_COMPONENT);
?>
<form id="adminForm" name="adminForm" method="post" action="index.php?option=com_fwfoodmenu&view=menu" enctype="multipart/form-data">
	<div class="uk-child-width-1-2@m" uk-grid="masonry: true">
		<div>
        </div>

        <div>
            <div class="uk-card uk-card-default fwa-demo-data">
                <div class="uk-card-header">
                    <h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_DEMODATA'); ?></h4>
                    <div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_DEMODATA_HINT'); ?></div>
                </div>
                <div class="uk-card-body">
                    <div class="uk-flex">
                        <div class="uk-width-1-3@m uk-text-center">
                            <button type="button" class="uk-button uk-button-large uk-button-warning px-4 py-3 text-uppercase">
                                <div class="mb-2"><i uk-icon="icon: desktop; ratio: 2"></i> + <i uk-icon="icon: file; ratio: 2"></i></div>
                                <?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_DEMODATA_BTN'); ?>
                            </button>
                        </div>
                        <div class="uk-width-2-3@m uk-alert uk-alert-danger"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_DEMODATA_TEXT'); ?></div>
                    </div>
                </div>
            </div>
        </div>

        <div>
            <div class="uk-card uk-card-default fwa-stats">
                <div class="uk-card-header">
                    <h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_STATS'); ?></h4>
                    <div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_STATS_HINT'); ?></div>
                </div>
                <div class="uk-card-body">
                    <div class="uk-child-width-1-3 uk-grid-small" uk-grid>
                        <div class="uk-text-center">
                            <i uk-icon="icon: folder; ratio: 3" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_DASHBOARD_STATS_CATEGORIES_HINT')); ?>"></i>
                            <br><a href="index.php?option=com_fwfoodmenu&view=category"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_STATS_CATEGORIES'); ?></a>
                            <br> <?php echo $this->locstat->cp; ?> / <?php echo $this->locstat->ct; ?>
                        </div>
                        <div class="uk-text-center">
                            <i uk-icon="icon: image; ratio: 3" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_DASHBOARD_STATS_MEALS_HINT')); ?>"></i>
                            <br><a href="index.php?option=com_fwfoodmenu&view=items"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_STATS_MEALS'); ?></a>
                            <br> <?php echo $this->locstat->mp; ?> / <?php echo $this->locstat->mt; ?>
                        </div>
                        <div class="uk-text-center">
                            <i uk-icon="icon: hdd; ratio: 3" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_DASHBOARD_STATS_FILES_HINT')); ?>"></i>
                            <br><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_STATS_FILES'); ?>
                            <br><?php echo fwFoodMenuHelper::humanFileSize($this->locstat->fs); ?>
                        </div>
                    </div>
                </div>
            </div>                
        </div>

        <div>
            <div class="uk-card uk-card-default fwa-check check-<?php if ($this->qch->test_passed) { ?>success<?php } else { ?>fail<?php } ?>">
                <div class="uk-card-header">
                    <h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_CHECK_NOPARAMS'); ?> - <?php echo JText::_($this->qch->test_passed?'FWFM_PASSED':'FWFM_FAILED'); ?></h4>
                    <div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_CHECK_HINT'); ?></div>
                </div>
                <div class="uk-card-body">
                    <div class="table-responsive">
                    <table class="table table-striped">
                        <tbody><tr>
                            <td><?php echo JText::_('FWFM_JOOMLA_MEDIA_FOLDER'); ?></td>
                            <td>
<?php
if ($this->qch->media_folder_exists) {
?>
                                <i uk-icon="check"></i> <?php echo JText::_('FWFM_EXISTS_SMALL'); ?>
<?php
} else {
?>
                                <span uk-icon="close"></span> <?php echo JText::_('FWFM_NOT_EXISTS_SMALL'); ?>
<?php
}
?>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo JText::_('FWFM_IMAGES_FOLDER'); ?></td>
                            <td>
<?php
if ($this->qch->gallery_folder_exists) {
?>
                                <i uk-icon="check"></i> <?php echo JText::_('FWFM_EXISTS_SMALL'); ?>
<?php
} else {
?>
                                <span uk-icon="close"></span> <?php echo JText::_('FWFM_NOT_EXISTS_SMALL'); ?>
<?php
}
?>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo JText::_('FWFM_IMAGES_FOLDER'); ?></td>
                            <td>
<?php
if ($this->qch->gallery_folder_writeable) {
?>
                                <i uk-icon="check"></i> <?php echo JText::_('FWFM_WRITABLE_SMALL'); ?>
<?php
} else {
?>
                                <span uk-icon="close"></span> <?php echo JText::_('FWFM_NOT_WRITABLE_SMALL'); ?>
<?php
}
?>
                            </td>
                        </tr>
                        <tr>
                            <td><?php echo JText::_('FWFM_MAX_TOTAL_POST_SIZE'); ?></td>
                            <td><?php echo fwFoodMenuHelper::humanFileSize(fwFoodMenuHelper::getIniSize('post_max_size')); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo JText::_('FWFM_MAX_FILE_SIZE'); ?></td>
                            <td><?php echo fwFoodMenuHelper::humanFileSize(fwFoodMenuHelper::getIniSize('upload_max_filesize')); ?></td>
                        </tr>
                        <tr>
                            <td><?php echo JText::_('FWFM_MAX_FILES_PER_POST'); ?></td>
                            <td><?php echo ini_get('max_file_uploads'); ?></td>
                        </tr>
                    </tbody></table></div>
                </div>
            </div>
        </div>
<?php
if (class_exists('JVersion')) {
?>
        <div>
            <div class="uk-card uk-card-default">
                <div class="uk-card-header">
                    <h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_REVIEW_NOPARAMS'); ?></h4>
                    <div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_DASHBOARD_REVIEW_HINT'); ?></div>
                </div>
                <div class="uk-card-body">
                    <p><?php echo JText::_('FWFM_SPREAD_THE_LOVE_HINT'); ?></p>
                    <div class="uk-text-center">
                        <a href="https://extensions.joomla.org/extensions/extension/vertical-markets/food-a-beverage/fw-food-menu/" target="_blank" class="uk-button uk-button-success uk-text-center"><i uk-icon="heart" class="uk-margin-small-right"></i> <?php echo JText::_('FWFM_ADMIN_DASHBOARD_REVIEW_LEAVE'); ?></a>
                    </div>
                </div>
            </div>
        </div>
<?php
}
?>
	</div>

	<input type="hidden" name="task" value="" />
	<input type="hidden" name="oid" value="1" />
</form>
<div id="fwfm-demo-install-log" class="uk-modal-container" uk-modal>
  <div class="uk-modal-dialog">
      <div class="uk-modal-header">
        <h5 class="uk-modal-title"><?php echo JText::_('FWFM_DEMO_DATA_INSTALLATION') ?></h5>
        <button class="uk-modal-close-default" type="button" uk-close></button>
      </div>
      <div class="uk-modal-body"></div>
  </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    (function($) {
        $('.fwa-demo-data button').click(function() {
            var $btn = $(this);
            if (confirm('<?php echo esc_js(JText::_('FWFM_ARE_YOU_SURE_INSTALL_DEMO_DATA')); ?>')) {
                $btn.attr('disabled', true);

                var $popup = $('#fwfm-demo-install-log');
                UIkit.modal($popup[0]).show();

                $popup.find('.uk-modal-body').html('<div class="uk-alert uk-alert-info"><div uk-spinner></div> <?php echo esc_js(JText::_('FWFM_DOWNLOADING_DEMO_DATA')); ?></div>');
                $.ajax({
                    dataType: 'json',
                    data: {
                        format: 'json',
                        view: 'menu',
                        layout: 'demo_download'
                    }
                }).done(function(data) {
                    if (data.result) {
                        $popup.find('.uk-modal-body').html('<div class="uk-alert uk-alert-info"><div uk-spinner></div> <?php echo esc_js(JText::_('FWFM_UNPACKING_DEMO_DATA')); ?></div>');
                        $.ajax({
                            dataType: 'json',
                            data: {
                                format: 'json',
                                view: 'menu',
                                layout: 'demo_unpack'
                            }
                        }).done(function(data) {
                            $btn.attr('disabled', false);
                            if (data.msgs) {
                                $popup.find('.uk-modal-body').html('');
                                for (var i = 0; i < data.msgs.length; i++) {
                                    var $row = $('<div class="uk-alert uk-alert-'+data.msgs[i].status+'"></div>');
                                    $popup.find('.uk-modal-body').append($row);
                                    $row.html(data.msgs[i].msg);
                                }
                            }
                        }).fail(function(jqXHR, text_status) {
                            $btn.attr('disabled', false);
                            $popup.find('.uk-modal-body').html('<div class="uk-alert uk-alert-danger">'+text_status+'</div>');
                        });
                    } else {
                        $btn.attr('disabled', false);
                        if (data.msgs && data.msgs.length) {
                            $popup.find('.uk-modal-body').html('');
                            for (var i = 0; i < data.msgs.length; i++) {
                                var $row = $('<div class="uk-alert uk-alert-'+data.msgs[i].status+'"></div>');
                                $popup.find('.uk-modal-body').append($row);
                                $row.html(data.msgs[i].msg);
                            }
                        }
                    }
                }).fail(function(jqXHR, text_status) {
                    $btn.attr('disabled', false);
                    $popup.find('.uk-modal-body').html('<div class="uk-alert uk-alert-danger">'+text_status+'</div>');
                });
            }
        });
    })(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);
