<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

JHTML::_('behavior.core');
JHTML::_('jquery.framework');
JHTML::_('formbehavior.chosen');
fwFoodMenuHelper::colorpicker();

$listDirn = 'asc';
$listOrder = 'ordering';
JHtml::_('sortablelist.sortable', 'fwfm-sizes', 'adminForm', strtolower($listDirn), '', false, true);

JToolBarHelper::title(JText::_('FWFM_ADMIN_MEALSEDIT_TOOLBAR_TITLE'), 'utensils');

fwfmButtonsHelper::apply('apply', 'FWFM_DOC_ADMIN_MEALSEDIT_TOOLBAR_BTN_SAVE');
fwfmButtonsHelper::save('save', 'FWFM_DOC_ADMIN_MEALSEDIT_TOOLBAR_BTN_SAVECLOSE');
fwfmButtonsHelper::save2New('save2new', 'FWFM_DOC_ADMIN_MEALSEDIT_TOOLBAR_BTN_SAVENEW');
fwfmButtonsHelper::save2Copy('save2copy', 'FWFM_DOC_ADMIN_MEALSEDIT_TOOLBAR_BTN_SAVECOPY');
fwfmButtonsHelper::cancel('cancel', 'FWFM_DOC_ADMIN_MEALSEDIT_TOOLBAR_BTN_CANCEL');

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => $this->object->id?JText::sprintf('FWFM_ADMIN_MEALSEDIT_EDIT', $this->object->name):JText::_('FWFM_ADMIN_MEALSEDIT_ADD'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_MEALSEDIT_HINT'),
	'view' => $this
), JPATH_COMPONENT);
$editor = fwFoodMenuHelper::getEditor();
?>
<form id="adminForm" name="adminForm" method="post" action="index.php?option=com_fwfoodmenu&view=items" enctype="multipart/form-data">
	<div class="fwa-separate-box fwa-filter-bar">
<?php
$this->app->triggerEvent('onShowLanguageFiltersEdit', array('com_fwfoodmenu', $this));
?>
    </div>
	<div class="fwa-separate-box uk-child-width-1-2@l fwa-mb-cardbox uk-grid-small" uk-grid>
		<div>
			<div class="uk-card">
				<div class="uk-card-header">
					<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS'); ?></h4>
				</div>
				<div class="uk-card-body">
					<div uk-grid>
						<div class="uk-width-2-5@s">
							<?php echo JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_PUBLISHED'); ?>
							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_PUBLISHED_HINT')); ?>"></i>
						</div>
						<div class="uk-width-3-5@s">
							<?php echo JHTML::_('fwView.radioGroup', 'published', $this->object->id?$this->object->published:1, array(
								'wrapper_class' => 'uk-margin-right',
								'buttons' => array(array(
									'active_class' => 'uk-button-success',
									'title' => JText::_('JYES'),
									'value' => 1
								), array(
									'active_class' => 'uk-button-danger',
									'title' => JText::_('JNO'),
									'value' => 0
								))
							)); ?>
						</div>
					</div>
					<div uk-grid>
						<div class="uk-width-2-5@s">
							<?php echo JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_CATEGORY'); ?>
							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_CATEGORY_HINT')); ?>"></i>
						</div>
						<div class="uk-width-3-5@s">
							<?php echo JHTML::_('fwfCategory.parent', (object)array('category_id'=>$this->object->category_id), 'category_id', 'class="form-control advancedSelect"', ''); ?>
						</div>
					</div>
					<div uk-grid>
						<div class="uk-width-2-5@s">
							<?php echo JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_NAME'); ?>
							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_NAME_HINT')); ?>"></i>
						</div>
						<div class="uk-width-3-5@s">
							<input class="uk-input" value="<?php echo $this->escape($this->object->name); ?>" id="fwfm-name" type="text" name="name"/>
						</div>
					</div>
					<div uk-grid>
						<div class="uk-width-2-5@s">
							<?php echo JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_ALIGNMENT'); ?>
							<i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_ALIGNMENT_HINT')); ?>"></i>
						</div>
						<div class="uk-width-3-5@s">
							<?php echo JHTMLfwView::radioGroup('params[meal_text_alignment]', $this->object->params->get('meal_text_alignment', 'def'), array(
								'wrapper_class' => 'uk-margin-right',
								'buttons' => array(array(
									'active_class' => 'uk-button-success',
									'title' => JText::_('FWFM_DEFAULT'),
									'value' => 'def'
								), array(
									'active_class' => 'uk-button-success',
									'title' => JText::_('FWFM_LEFT'),
									'value' => 'left'
								), array(
									'active_class' => 'uk-button-success',
									'title' => JText::_('FWFM_CENTER'),
									'value' => 'center'
								), array(
									'active_class' => 'uk-button-success',
									'title' => JText::_('FWFM_RIGHT'),
									'value' => 'right'
								))
							)); ?>
						</div>
					</div>

<?php
$prices = '';
$this->app->triggerEvent('onGetMenuEditPrices', array('com_fwfoodmenu', $this, &$prices));
if ($prices) {
	echo $prices;
} else {
?>
                    <div uk-grid>
                        <div class="uk-width-2-5@s">
                            <?php echo JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_PRICE'); ?>
                            <i uk-icon="question" class="uk-align-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DETAILS_PRICE_HINT')); ?>"></i>
                        </div>
                        <div class="uk-width-3-5@s">
                            <div class="uk-flex">
<?php
	if (!$this->params->get('currency_after')) {
?>
								<span class="input-group-text"><?php echo $this->params->get('currency'); ?></span>
<?php
	}
?>
                                <input name="prices[0][price]" class="uk-input" value="<?php if (!empty($this->object->_prices[0]->price)) echo $this->escape($this->object->_prices[0]->price); ?>" />
<?php
	if ($this->params->get('currency_after')) {
?>
								<span class="input-group-text"><?php echo $this->params->get('currency'); ?></span>
<?php
	}
?>
                            </div>
                        </div>
                    </div>
<?php
}
?>
                </div>
            </div>
            <div class="uk-card">
				<div class="uk-card-header">
					<h4 class="uk-card-title"><?php echo JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DESCRIPTION'); ?></h4>
					<div class="uk-card-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_MEALSEDIT_SECTION_DESCRIPTION_DESCRIPTION_HINT'); ?></div>
				</div>
				<div class="uk-card-body">
                    <?php echo $editor->display('description', $this->object->description, '100%', 200, 60, 10, $buttons = false); ?>
                </div>
    		</div>
		</div>
		<div>
<?php
$this->app->triggerEvent('onShowMenuEditExtraCardsRight', array('com_fwfoodmenu', $this));
?>
		</div>
	</div>
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="oid" value="<?php echo $this->object->id; ?>" />
    <input type="hidden" name="limitstart" value="<?php echo $this->input->getInt('limitstart'); ?>" />
<?php
foreach ($this->fields as $field) {
    if ($this->$field) {
?>
    <input type="hidden" name="<?php echo $field; ?>" value="<?php echo $this->escape($this->$field); ?>" />
<?php
    }
}
?>
</form>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
    $('button:has(\'[uk-icon="paint-brush"]\')').click(function() {
        $(this).parent().find('input').focus();
    });
	})(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);
