<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

JHTML::_('behavior.core');
$save_ordering_url = 'index.php?option=com_fwfoodmenu&view=items&layout=save_order&format=raw';
$icon_class = '';
if ($this->list) {
	if (defined('JVERSION') and version_compare(JVERSION, '4', '>=')) {
		JHTML::_('draggablelist.draggable');
		$icon_class = 'icon-ellipsis-v d-inline-block px-2';
	} else {
		JHTML::_('sortablelist.sortable', 'fwfm-list-to-sort', 'adminForm', 'asc', $save_ordering_url);
		$icon_class = 'icon-menu';
	}
}

JToolBarHelper::title(JText::_('FWFM_ADMIN_MEALS_TOOLBAR_TITLE'), 'utensils');

fwfmButtonsHelper::addNew('add', 'FWFM_DOC_ADMIN_MEALS_TOOLBAR_BTN_NEW');
fwfmButtonsHelper::custom('upload', '', 'FWFM_DOC_ADMIN_MEALS_TOOLBAR_BTN_QUICKMEALS', 'quick', false);
fwfmButtonsHelper::publish('publish', 'FWFM_DOC_ADMIN_MEALS_TOOLBAR_BTN_PUBLISH');
fwfmButtonsHelper::unpublish('unpublish', 'FWFM_DOC_ADMIN_MEALS_TOOLBAR_BTN_UNPUBLISH');
fwfmButtonsHelper::custom('check', '', 'FWFM_DOC_ADMIN_MEALS_TOOLBAR_BTN_BATCH', 'batch', true);
fwfmButtonsHelper::editList('edit', 'FWFM_DOC_ADMIN_MEALS_TOOLBAR_BTN_EDIT');
fwfmButtonsHelper::custom('copy', '', 'FWFM_DOC_ADMIN_MEALS_TOOLBAR_BTN_COPY', 'copy', true);
fwfmButtonsHelper::deleteList(JText::_('FWFM_ADMIN_MEALS_TOOLBAR_BTN_DELETE_MSG'), 'remove', 'FWFM_DOC_ADMIN_MEALS_TOOLBAR_BTN_DELETE');

JHTML::_('formbehavior.chosen');

echo JLayoutHelper::render('common.menu_begin', array(
    'title' => JText::_('FWFM_DOC_ADMIN_MEALS'),
    'title_hint' => JText::_('FWFM_DOC_ADMIN_MEALS_HINT'),
	'view' => $this
), JPATH_COMPONENT);
?>
<form id="adminForm" name="adminForm" method="post" action="index.php?option=com_fwfoodmenu&view=items">
    <div class="fwa-separate-box fwa-filter-bar uk-grid-small" uk-grid>
        <div class="uk-width-1-6@l" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALS_FILTER_CATEGORY_HINT')); ?>">
            <div class="input-group" >
                <?php echo JHTML::_('fwfCategory.parent', (object)array('category'=>$this->category), 'category', 'class="uk-select advancedSelect" onchange="with(this.form){limitstart.value=0;submit();}"', 'FWFM_DOC_ADMIN_MEALS_FILTER_CATEGORY', false, 'fwfm-category'); ?>
            </div>
        </div>
        <div class="uk-width-1-2@l"  uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALS_FILTER_SEARCH_HINT')); ?>">
            <div class="uk-flex">
                <input class="form-control" placeholder="<?php echo JText::_('FWFM_DOC_ADMIN_MEALS_FILTER_SEARCH'); ?>" type="text" name="search" value="<?php echo $this->escape($this->search); ?>" />
				<button class="uk-button uk-button-outline-secondary" type="button" onclick="with(this.form){limitstart.value=0;search.value='';submit();}"><span uk-icon="close"></span></button>
				<button class="uk-button uk-button-primary" type="submit"><span uk-icon="search"></span></button>
            </div>
        </div>
        <div class="uk-width-1-6@l" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALS_FILTER_STATE_HINT')); ?>">
			<?php echo JHTML::_('select.genericlist', array(
				JHTML::_('select.option', '', JText::_('FWFM_DOC_ADMIN_MEALS_FILTER_STATE'), 'id', 'name'),
				JHTML::_('select.option', 'published', JText::_('FWFM_ADMIN_PUBLISHED'), 'id', 'name'),
				JHTML::_('select.option', 'unpublished', JText::_('FWFM_ADMIN_UNPUBLISHED'), 'id', 'name'),
			), 'state', 'class="uk-select advancedSelect" onchange="with(this.form){limitstart.value=0;submit();}"', 'id', 'name', $this->state); ?>
        </div>
<?php
$this->app->triggerEvent('onShowMealListFilters', array('com_fwfoodmenu', $this));
$this->app->triggerEvent('onShowLanguageFilters', array('com_fwfoodmenu', $this));
?>
    </div>
	<div class="fwa-separate-box">
	<div class="table-responsive">
	<table class="table table-striped" id="fwfm-list-to-sort">
		<thead>
			<tr>
				<th style="width:20px;"><input class="uk-checkbox" name="toggle" value="" onclick="Joomla.checkAll(this);" type="checkbox"></th>
				<th style="width:20px;" class="uk-text-center"><i uk-icon="sort"></i></th>
<?php
$this->app->triggerEvent('onShowMenuListBeginExtraHeaders', array('com_fwfoodmenu', $this));
?>
				<th uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALS_COLUMN_NAME_HINT')); ?>"><?php echo JText::_('FWFM_DOC_ADMIN_MEALS_COLUMN_NAME'); ?></th>
				<th class="uk-text-right" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALS_COLUMN_PRICE_HINT')); ?>"><?php echo JText::_('FWFM_DOC_ADMIN_MEALS_COLUMN_PRICE'); ?></th>
<?php
$this->app->triggerEvent('onShowMenuListMiddleExtraHeaders', array('com_fwfoodmenu', $this));
?>
				<th uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALS_COLUMN_PUBLISHED_HINT')); ?>"><?php echo JText::_('FWFM_DOC_ADMIN_MEALS_COLUMN_PUBLISHED'); ?></th>
<?php
$this->app->triggerEvent('onShowMenuListEndExtraHeaders', array('com_fwfoodmenu', $this));
?>
			</tr>
		</thead>
		<tbody class="js-draggable" data-url="<?php echo $save_ordering_url; ?>" data-direction="asc" data-nested="false">
<?php
if ($this->list) {
	foreach ($this->list as $num=>$row) {
		$price_col = '';
		$description = strip_tags($row->description);
		$total = strlen($description);
		if ($total > 200) $description = mb_substr($description, 0, 196).'...('.$total.')';

		$this->app->triggerEvent('onGetMenuListPriceColumn', array('com_fwfoodmenu', $this, $row, $num, &$price_col));
?>
			<tr data-draggable-group="0" data-item-id="<?php echo $row->id; ?>" data-parents="">
				<td>
					<?php echo JHTML :: _('grid.id', $num, $row->id); ?>
					<input type="hidden" name="order[]" value="<?php echo (int)$row->ordering; ?>">
				</td>
				<td>
					<span class="sortable-handler">
						<span class="<?php echo $icon_class; ?>"></span>
					</span>
				</td>
<?php
		$this->app->triggerEvent('onShowMenuListBeginExtraColumns', array('com_fwfoodmenu', $this, $row, $num));
?>
				<td>
					<a href="index.php?option=com_fwfoodmenu&amp;view=items&amp;task=edit&amp;cid[]=<?php echo $row->id.$this->extra_link; ?>">
						<?php echo $row->name; ?>
					</a> <span>
<?php
		$this->app->triggerEvent('onShowMenuListExtraNameData', array('com_fwfoodmenu', $this, $row, $num));
?>
					<div class=" uk-margin-small-top"><?php echo $description; ?></div>
					<div class=" uk-margin-top small">
						<span class="text-muted" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALS_COLUMN_ID_HINT')); ?>"><?php echo JText::_('FWFM_DOC_ADMIN_MEALS_COLUMN_ID'); ?>: <?php echo $row->id; ?></span>
						<span class="uk-margin-left" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALS_COLUMN_CATEGORY_HINT')); ?>">
							<i uk-icon="folder" class="uk-margin-small-right"></i> <?php echo $row->_category_name; ?>
						</span>

						
					</div>
				</td>
				<td class="uk-text-right">
<?php
		if ($price_col) {
			echo $price_col;
		} elseif (!empty($row->_prices[0]->price)) {
			echo fwFoodMenuHelper::formatPrice($row->_prices[0]->price);
		}
?>
                </td>
<?php
		$this->app->triggerEvent('onShowMenuListMiddleExtraColumns', array('com_fwfoodmenu', $this, $row, $num));
?>
				<td class="uk-text-center">
					<?php echo JHTMLfwView::booleanListLink(array(
						'num' => $num,
						'value' => $row->published,
						'task_on' => 'publish',
						'task_off' => 'unpublish',
						'title_on' => JText::_('FWFM_MENU_PUBLISH'),
						'title_off' => JText::_('FWFM_MENU_UNPUBLISH')
					)); ?>
				</td>
<?php
		$this->app->triggerEvent('onShowMenuListEndExtraColumns', array('com_fwfoodmenu', $this, $row, $num));
?>
			</tr>
<?php
	}
} else {

}
?>
		</tbody>
	</table>
	</div>
	<div class="fwa-pagination">
		<div class="fwa-pagination-total">
			<?php echo $this->pagination->getResultsCounter(); ?>
		</div>
		<div class="fwa-pagination-pages">
			<?php echo $this->pagination->getListFooter(); ?>
		</div>
		<div class="fwa-pagination-limit">
			<div class="d-inline-block">
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
		</div>
	</div>
	</div>
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="task" value="" />
</form>
<div id="fwfm-batch-operations" class="uk-modal-container" uk-modal>
	<div class="uk-modal-dialog">
		<div class="uk-modal-header">
			<h5 class="uk-modal-title">
				<?php echo JText::_('FWFM_DOC_ADMIN_MEALS_MODAL_BATCH'); ?>
				<div class="uk-modal-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_MEALS_MODAL_BATCH_HINT'); ?></div>
			</h5>
			<button class="uk-modal-close-default" type="button" uk-close></button>
		</div>
		<form action="index.php?option=com_fwfoodmenu&amp;view=items" method="post" name="operationsForm" id="operationsForm">
			<div class="uk-modal-body">
				<div class="uk-child-width-1-2@m" uk-grid>
					<div>
						<label for="fwfm-category-batch"><?php echo JText::_('FWFM_DOC_ADMIN_MEALS_MODAL_BATCH_CATEGORY'); ?></label>
						<i uk-icon="question" class="uk-margin-left" uk-tooltip="<?php echo $this->escape(JText::_('FWFM_DOC_ADMIN_MEALS_MODAL_BATCH_CATEGORY_HINT')); ?>"></i>
						<?php echo JHTML::_('fwfCategory.parent', '', 'category_id', 'class="form-control advancedSelect"', 'FWFM_ADMIN_MEALS_MODAL_BATCH_CATEGORY_SAME'); ?>
					</div>
<?php
$this->app->triggerEvent('onShowBachProcessingExtraFields', array('com_fwfoodmenu', $this));
?>
				</div>
			</div>
			<div class="uk-modal-footer">
				<button type="button" class="uk-button uk-modal-close"><?php echo JText::_('FWFM_DOC_ADMIN_MEALS_MODAL_BATCH_BTN_CANCEL'); ?></button>
				<button type="submit" class="uk-button uk-button-success"><?php echo JText::_('FWFM_DOC_ADMIN_MEALS_MODAL_BATCH_BTN_PROCESS'); ?></button>
			</div>
			<input type="hidden" name="task" value="dobatch" />
<?php
foreach ($this->fields as $field) {
	if ($this->$field) {
?>
			<input type="hidden" name="<?php echo $field; ?>" value="<?php echo $this->escape($this->$field); ?>" />
<?php
	}
}
?>
		</form>
	</div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
		Joomla.submitbutton = function(pressbutton) {
			if (pressbutton == 'quick') {
				UIkit.modal('#fwfm-quick-meals').show()
			} else if (pressbutton == 'batch') {
				UIkit.modal('#fwfm-batch-operations').show()
			} else {
				document.adminForm.task.value=pressbutton;
				document.adminForm.submit();
			}
		}
		$('td[data-cid]').click(function() {
			var cid = $(this).data('cid');
			$('#fwfm-category').val(cid).trigger("liszt:updated").change();
		});
		$('#fwfm-batch-operations').on('show', function() {
			var $form = $(this).find('form');
			$form.find('input[name="cid[]"]').remove();
			var $cids = $('#adminForm input[name="cid[]"]:checked').each(function() {
				var $inp = $('<input />', {
					type: 'hidden',
					name: 'cid[]',
					'value': this.value
				});
				$form.append($inp);
			});
		});
		$('#toolbar-upload button').addClass('uk-button-primary');

		var $limitstart = $('#adminForm input[name="limitstart"]');
		if (!$limitstart.length) {
			$limitstart = $('<input type="hidden" name="limitstart" />');
			$('#adminForm').append($limitstart);
		}
	})(jQuery);
});
</script>
<?php
echo JLayoutHelper::render('utilites.quick_categories', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('utilites.quick_meals', array('view'=>$this), JPATH_COMPONENT);
echo JLayoutHelper::render('common.menu_end', array(), JPATH_COMPONENT);
