<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2021 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

class TablePwa extends JTable {
    var $id = null,
        $user_id = null,
        $created = null,
        $user_type = null,
        $type = null,
        $endpoint = null,
        $auth = null,
        $p256dh = null;

    function __construct(&$db) {
        parent::__construct('#__fwfoodmenu_pwa', 'id', $db);
    }
    function bind($data, $skip=null) {
        if ($data) {
            $keys = array_keys($this->getProperties());
            foreach ($data as $key=>$val) {
                if (!in_array($key, $keys) or ($skip and in_array($key, $skip))) {
                    continue;
                }
                $this->$key = $val;
            }
        }
        if (!empty($data['keys'])) {
            if (!empty($data['keys']['auth'])) {
                $this->auth = $data['keys']['auth'];
            }
            if (!empty($data['keys']['p256dh'])) {
                $this->p256dh = $data['keys']['p256dh'];
            }
        }
        return true;
    }
    function check() {
        if (!$this->endpoint) {
            $this->setError('No Endpoint URL');
            return;
        }
        if (!$this->user_id) {
            $this->user_id = JFactory::getUser()->id;
        }
        if (!$this->user_id) {
            $this->setError('No User ID');
            return;
        }
        if (!$this->user_type or !in_array($this->user_type, array('manager', 'customer'))) {
            $this->user_type = 'manager';
        }
        return true;
    }
}
