<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

class TableBadge extends JTable {
    var $id = null,
		$ordering = null,
        $name = null,
    	$icon = null,
        $color = null,
        $image = null,
        $type = null,
        $lang = null;

    var $_items_qty = null;

    function __construct(&$db) {
        parent::__construct('#__fwfoodmenu_badge', 'id', $db);
    }

	function load($oid = null, $reset = null) {
		if ($oid) {
            $db = JFactory::getDBO();
            $db->setQuery('
SELECT
    b.*,
    (SELECT COUNT(*) FROM `#__fwfoodmenu_menu_badge` AS mb WHERE mb.badge_id = b.id) AS _items_qty
FROM
    `#__fwfoodmenu_badge` AS b
WHERE
    b.id = '.(int)$oid
            );
            if ($obj = $db->loadObject()) {
                foreach ($obj as $key=>$val) {
                    $this->$key = $val;
                }
                if ($this->color) {
                    $this->color = '#'.$this->color;
                }
                JFactory::getApplication()->triggerEvent('onLoadBadge', array('com_fwfoodmenu', &$this));
	            return true;
            }
		}
    }
    function bind($data, $skip=array()) {
        if ($data) {
            $app = JFactory::getApplication();
            $app->triggerEvent('onBindBadge', array('com_fwfoodmenu', $data, &$skip, $this));

            $keys = array_keys($this->getProperties());
            foreach ($data as $key=>$val) {
                if (!in_array($key, $keys) or ($skip and in_array($key, $skip))) {
                    continue;
                }
                $this->$key = $val;
            }
        }
        return true;
    }
    function check() {
	/*	if (!$this->name) {
			$this->setError(JTExt::_('FWFM_ENTER_YOUR_NAME'));
			return;
		}*/
        if (!$this->id) {
            $db = JFactory::getDBO();
            $db->setQuery('SELECT MAX(ordering) FROM `#__fwfoodmenu_badge`');
            $this->ordering = $db->loadResult() + 1;
        }
        if ($this->color) {
            $this->color = trim($this->color, '#');
        }
        $app = JFactory::getApplication();
		$data = $app->triggerEvent('onCheckBadge', array('com_fwfoodmenu', &$this));
		if ($data) {
			foreach ($data as $row) {
				if (!$row) {
					return;
				}
			}
		}
        return true;
    }
	function store($updn = null) {
		if (parent::store($updn)) {
			JFactory::getApplication()->triggerEvent('onStoreBadge', array('com_fwfoodmenu', &$this));
			return true;
		}
	}
    function delete($id=null) {
        if (parent::delete($id)) {
            $db = JFactory::getDBO();
            $db->setQuery('DELETE FROM `#__fwfoodmenu_menu_badge` WHERE badge_id = '.(int)$id);
            $db->execute();
			JFactory::getApplication()->triggerEvent('onDeleteBadge', array('com_fwfoodmenu', &$this));
            return true;
        }
    }
}
