<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

class MenuModelSettings extends JModelLegacy {
	function uploadPDF() {
		$input = JFactory::getApplication()->input;
		if ($file = $input->files->get('pdf_file') and empty($file['error']) and !empty($file['name'])) {
			$file['name'] = JFile::makeSafe($file['name']);
			$path = JPATH_SITE.'/media/com_fwfoodmenu/';
			jimport('joomla.filesystem.file');
			if (JFile::copy($file['tmp_name'], $path.$file['name'])) {
				$params = JComponentHelper::getParams('com_fwfoodmenu');
				if ($pdf = $params->get('pdf_file') and $pdf != $file['name'] and file_exists($path.$pdf)) {
					JFile::delete($path.$pdf);
				}
				$params->set('pdf_file', $file['name']);
				if (fwFoodMenuHelper::storeConfig($params)) {
					return $file['name'];
				}
			}
		}
	}
	function deletePDF() {
		jimport('joomla.filesystem.file');
		$path = JPATH_SITE.'/media/com_fwfoodmenu/';
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		if ($pdf = $params->get('pdf_file') and file_exists($path.$pdf)) {
			JFile::delete($path.$pdf);
			$params->set('pdf_file', '');
			if (fwFoodMenuHelper::storeConfig($params)) {
				return true;
			}
		}
	}
	function loadObject() {
		return (object)array(
			'params' => JComponentHelper::getParams('com_fwfoodmenu')
		);
	}
    function save() {
    	$params = JComponentHelper::getParams('com_fwfoodmenu');
		$input = JFactory::getApplication()->input;
		$data = (array)$input->getRaw('config');

    	$fields = array(
			'display_descr_gallery',
		);
		foreach ($fields as $field) $data[$field] = $input->getVar($field);

	   	$params->loadArray($data);

		JFactory::getApplication()->triggerEvent('onAfterConfigDataBinding', array('com_fwfoodmenu', &$params, $data));

		if (fwFoodMenuHelper::storeConfig($params)) {
			fwFoodMenuHelper::addMessage(JText::_('FWFM_SETTINGS_SUCCESFULLY_STORED'), 'success');
			return true;
		} else {
			fwFoodMenuHelper::addMessage(JText::_('FWFM_SETTINGS_NOT_STORED'), 'warning');
		}
	}
	function getDescription() {
		$buff = file_get_contents(JPATH_COMPONENT_ADMINISTRATOR.'/fwfoodmenu.xml');
		if (preg_match('#<description><\!\[CDATA\[(.*?)\]\]></description>#msi', $buff, $match)) {
			return $match[1];
		}
	}
	function checkUpdate() {
		$data = new stdclass;
		$data->loc_version = fwFoodMenuHelper::getAppVersion();
		if ($buff = fwFoodMenuHelper::request('http://fastw3b.net/index.php?option=com_fwsales&view=updates&layout=package&format=raw&package=FW+Food+Menu&dummy=extension.xml')) {
			if (preg_match('#<extension.*version="([^"]*)"#', $buff, $match)) {
				$data->rem_version = $match[1];
			}
		} else $this->setError(JText::_('FWFM_NO_RESPONSE_FROM_REMOTE_SERVER'));

		return $data;
	}
	function verifyCode() {
		$data = new stdclass;
		$input = JFactory::getApplication()->input;
		if ($code = $input->getString('code')) {
			if ($buff = fwFoodMenuHelper::request('http://fastw3b.net/index.php?option=com_fwsales&view=updates&layout=verify_code&format=raw&package=FW+Food+Menu&code='.urlencode($code).'&host='.urlencode(JURI::root(false)))) {
				$tmp = json_decode($buff);
				if ($tmp) {
					if (!empty($tmp->msg)) $this->setError($tmp->msg);
					if (!empty($tmp->user_name)) $data->user_name = $tmp->user_name;
					if (!empty($tmp->membership)) $data->membership = JText::_('FWFM_'.$tmp->membership);
					if (!empty($tmp->status)) $data->status = JText::_('FWFM_'.$tmp->status);
					if (!empty($tmp->expires)) $data->expires = JHTML::date($tmp->expires);
					if (isset($tmp->expired)) $data->expired = $tmp->expired;
					if (!empty($tmp->suggestion_link)) $data->suggestion_link = $tmp->suggestion_link;
					if (!empty($tmp->bug_link)) $data->bug_link = $tmp->bug_link;
					if (!empty($tmp->is_version)) $data->is_version = $tmp->is_version;
					if (!empty($tmp->discount)) $data->discount = $tmp->discount;
					if (!empty($tmp->version)) {
						$data->rem_version = $tmp->version;
						$data->loc_version = fwFoodMenuHelper::getAppVersion();
					}
					if (!empty($tmp->purchased_version)) {
						$data->purchased_version = $tmp->purchased_version;
						$buff = explode('.', $tmp->purchased_version);
						if (count($buff) > 1) {
							$buff[1]++;
							$data->next_version = $buff[0].'.'.$buff[1].'.0';
						}
					}
					if (!empty($tmp->verified)) {
						$data->verified = 1;
						$params = JComponentHelper::getParams('com_fwfoodmenu');
						$params->set('update_code', $code);
						$params->set('verified_code', $code);
						fwFoodMenuHelper::storeConfig($params);
					}
				}
			} else $this->setError(JText::_('FWFM_NO_RESPONSE_FROM_REMOTE_SERVER'));
		} else $this->setError(JText::_('FWFM_NO_CODE_TO_VERIFY'));
		return $data;
	}
	function revokeCode() {
		$data = new stdclass;
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		$params->set('verified_code', '');
		$data->result = fwFoodMenuHelper::storeConfig($params);
		return $data;
	}
	function updatePackage() {
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		$code = $params->get('update_code');
		$result = false;
		if ($code) {
			if ($code == $params->get('verified_code')) {
				if ($buff = fwFoodMenuHelper::request('http://fastw3b.net/index.php?option=com_fwsales&view=updates&layout=package&format=raw&package=FW+Food+Menu&dummy=extension.xml')) {
					if (preg_match('#detailsurl="([^"]*)"#', $buff, $match)) {
						$url = str_replace('&amp;', '&', $match[1]);
						if ($buff = fwFoodMenuHelper::request($url)) {
							if (preg_match('#<downloadurl[^>]*>([^<]+)</downloadurl>#', $buff, $match)) {
								$url = str_replace('&amp;', '&', $match[1]).'&code='.urlencode($code);
								if ($buff = fwFoodMenuHelper::request($url, 'get', null, array(), 60)) {
									jimport('joomla.filesystem.file');
									jimport('joomla.filesystem.folder');
									$path = JPATH_SITE.'/tmp/';

									$filename = '';
									do {
										$filename = 'inst'.rand().'.zip';
									} while (file_exists($path.$filename));

									if (JFile::write($path.$filename, $buff)) {
										$package = JInstallerHelper::unpack($path.$filename, true);
										if (!empty($package['dir'])) {
											$installer = JInstaller::getInstance();
											if ($result = $installer->install($package['dir'])) {
												$this->setError(JText::_('FWFM_UPDATED_SUCCESFULLY'));
											} else {
												$this->setError(JText::_('FWFM_NOT_UPDATED'));
											}
										}
										if (file_exists($path.$filename)) JFile::delete($path.$filename);
										if (file_exists($package['dir'])) JFolder::delete($package['dir']);
									} else $this->setError(JText::_('FWFM_CANT_WRITE_FILE'));
								} else $this->setError(JText::_('FWFM_SERVER_REFUSES_DOWNLOAD'));
							} else $this->setError(JText::_('FWFM_WRONG_RESPONSE_FORMAT_FROM_REMOTE_SERVER'));
						} else $this->setError(JText::_('FWFM_NO_RESPONSE_FROM_REMOTE_SERVER'));
					} else $this->setError(JText::_('FWFM_WRONG_RESPONSE_FORMAT_FROM_REMOTE_SERVER'));
				} else $this->setError(JText::_('FWFM_NO_RESPONSE_FROM_REMOTE_SERVER'));
			} else $this->setError(JText::_('FWFM_CODE_NOT_VERIFIED'));
		} else $this->setError(JText::_('FWFM_NO_UPDATE_CODE'));
		return $result;
	}
}
