<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

class MenuModelMenu extends JModelLegacy {
	function localStat() {
		$db = JFactory::getDBO();
		$query = '
SELECT
	(SELECT COUNT(*) FROM `#__fwfoodmenu_category`) AS ct,
	(SELECT COUNT(*) FROM `#__fwfoodmenu_category` WHERE published = 1) AS cp,
	(SELECT COUNT(*) FROM `#__fwfoodmenu_menu`) AS mt,
	(SELECT COUNT(*) FROM `#__fwfoodmenu_menu` WHERE published = 1) AS mp,
	'.(class_exists('JVersion')?'(SELECT COUNT(*) FROM #__menu WHERE `client_id` = 0 AND `link` LIKE \'%com_fwfoodmenu%\')':'1').' AS menus_qty,
	(SELECT SUM(`image_size`) FROM `#__fwfoodmenu_menu` WHERE `image_size` IS NOT NULL) AS `is`';

		$db->setQuery($query);
		$data = $db->loadObject();

		$size = 0;
		foreach ($data as $key=>$val) {
			/* sum up all sizes */
			if ($key[strlen($key) - 1] == 's') {
				$size += $val;
				unset($data->$key);
			}
		}
		$data->fs = $size;

		return $data;
	}
	function quickCheck() {
		$data = new stdclass;
		jimport('joomla.filesystem.file');
		$path = JPATH_SITE.'/media/';
		if (!file_exists($path)) {
			JFile::write($path.'index.html', $html='<html><body></body></html>');
		}
		$data->media_folder_exists = file_exists($path);
		$path .= 'com_fwfoodmenu/';
		if (!file_exists($path)) {
			JFile::write($path.'index.html', $html='<html><body></body></html>');
		}
		$data->gallery_folder_exists = file_exists($path);
		$data->gallery_folder_writeable = is_writable($path);
		$data->gd_installed = function_exists('gd_info');
		$data->exif_installed = function_exists('exif_read_data');
		$data->version = fwFoodMenuHelper::getAppVersion();

		$data->test_passed = true;
		foreach ($data as $key=>$val) {
			if (!$val) {
				$data->test_passed = false;
				break;
			}
		}

		/* reorder plugins */
		$target_ordering = array(
			'image' => 1,
			'categorypdf' => 2,
			'prices' => 3,
			'columns' => 4,
			'cascading' => 5,
			'color' => 6,
			'cart' => 7,
			'mealbadges' => 8,
			'multilingual' => 9,
			'seobooster' => 10,
			'delivery' => 11,
			'time' => 12
		);
		$db = JFactory::getDBO();
		$db->setQuery('SELECT extension_id, element, ordering FROM `#__extensions` WHERE `folder` = \'fwfoodmenu\' ORDER BY ordering');
		if ($exts = $db->loadObjectList('element')) {
			foreach ($exts as $key=>$ext) {
				if (empty($target_ordering[$key])) {
					$exts[$key]->target_ordering = 100;
				} else {
					$exts[$key]->target_ordering = $target_ordering[$key];
				}
			}
			JArrayHelper::sortObjects($exts, 'target_ordering');
			$ordering = 1;
			foreach ($exts as $ext) {
				if ($ext->ordering != $ordering) {
					$db->setQuery('UPDATE `#__extensions` SET ordering = '.(int)$ext->target_ordering.' WHERE extension_id = '.$ext->extension_id);
					$db->execute();
				}
				$ordering++;
			}
		}

		return $data;
	}
	function loadParamsObj() {
		return (object)array(
			'params' => JComponentHelper::getParams('com_fwfoodmenu')
		);
	}
    function save() {
    	$params = JComponentHelper::getParams('com_fwfoodmenu');
		$input = JFactory::getApplication()->input;
		$data = (array)$input->getVar('config');

    	$fields = array(
			'display_descr_gallery',
		);
		foreach ($fields as $field) $data[$field] = $input->getVar($field);

	   	$params->loadArray($data);

		return $this->store($params);
	}
	function store($params) {
		$cache = JFactory::getCache('_system', 'callback');
    	$cache->clean();

    	$db = JFactory::getDBO();
		$db->setQuery('UPDATE `#__update_sites` SET extra_query = '.$db->quote('code='.urlencode(trim((string)$params->get('update_code'))).'&host='.urlencode(JURI::root(false))).' WHERE name LIKE \'FW Food%\'');
		$db->execute();
		$db->setQuery('TRUNCATE TABLE #__updates');
		$db->execute();
		$db->setQuery('UPDATE `#__update_sites` SET last_check_timestamp = 0');
		$db->execute();

    	$db->setQuery('UPDATE `#__extensions` SET params = '.$db->quote($params->toString()).' WHERE `element` = \'com_fwfoodmenu\' AND `type` = \'component\'');
    	return $db->execute();
	}
	function getDescription() {
		$buff = file_get_contents(FWFM_COMPONENT_ADMINISTRATOR.'/fwfoodmenu.xml');
		if (preg_match('#<description><\!\[CDATA\[(.*?)\]\]></description>#msi', $buff, $match)) {
			return $match[1];
		}
	}
	function checkUpdate() {
		$data = new stdclass;
		$data->loc_version = fwFoodMenuHelper::getAppVersion();
		$data->need_update = false;
		if ($buff = fwFoodMenuHelper::request(FWA_UPDATE_SERVER.'/index.php?option=com_fwsales&view=updates&layout=package&format=raw&package='.FWA_UPDATE_NAME.'&host='.urlencode(JURI::root(false)).'&dummy=extension.xml')) {
			if (preg_match('#<extension.*version="([^"]*)"#', $buff, $match)) {
				$data->rem_version = $match[1];

				if ($data->loc_version != 'x.x.x') {
					$rem_buff = explode('.', $data->rem_version);
					$loc_buff = explode('.', $data->loc_version);
					if (count($rem_buff) == 3 and count($loc_buff) == 3 and ($rem_buff[0] > $loc_buff[0] or ($rem_buff[0] == $loc_buff[0] and $rem_buff[1] > $loc_buff[1]) or ($rem_buff[0] == $loc_buff[0] and $rem_buff[1] == $loc_buff[1] and $rem_buff[2] > $loc_buff[2]))) {
						$data->need_update = true;
					}
				}
			}
		} else $this->setError(JText::_('FWFM_NO_RESPONSE_FROM_REMOTE_SERVER'));

		return $data;
	}
	function verifyCode() {
		$result = new stdclass;
		$input = JFactory::getApplication()->input;
		if ($code = $input->getString('access_code')) {
			$db = JFactory::getDBO();
			$j_version = $langs_qty = '';
			if (class_exists('JVersion')) {
				$jv = new JVersion();
				$j_version = $jv->getShortVersion();
			} else {
				global $wp_version;
			}

			$lang = JFactory::getLanguage();
			$langs = JLanguageHelper::getKnownLanguages();

			$db->setQuery('SELECT COUNT(*) FROM `#__fwfoodmenu_category` AS c WHERE EXISTS(SELECT * FROM `#__fwfoodmenu_menu` AS p WHERE p.published=1 AND p.category_id = c.id)');
			$categories_qty = $db->loadResult();
			$db->setQuery('SELECT COUNT(*) FROM `#__fwfoodmenu_menu` WHERE published=1');
			$menu_qty = $db->loadResult();

			$data = (object)array(
				'code' => $code,
				'package' => FWA_UPDATE_NAME,
				'host' => JURI::root(false),
				'params' => array(
					'joomla_version' => $j_version,
					'wp_version' => empty($wp_version)?'':$wp_version,
					'version' => fwFoodMenuHelper::getAppVersion(),
					'language' => $lang->getTag(),
					'langs_qty' => count($langs),
					'categories_qty' => $categories_qty,
					'menu_qty' => $menu_qty,
					'exts' => array()
				)
			);
			$db->setQuery('
SELECT
	`name`,
	`element`,
	`type`,
	`type` AS subtype,
	`folder`,
	`enabled`
FROM
	#__extensions
WHERE
	manifest_cache LIKE \'%Fastw3b%\'
	AND
	NOT `type` IN (\'package\', \'template\')
ORDER BY
	`type`,
	`folder`,
	`name`'
			);
			if ($list = $db->loadObjectList()) {
				foreach ($list as $i=>$row) {
					$filename = "";
					if ($row->type == "component") {
						$filename = JPATH_ADMINISTRATOR."/components/".$row->element."/".str_replace("com_", "", $row->element).".xml";
					} elseif ($row->type == "plugin") {
						$filename = JPATH_SITE."/plugins/".$row->folder."/".$row->element."/".$row->element.".xml";
					} elseif ($row->type == "module") {
						$filename = JPATH_SITE."/modules/".$row->element."/".$row->element.".xml";
					}
					if ($filename and file_exists($filename)) {
						$buff = file_get_contents($filename);
						if (preg_match("#<version>(.*?)</version>#msi", $buff, $match)) {
							$list[$i]->loc_version = $match[1];
						}
					}
				}
				$data->params["exts"] = $list;
			}

			if ($buff = fwFoodMenuHelper::request(FWA_UPDATE_SERVER.'/index.php?option=com_fwsales&view=updates&layout=verify_code&format=raw', 'post', $data)) {
				$tmp = json_decode($buff);
				if ($tmp) {
					if (!empty($tmp->msg)) $this->setError($tmp->msg);
					if (!empty($tmp->verified)) {
						$params = JComponentHelper::getParams('com_fwfoodmenu');

						$result->user_name = empty($tmp->user_name)?'':$tmp->user_name;
						$result->user_avatar = empty($tmp->user_avatar)?'':$tmp->user_avatar;
						$result->user_email = empty($tmp->user_email)?'':$tmp->user_email;
						$result->verified = 1;
						$result->has_packages = empty($tmp->packages)?0:$tmp->packages;
						$result->has_inactive_packages = empty($tmp->inactive_packages)?0:$tmp->inactive_packages;
						$result->has_active_packages = empty($tmp->active_packages)?0:$tmp->active_packages;

						$params->set('update_code', $code);
						$params->set('verified_code', $code);
						$params->set('user_name', $result->user_name);
						$params->set('user_avatar', $result->user_avatar);
						$params->set('user_email', $result->user_email);
						$params->set('has_packages', $result->has_packages);
						$params->set('has_inactive_packages', $result->has_inactive_packages);
						$params->set('has_active_packages', $result->has_active_packages);
						$this->store($params);
					}
				} elseif (preg_match('#<title>([^<]+)<#msi', $buff, $match)) {
					$this->setError($match[1]);
				}
			} else $this->setError(JText::_('FWFM_NO_RESPONSE_FROM_REMOTE_SERVER'));
		}  else $this->setError(JText::_('FWFM_NO_CODE_TO_VERIFY'));
		return $result;
	}
	function getChangelog() {
		if ($buff = fwFoodMenuHelper::request(FWA_UPDATE_SERVER.'/index.php?option=com_fwsales&view=updates&layout=changelog&format=raw&package='.FWA_UPDATE_NAME)) {
			$tmp = json_decode($buff);
			if (!empty($tmp->msg)) $this->setError($tmp->msg);
			if ($tmp->result) {
				return $tmp->result;
			}
		}
	}
	function revokeCode() {
		$data = new stdclass;
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		$params->set('verified_code', '');
		$params->set('update_code', '');
		$data->result = $this->store($params);
		return $data;
	}
	function updatePackage() {
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		$code = $params->get('update_code');
		$result = false;
		if ($code) {
			if ($code == $params->get('verified_code')) {
				if ($buff = fwFoodMenuHelper::request(FWA_UPDATE_SERVER.'/index.php?option=com_fwsales&view=updates&layout=package&format=raw&package='.FWA_UPDATE_NAME.'&host='.urlencode(JURI::root(false)).'&dummy=extension.xml')) {
					if (preg_match('#detailsurl="([^"]*)"#', $buff, $match)) {
						$url = str_replace('&amp;', '&', $match[1]);
						if ($buff = fwFoodMenuHelper::request($url)) {
							if (preg_match('#<downloadurl[^>]*>([^<]+)</downloadurl>#', $buff, $match)) {
								$url = str_replace('&amp;', '&', $match[1]).'&code='.urlencode($code).'&host='.urlencode(JURI::root(false));
								if ($buff = fwFoodMenuHelper::request($url, 'get', null, array(), 60)) {
									jimport('joomla.filesystem.file');
									jimport('joomla.filesystem.folder');
									$path = JPATH_SITE.'/tmp/';

									$filename = '';
									do {
										$filename = 'inst'.rand().'.zip';
									} while (file_exists($path.$filename));

									if (JFile::write($path.$filename, $buff)) {
										$package = JInstallerHelper::unpack($path.$filename, true);
										if (!empty($package['dir'])) {
											$installer = JInstaller::getInstance();
											if ($result = $installer->install($package['dir'])) {
												$this->setError(JText::_('FWFM_UPDATED_SUCCESFULLY'));
											} else {
												$this->setError(JText::_('FWFM_NOT_UPDATED'));
											}
										}
										if (file_exists($path.$filename)) JFile::delete($path.$filename);
										if (file_exists($package['dir'])) JFolder::delete($package['dir']);
									} else $this->setError(JText::_('FWFM_CANT_WRITE_FILE'));
								} else $this->setError(JText::_('FWFM_SERVER_REFUSES_DOWNLOAD'));
							} else $this->setError(JText::_('FWFM_WRONG_RESPONSE_FORMAT_FROM_REMOTE_SERVER'));
						} else $this->setError(JText::_('FWFM_NO_RESPONSE_FROM_REMOTE_SERVER'));
					} else $this->setError(JText::_('FWFM_WRONG_RESPONSE_FORMAT_FROM_REMOTE_SERVER'));
				} else $this->setError(JText::_('FWFM_NO_RESPONSE_FROM_REMOTE_SERVER'));
			} else $this->setError(JText::_('FWFM_CODE_NOT_VERIFIED'));
		} else $this->setError(JText::_('FWFM_NO_UPDATE_CODE'));
		return $result;
	}
	function getAddons() {
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		if ($code = $params->get('verified_code')) {
			JFactory::getApplication()->input->set('access_code', $code);
			$this->verifyCode();
		}
	}
	function loadWizards() {
		$data = array(
			'wizards'=>array(),
			'install'=>array(),
			'update'=>array()
		);
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		$update_code = $params->get('update_code');
		$input = JFactory::getApplication()->input;
		if (!$update_code) {
			$dismissed = $input->cookie->get('fwfm_dismissed_1');
			$data['wizards'][] = (object)array(
				'ordering'=>1+($dismissed?10:0),
				'active'=>$dismissed?0:1,
				'text'=>JText::_('FWFM_WIZARD_VERIFY'),
				'title'=>JText::_('FWFM_WIZARD_VERIFY_TITLE'),
				'icon'=>'lock',
				'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(1);">'.JText::_('FWFM_DISMISS').'</button>').'<button type="button" class="uk-button uk-button-action" onclick="jQuery(\'.fwa-user-no-login\').click()">'.JText::_('FWFM_VERIFY_ACCOUNT').'</button>'
			);
		}
		$quickcheck = $this->quickCheck($check_orphans=false);
		if (!$quickcheck->test_passed) {
			$dismissed = $input->cookie->get('fwfm_dismissed_2');
			$data['wizards'][] = (object)array(
				'ordering'=>2+($dismissed?10:0),
				'active'=>$dismissed?0:1,
				'text'=>JText::_('FWFM_WIZARD_QUICKCHECK'),
				'title'=>JText::_('FWFM_WIZARD_QUICKCHECK_TITLE'),
				'icon'=>'tasks',
				'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(2);">'.JText::_('FWFM_DISMISS').'</button>').'<a class="uk-button uk-button-action" href="index.php?option=com_fwfoodmenu&view=menu#quick-check">'.JText::_('FWFM_QUICK_CHECK').'</a>'
			);
		}
		$stat = $this->localStat();
		if (empty($stat->ct)) {
			$dismissed = $input->cookie->get('fwfm_dismissed_3');
			$data['wizards'][] = (object)array(
				'ordering'=>3+($dismissed?10:0),
				'active'=>$dismissed?0:1,
				'text'=>JText::_('FWFM_WIZARD_CATEGORIES'),
				'title'=>JText::_('FWFM_WIZARD_CATEGORIES_TITLE'),
				'icon'=>'folder',
				'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(3);">'.JText::_('FWFM_DISMISS').'</button>').'<button type="button" class="uk-button uk-button-action" onclick="UIkit.modal(\'#fwfm-quick-categories\').show();">'.JText::_('FWFM_QUICK_CATEGORIES').'</button>'
			);
		}
		if (empty($stat->mt)) {
			$dismissed = $input->cookie->get('fwfm_dismissed_4');
			$data['wizards'][] = (object)array(
				'ordering'=>4+($dismissed?10:0),
				'active'=>$dismissed?0:1,
				'text'=>JText::_('FWFM_WIZARD_FILES'),
				'title'=>JText::_('FWFM_WIZARD_FILES_TITLE'),
				'icon'=>'utensils',
				'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(4);">'.JText::_('FWFM_DISMISS').'</button>').'<button type="button" class="uk-button uk-button-action" onclick="UIkit.modal(\'#fwfm-quick-meals\').show();">'.JText::_('FWFM_QUICK_MEALS').'</button>'
			);
		}
		if (empty($stat->menus_qty)) {
			$dismissed = $input->cookie->get('fwfm_dismissed_5');
			$data['wizards'][] = (object)array(
				'ordering'=>5+($dismissed?10:0),
				'active'=>$dismissed?0:1,
				'text'=>JText::_('FWFM_WIZARD_MENU'),
				'title'=>JText::_('FWFM_WIZARD_MENU_TITLE'),
				'icon'=>'desktop',
				'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(5);">'.JText::_('FWFM_DISMISS').'</button>').'<a class="uk-button uk-button-action" href="index.php?option=com_menus&view=item&client_id=0&layout=edit">'.JText::_('FWFM_CREATE_MENU').'</a>'
			);
		}
		if ($update_code) {
			$addons = $this->getAddons(false);
			if ($addons) {
				foreach ($addons as $row) {
					if ($row->loc_version and $row->rem_version and $row->loc_version != 'x.x.x' and $row->loc_version != $row->rem_version) {
						$data['update'][] = (object)array('name'=>$row->name, 'update_name'=>$row->update_name);
					}
					if (empty($row->installed) and !empty($row->installable)) {
						$data['install'][] = (object)array('name'=>$row->name, 'update_name'=>$row->update_name);
					}
				}
			}
			$has_current_subscr = $params->get('has_active_packages');
			if (!$has_current_subscr) {
				$dismissed = $input->cookie->get('fwfm_dismissed_6');
				$data['wizards'][] = (object)array(
					'ordering'=>6+($dismissed?100:0),
					'active'=>$dismissed?0:1,
					'text'=>JText::_('FWFM_WIZARD_ADDONS'),
					'title'=>JText::_('FWFM_WIZARD_ADDONS_TITLE'),
					'icon'=>'puzzle-piece',
					'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(6);">'.JText::_('FWFM_DISMISS').'</button>').'<a class="uk-button uk-button-action" href="https://fastw3b.com/products/fw-food-menu#pricing" target="_blank">'.JText::_('FWFM_CHOOSE').'</a>'
				);
    		}
			$dismissed = $input->cookie->get('fwfm_dismissed_7');
			$data['wizards'][] = (object)array(
				'ordering'=>7+($dismissed?100:0),
				'active'=>$dismissed?0:1,
				'text'=>JText::_('FWFM_WIZARD_CUSTOM'),
				'title'=>JText::_('FWFM_WIZARD_CUSTOM_TITLE'),
				'icon'=>'code',
				'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(7);">'.JText::_('FWFM_DISMISS').'</button>').'<a class="uk-button uk-button-action" href="https://fastw3b.com/services/restaurant-website-online-menu-ordering" target="_blank">'.JText::_('FWFM_ORDER').'</a>'
			);
			if ($data['update']) {
				$dismissed = $input->cookie->get('fwfm_dismissed_8');
				$data['wizards'][] = (object)array(
					'ordering'=>8+($dismissed?100:0),
					'active'=>$dismissed?0:1,
					'text'=>JText::_('FWFM_WIZARD_UPDATE'),
					'title'=>JText::_('FWFM_WIZARD_UPDATE_TITLE'),
					'icon'=>'sync',
					'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(8);">'.JText::_('FWFM_DISMISS').'</button>').'<button type="button" class="uk-button uk-button-action" onclick="UIkit.modal(\'#fwfm-update\').show();">'.JText::_('FWFM_UPDATE').'</button>'
				);
			}
			if ($data['install']) {
				$dismissed = $input->cookie->get('fwfm_dismissed_9');
				$data['wizards'][] = (object)array(
					'ordering'=>9+($dismissed?100:0),
					'active'=>$dismissed?0:1,
					'text'=>JText::_('FWFM_WIZARD_INSTALL'),
					'title'=>JText::_('FWFM_WIZARD_INSTALL_TITLE'),
					'icon'=>'download',
					'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(9);">'.JText::_('FWFM_DISMISS').'</button>').'<button type="button" class="uk-button uk-button-action" onclick="UIkit.modal(\'#fwfm-install\').show();">'.JText::_('FWFM_INSTALL').'</button>'
				);
		    }
			if ($remote_langs = json_decode($params->get('langs_data'))) {
				$langs = array();
				$list = fwFoodMenuHelper::getInstalledLanguages();

				foreach ($list as $row) {
					if ($params->get('translation_requested_'.$row->tag) and !empty($remote_langs->{$row->tag})) {
						$params->set('translation_requested_'.$row->tag, 0);
						fwFoodMenuHelper::storeConfig($params);
						$langs[] = $row->name;
					}
				}
				if ($langs) {
					$dismissed = $input->cookie->get('fwfm_dismissed_10');
					$data['wizards'][] = (object)array(
						'ordering'=>10+($dismissed?100:0),
						'active'=>$dismissed?0:1,
						'text'=>JText::sprintf('FWFM_WIZARD_TRANSLATION', implode(', ', $langs)),
						'title'=>JText::_('FWFM_WIZARD_TRANSLATION_TITLE'),
						'icon'=>'download',
						'buttons'=>($dismissed?'':'<button type="button" class="uk-button uk-button-secondary" onclick="fwfm_dismiss_wizard(10);">'.JText::_('FWFM_DISMISS').'</button>').'<a href="index.php?option=com_fwfoodmenu&view=translation" class="uk-button uk-button-action">'.JText::_('FWFM_ADMIN_LANG_TOOLBAR_TITLE').'</button>'
					);
				}
			}
		}
		JArrayHelper::sortObjects($data['wizards'], 'ordering');
		return $data;
	}
	function demoDownload() {
		ini_set('memory_limit', '512M');
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		$code = $params->get('update_code');
		if ($code) {
			$data = fwFoodMenuHelper::request('https://fastw3b.com/images/fwsales/backups/fwfm.zip');
			if ($data) {
				$path = JPATH_SITE.'/media/com_fwfoodmenu/backups/fwfm_demo.zip';
				jimport('joomla.filesystem.file');
				if (JFile::write($path, $data)) {
					return true;
				} else fwFoodMenuHelper::addMessage(JText::strintf('FWFMCANT_WRITE_FILE', $path));
			} else fwFoodMenuHelper::addMessage(JText::_('FWFM_CANT_DOWNLOAD_DEMO_DATA'));
		} else fwFoodMenuHelper::addMessage(JText::_('FWFM_NO_UPDATE_CODE'));
	}
	function demoUnpack() {
		ini_set('memory_limit', '512M');
		$params = JComponentHelper::getParams('com_fwfoodmenu');
		$code = $params->get('update_code');
		if ($code) {
			JFactory::getApplication()->input->set('filename', 'fwfm_demo.zip');
			$model = JModelLegacy::getInstance('Data', 'menuModel');
			$result = $model->backupRestore();
			jimport('joomla.filesystem.file');
			JFile::delete(JPATH_SITE.'/media/com_fwfoodmenu/backups/fwfm_demo.zip');
			return $result;
		} else fwFoodMenuHelper::addMessage(JText::_('FWFM_NO_UPDATE_CODE'));
	}
}
