<?php
/**
 * FW Food Menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

$view = $displayData['view'];
?>
<div id="fwfm-quick-categories" uk-modal>
  <div class="uk-modal-dialog">
      <div class="uk-modal-header">
        <h5 class="uk-modal-title">
			<?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_QUICK'); ?>
			<div class="uk-modal-subtitle"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_QUICK_HINT'); ?></div>
		</h5>
        <button class="uk-modal-close-default" type="button" uk-close></button>
      </div>
      <div class="uk-modal-body">
	    <div class="mb-3" uk-tooltip="<?php echo esc_attr(JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_QUICK_CATEGORY_HINT')); ?>">
			<?php echo JHTML::_('fwfCategory.parent', (object)array('category'=>empty($view->category)?0:$view->category), 'category', 'class="form-control form-control-sm advancedSelect"', 'FWFM_DOC_ADMIN_CATEGORIES_MODAL_QUICK_CATEGORY'); ?>
		</div>
        <div><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_QUICK_TEXT'); ?></div>
		<textarea name="quick_categories" class="uk-textarea" placeholder="<?php echo esc_attr(JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_QUICK_TEXT_HINT')); ?>"></textarea>
	  </div>
      <div class="uk-modal-footer">
        <button type="button" class="uk-button uk-button-outline-secondary uk-modal-close"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_QUICK_BTN_CLOSE'); ?></button>
        <button type="button" class="uk-button uk-button-success"><?php echo JText::_('FWFM_DOC_ADMIN_CATEGORIES_MODAL_QUICK_BTN_PROCESS'); ?></button>
      </div>
  </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
	(function($) {
	$('#fwfm-quick-categories').on('show', function() {
		$(this).find('textarea').val('');
	});
	$('#fwfm-quick-categories button.uk-button-success').click(function() {
		var $popup = $('#fwfm-quick-categories');

		var $text = $popup.find('textarea');
		var buff = $text.val().split('\n');
		var qty = 0;
		for (var i = 0; i < buff.length; i++) {
			buff[i] = buff[i].trim();
			if (buff[i].length) {
				qty++;
			}
		}
		if (qty == 0) {
			alert('<?php echo JText::_('FWFM_NOTHING_TO_PROCESS', true); ?>');
			return;
		}

		var $btn = $(this).attr('disabled', true);
		var $wait = $('<div class="fwfm-quick-progress"><div uk-spinner></div> '+qty+' <?php echo JText::_('FWFM_CATEGORY_ROWS_PROCESSING', true); ?></div>');
		$btn.parent().prepend($wait);

		$.ajax({
			type: 'post',
			dataType: 'json',
			data: {
				format: 'json',
				task: '',
				view: 'category',
				layout: 'quick_categories',
				category: $popup.find('select[name="category"]').val(),
				text: $text.val()
			}
		}).done(function(data) {
			$btn.attr('disabled', false);
			$wait.remove();
			if (data.msg) {
				alert(data.msg);
			}
			if (data.result) {
				location=location.toString().replace('#.*$', '')+'<?php if (!empty($view->extra_link)) echo str_replace('&amp;', '&', $view->extra_link); ?>';
			}
		});
	});
	})(jQuery);
});
</script>
