<?php
/**
 * FW Food Menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

?>
            </div>
            <div id="fwaSidebarRight" class="fwa-sidebar-right collapsed">
                <div class="fwa-sidebar-right-header">
                    <i uk-icon="magic"></i>
                    <?php echo JText::_('FWFM_PRODUCT_WIZARD'); ?>
                </div>
                <div id="fwaSidebarRightBody" class="fwa-sidebar-right-body"></div>
            </div>
        </div>
    </div>

    <div id="fwa-toast-stack"></div>

    <div id="fwfm-login-register" uk-modal>
        <div class="uk-modal-dialog">
            <div class="uk-modal-header">
                <h5 class="uk-modal-title"><?php echo JText::_('FWFM_ACCESS_CODE_VERIFICATION'); ?></h5>
                <button class="uk-modal-close-default" type="button" uk-close></button>
            </div>
            <div class="uk-modal-body">
                <div>
                    <input type="text" name="access_code" class="uk-input" placeholder="<?php echo JText::_('FWFM_ACCESS_CODE'); ?>" />
                </div>
                <div class="uk-text-center uk-margin-top">
                    <button type="button" class="uk-button uk-button-primary"><?php echo JText::_('FWFM_VERIFY'); ?></button>
                </div>
                <div class="uk-alert uk-margin-top mb-0"><?php echo JText::_('FWFM_VERIFY_HINT') ?></div>
            </div>
        </div>
    </div>
    <div id="fwfm-logout" uk-modal>
        <div class="uk-modal-dialog">
            <div class="uk-modal-header">
                <h5 class="uk-modal-title"><?php echo JText::_('FWFM_PROFILE_TITLE'); ?></h5>
                <button class="uk-modal-close-default" type="button" uk-close></button>
            </div>
            <div class="uk-modal-body">
                <div class="uk-child-width-1-2@l" uk-grid>
                    <div><a href="https://fastw3b.com/client-section" class="uk-button uk-button-primary" target="_blank"><?php echo JText::_('FWFM_PROFILE'); ?></a></div>
                    <div><button type="button" class="uk-button uk-button-secondary"><?php echo JText::_('FWFM_LOGOUT'); ?></button></div>
                </div>
            </div>
        </div>
    </div>
    <div id="fwfm-install" uk-modal>
        <div class="uk-modal-dialog">
            <div class="uk-modal-header">
                <h5 class="uk-modal-title"><?php echo JText::_('FWFM_INSTALL'); ?></h5>
                <button class="uk-modal-close-default" type="button" uk-close></button>
            </div>
            <div class="uk-modal-body">
                <table class="table"><tbody></tbody></table>
            </div>
            <div class="uk-modal-footer">
                <button type="button" class="uk-button uk-modal-close"><?php echo JText::_('FWFM_CANCEL'); ?></button>
                <button type="button" class="uk-button uk-button-success"><?php echo JText::_('FWFM_INSTALL'); ?></button>
            </div>
        </div>
    </div>
    <div id="fwfm-update" uk-modal>
        <div class="uk-modal-dialog">
            <div class="uk-modal-header">
                <h5 class="uk-modal-title"><?php echo JText::_('FWFM_UPDATE'); ?></h5>
                <button class="uk-modal-close-default" type="button" uk-close></button>
            </div>
            <div class="uk-modal-body">
                <table class="table"><tbody></tbody></table>
            </div>
            <div class="uk-modal-footer">
                <button type="button" class="uk-button uk-modal-close"><?php echo JText::_('FWFM_CANCEL'); ?></button>
                <button type="button" class="uk-button uk-button-success"><?php echo JText::_('FWFM_UPDATE'); ?></button>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    (function($) {
        window.fwfm_wizard_alert = function (msg, title = '<?php echo JText::_('FWFM_NOTIFICATION', true); ?>', icon = '', action_button='') {
            var $el;

            if (icon) icon = '<i class="'+icon+'"></i>';
            actions = action_button?('<div class="fwa-sidebar-message-actions">'+action_button+'</div>'):'';
            
            $el = $('<div class="fwa-sidebar-message" style="opacity:0">'+icon+'<div class="fwa-sidebar-message-header">' + title + '</div><div class="fwa-sidebar-message-body">'+ msg +'</div>' + actions + '</div>');
            $('#fwaSidebarRightBody').append($el);
            $('#fwaSidebarRightBtn').addClass('active');

            $el.animate({
                'opacity': 1
            }, 500);
        };
        window.fwfm_alert = function (msg, title = '<?php echo JText::_('FWFM_NOTIFICATION', true); ?>', status = 'info') {
            var $el = $('<div class="toast toast-' +
                status + '" style="opacity:0">\
    <div class="toast-header">\
        <i uk-icon="bell"></i>\
        <strong>' + title + '</strong>\
    </div>\
    <div class="toast-body">' + msg + '</div>\
    </div>');
            $('#fwa-toast-stack').append($el);
            $el.animate({
                'opacity': 1
            }, 500);
            setTimeout(function () {
                $el.animate({
                    'opacity': 0
                }, 500, function () {
                    $el.remove();
                });
            }, 5000);
        }

        $('#fwfm-install .uk-modal-footer .uk-button-success').click(function() {
            var ext = [];
            var $loc_btn = $(this);
            var $popup = $loc_btn.closest('.uk-modal');
            $popup.find('input[name="ext[]"]:checked').each(function() {
                ext.push(this.value);
            });
            if (!ext.length) {
                fwfm_alert('<?php echo JText::_('FWFM_SELECT_ADDONS_TO_INSTALL', true); ?>');
                return;
            }
            var $wait = $('<div uk-spinner></div>');
            $loc_btn.attr('disabled', true).after($wait);

            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'addon',
                    layout: 'install',
                    ext: ext
                }
            }).done(function(data) {
                $wait.remove();
                $loc_btn.attr('disabled', false);
                if (data.result) {
                    UIkit.modal($popup[0]).hide()
                    for (var i = 0; i < data.result.length; i++) {
                        var row = data.result[i];
                        var $btn = $('tr[data-ext="'+row.update_name+'"] button');
                        $btn.removeClass('fwfm-addon-install uk-button-warning').addClass('fwfm-addon-disable uk-button-danger').html('<?php echo JText::_('FWFM_DISABLE', true); ?>');
                    }
                    location = location.toString().replace(/#.*$/, '');
                }
                if (data.msgs) {
                    for (var i = 0; i < data.msgs.length; i++) {
                        fwfm_alert(data.msgs[i]);
                    }
                }
            });
        });
        $('#fwfm-update .uk-modal-footer .uk-button-success').click(function() {
            var ext = [];
            var $btn = $(this);
            var $popup = $btn.closest('.uk-modal');
            $popup.find('input[name="ext[]"]:checked').each(function() {
                ext.push(this.value);
            });
            if (!ext.length) {
                fwfm_alert('<?php echo JText::_('FWFM_SELECT_ADDONS_TO_UPDATE', true); ?>');
                return;
            }
            var $wait = $('<div uk-spinner></div>');
            $btn.attr('disabled', true).after($wait);

            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'addon',
                    layout: 'update',
                    ext: ext
                }
            }).done(function(data) {
                $wait.remove();
                $btn.attr('disabled', false);
                if (data.result) {
                    UIkit.modal($popup[0]).hide()
                    for (var i = 0; i < data.result.length; i++) {
                        var row = data.result[i];
                        $('tr[data-ext="'+row.update_name+'"] button').remove();
                    }
                    location = location.toString().replace(/#.*$/, '');
                }
                if (data.msgs) {
                    for (var i = 0; i < data.msgs.length; i++) {
                        fwfm_alert(data.msgs[i]);
                    }
                }
            });
        });
        $('#fwfm-login-register').on('show', function() {
            var $popup = $(this);
            setTimeout(function() {
                $popup.find('input').focus();
            }, 300);
        });
        $('#fwfm-login-register .uk-modal-body button').click(function() {
            var $btn = $(this);
            var $wrp = $('#fwfm-login-register');
            var $access_code = $wrp.find('input[name="access_code"]');
            if ($access_code.val().trim() == '') {
                fwfm_alert('<?php echo JText::_('FWFM_NO_ACCESS_CODE', true); ?>');
                $access_code.focus();
                return;
            }
            var $wait = $('<div uk-spinner></div>');
            $btn.attr('disabled', true).after($wait);
            $.ajax({
                type: 'post',
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'menu',
                    task: '',
                    layout: 'verify_code',
                    access_code: $access_code.val()
                }
            }).done(function(data) {
                $btn.attr('disabled', false);
                $wait.remove();
                if (data.result) {
                    fwfm_reload_wizard();
                    if (data.result.user_avatar) {
                        $('.fwa-account-photo img').attr('src', data.result.user_avatar).css('display', '');
                    }
                    if (data.result.user_name) {
                        $('.fwa-account-photo a').attr('title', data.result.user_name);
                    }
                    if (data.result.verified) {
                        $('.fwa-user-no-login').hide(300, function () {
                            $('.fwa-user-logged-in').show(300);
                        });
                        UIkit.modal('#fwfm-login-register').hide();
                        $('.fwa-account-website > span')
                            .removeClass('uk-label-danger').addClass('uk-label-success')
                            .attr('uk-tooltip', '<?php echo esc_js(JText::_('FWFM_VERIFY_WEBSITE_VERIFIED_HINT')); ?>')
                            .find('span:eq(1)').html('<?php echo esc_js(JText::_('FWFM_VERIFY_WEBSITE_VERIFIED')); ?>');
                        if (data.result.has_active_packages) {
                            $('.fwa-account-subscription > span')
                                .removeClass('uk-label-danger').addClass('uk-label-success')
                                .attr('uk-tooltip', '<?php echo esc_js(JText::_('FWFM_ACCOUNT_SUBSCRIBED_HINT')); ?>')
                                .find('span:eq(1)').html('<?php echo esc_js(JText::_('FWFM_ACCOUNT_SUBSCRIBED')); ?>');
                        } else if (data.result.has_inactive_packages) {
                            $('.fwa-account-subscription > span')
                                .removeClass('uk-label-success').addClass('uk-label-danger')
                                .attr('uk-tooltip', '<?php echo esc_js(JText::_('FWFM_ACCOUNT_SUBSCRIPTION_INACTIVE_HINT')); ?>')
                                .find('span:eq(1)').html('<?php echo esc_js(JText::_('FWFM_ACCOUNT_SUBSCRIPTION_INACTIVE')); ?>');
                        } else if (data.result.has_packages) {
                            $('.fwa-account-subscription > span')
                                .removeClass('uk-label-success').addClass('uk-label-danger')
                                .attr('uk-tooltip', '<?php echo esc_js(JText::_('FWFM_ACCOUNT_SUBSCRIPTION_EXPIRED_HINT')); ?>')
                                .find('span:eq(1)').html('<?php echo esc_js(JText::_('FWFM_ACCOUNT_SUBSCRIPTION_EXPIRED')); ?>');
                        } else {
                            $('.fwa-account-subscription > span')
                                .removeClass('uk-label-success').addClass('uk-label-danger')
                                .attr('uk-tooltip', '<?php echo esc_js(JText::_('FWFM_ACCOUNT_NOT_SUBSCRIBED_HINT')); ?>')
                                .find('span:eq(1)').html('<?php echo esc_js(JText::_('FWFM_ACCOUNT_NOT_SUBSCRIBED')); ?>');
                        }
                    }
                }
                if (data.msg) UIkit.modal.alert(data.msg, {stack: true});
            });
        });
        $('#fwfm-logout .uk-modal-body button').click(function() {
            var $wait = $('<div uk-spinner></div>');
            var $btn = $(this).attr('disabled', true).after($wait);
            $.ajax({
                method: 'post',
                dataType: 'json',
                data: {
                    format: 'json',
                    view: 'menu',
                    task: '',
                    layout: 'revoke_code'
                }
            }).done(function (data) {
                $btn.attr('disabled', false);
                $wait.remove();
                if (data.result) {
                    fwfm_reload_wizard();
                    $('input[name="update_code"]').val('');
                    $('.fwa-account-photo img').css('display', 'none');
                    $('.fwa-user-logged-in').hide(300, function () {
                        $('.fwa-user-logged-in').attr('style', 'display:none!important');
                        UIkit.modal('#fwfm-logout').hide();
                        $('.fwa-user-no-login').show(300);
                        $('.fwa-account-website > span')
                            .removeClass('uk-label-success').addClass('uk-label-danger')
                            .attr('uk-tooltip', '<?php echo esc_js(JText::_('FWFM_VERIFY_WEBSITE_NOT_VERIFIED_HINT')); ?>')
                            .find('span:eq(1)').html('<?php echo esc_js(JText::_('FWFM_VERIFY_WEBSITE_NOT_VERIFIED')); ?>');
                    });
                }
                if (data.msg) fwfm_alert(data.msg);
            });
        });
        $('#toggleSidebarMenu').click(function () {
            setCookie('fwfm_hide_left_sidebar', $('#fwaSidebarWrapper').hasClass('collapsed')?0:1);
            $(this).removeClass('active');
            $('#fwaSidebarWrapper').toggleClass('collapsed');
            var $icon = $(this).find('span');
            if ($icon.attr('uk-icon') == 'icon: menu; ratio: 1.5') {
                $icon.attr('uk-icon', 'icon: chevron-left; ratio: 1.5');
            } else {
                $icon.attr('uk-icon', 'icon: menu; ratio: 1.5');
            }
        });
        $('#fwaSidebarRightBtn').click(function () {
            setCookie('fwfm_hide_right_sidebar', $('#fwaSidebarRight').hasClass('collapsed')?0:1);
            $('#fwaSidebarRight').toggleClass('collapsed');
        });
        if ((window.screen.width < 768) && !($('#fwaSidebarWrapper').hasClass('collapsed'))) {
            $('#toggleSidebarMenu').click();
        }
        $('#isisJsData').hide();
        fwfm_reload_wizard();
<?php
if ($messages = fwFoodMenuHelper::getMessages()) {
    foreach($messages as $message) {
?>
        fwfm_alert('<?php echo fwFoodMenuHelper::messageEscape($message->msg); ?>',
            '<?php echo esc_js(JText::_('FWFM_NOTIFICATION')); ?>',
            '<?php echo esc_js($message->status); ?>'
        );
<?php
    }
    fwFoodMenuHelper::clearMessages();
}
$view = JFactory::getApplication()->input->getCmd('view', 'menu');
?>
		$('a.nav-link[data-toggle="tab"]').click(function(ev) {
            ev.preventDefault();
            $(this).tab('show');
			var href = $(this).attr('href');
			setCookie('fwfm-menu-<?php echo esc_js($view); ?>', href);
		});

        var href = getCookie('fwfm-menu-<?php echo esc_js($view); ?>');
        if (href) {
            $('a[href="'+href+'"').click();
        }
    })(jQuery);
});
function fwfm_dismiss_wizard(num) {
    setCookie('fwfm_dismissed_'+num, 1);
    fwfm_reload_wizard();
}
function fwfm_reload_wizard() {
    jQuery('#fwaSidebarRightBtn').removeClass('active');
    jQuery('#fwaSidebarRightBody').html('');
    var $counter = jQuery('#fwaSidebarRightBtn span.uk-badge').html('').hide();
    jQuery.ajax({
        type: 'post',
        dataType: 'json',
        data: {
            format: 'json',
            view: 'menu',
            task: '',
            layout: 'load_wizards'
        }
    }).done(function(data) {
        if (data.result) {
            var $install = jQuery('#fwfm-install .uk-modal-body tbody').html('');
            if (data.result.install) {
                for (var i = 0; i < data.result.install.length; i++) {
                    var row = data.result.install[i];
                    var $row = jQuery('<tr>\
    <td><input type="checkbox" class="uk-checkbox" name="ext[]" value="'+row.update_name+'" checked="checked" /></td>\
    <td>'+row.name+'</td>\
</tr>');
                    $install.append($row);
                }
            }
            var $update = jQuery('#fwfm-update .uk-modal-body tbody').html('');
            if (data.result.update) {
                for (var i = 0; i < data.result.update.length; i++) {
                    var row = data.result.update[i];
                    var $row = jQuery('<tr>\
    <td><input type="checkbox" class="uk-checkbox" name="ext[]" value="'+row.update_name+'" checked="checked" /></td>\
    <td>'+row.name+'</td>\
</tr>');
                    $update.append($row);
                }
            }
            if (data.result.wizards) {
                var cnt = 0;
                for (var i = 0; i < data.result.wizards.length; i++) {
                    var row = data.result.wizards[i];
                    fwfm_wizard_alert(row.text, row.title, row.icon, row.buttons);
                    if (row.active) {
                        cnt++;
                    }
                }
                if (cnt) {
                    $counter.html(cnt).addClass('active').show();
                }
            }
        }
    });
}
function getCookie(name) {
    let matches = document.cookie.match(new RegExp(
        "(?:^|; )" + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + "=([^;]*)"
    ));
    return matches ? decodeURIComponent(matches[1]) : undefined;
}
function setCookie(name, value, options = {}) {

    if (options.expires instanceof Date) {
        options.expires = options.expires.toUTCString();
    }

    let updatedCookie = encodeURIComponent(name) + "=" + encodeURIComponent(value);

    for (let optionKey in options) {
        updatedCookie += "; " + optionKey;
        let optionValue = options[optionKey];
        if (optionValue !== true) {
            updatedCookie += "=" + optionValue;
        }
    }

    document.cookie = updatedCookie;
}
</script>
