<?php
/**
 * FW Food Menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined('_JEXEC') or die('Restricted access');

$menus = array(
    'menu',
	'addon',
	'category',
    'items',
    'orders',
    'badges',
	'data',
    'css',
    'translation',
    'settings'
);
$icons = array(
    'menu' => 'tachometer',
    'category' => 'folder',
    'items' => 'utensils',
    'orders' => 'cart',
    'addon' => 'puzzle-piece',
    'badges' => 'tag',
	'data' => 'database',
    'translation' => 'world',
    'css' => 'code',
    'settings' => 'settings'
);
$titles = array(
    'menu' => 'DASHBOARD',
    'addon' => 'ADDONS',
    'category' => 'CATEGORIES',
    'items' => 'MEALS',
    'orders' => 'ORDERS',
    'badges' => 'BADGES',
	'data' => 'DATA',
    'css' => 'CSS',
    'translation' => 'LANG',
    'settings' => 'SETTINGS',
);

$view = $displayData['view'];

$update_code = $view->params->get('update_code');
$verified_code = $view->params->get('verified_code');
$has_packages = $view->params->get('has_packages');
$has_active_packages = $view->params->get('has_active_packages');
$has_inactive_packages = $view->params->get('has_inactive_packages');

$account_verified = ($update_code and $update_code == $verified_code);
$user_name = $account_verified?$view->params->get('user_name'):'';
$user_avatar = $account_verified?$view->params->get('user_avatar'):'';
$user_email = $account_verified?$view->params->get('user_email'):'';
?>
<!-- Temp common menu layout start -->
<div id="fw-admin" class="container-fluid fwcss fw-admin">
    <div class="fwa-main-wrapper">
        <div id="fwaSidebarWrapper" class="fwa-sidebar-wrapper<?php if ($view->app->input->cookie->get('fwfm_hide_left_sidebar')) { ?> collapsed<?php } ?>">
            <div class="fwa-sidebar">
                <a id="toggleSidebarMenu" class="fwa-sidebar-toggle">
                    <img src="<?php echo FWFM_ADMIN_ASSETS_URI; ?>images/icon_fw_food_menu_200.png" />
                    <span><?php echo JText::_('COM_FWFOODMENU'); ?></span>
                </a>
                <ul class="fwa-sidebar-menu">
                    <li class="fwa-menu-item" uk-tooltip="<?php echo JText::_('FWFM_PRODUCT_WIZARD'); ?>">
                        <div id="fwaSidebarRightBtn" class="fwa-sidebar-right-btn">
                            <i uk-icon="icon:magic; ratio: 1.25" class="uk-margin-small-right">
                                <span class="uk-badge"></span>
                            </i>
                        </div>
                    </li>
<?php
foreach ($menus as $menu) {
	$name = JText::_('FWFM_DOC_ADMIN_'.(empty($titles[$menu])?$menu:$titles[$menu]));
    echo JHTML::_('fwView.menuItem', array(
        'active' => ($menu == $view->menu),
        'link' => 'index.php?option=com_fwfoodmenu&view='.$menu,
        'icon_class' => $icons[$menu],
        'name' => $name,
        'menu' => $menu
    ));
}
?>
                </ul>
                <div class="fwa-account">
                    <div class="uk-grid-small" uk-grid>
                        <div>
                            <button class="uk-button uk-button-default fwa-user-no-login" uk-tooltip="<?php echo esc_attr(JText::_('FWFM_VERIFY_WEBSITE_CONNECT_ACCOUNT')); ?>" uk-toggle="target: #fwfm-login-register"<?php if ($account_verified) { ?> style="display:none"<?php } ?>>
                                <span class="uk-text-danger" uk-icon="icon:question; ratio:3;"></span>
                            </button>
                        </div>
                        <div class="fwa-account-data">
                            <div class="fwa-account-website" uk-toggle="target: #fwfm-login-register">
                                <span class="uk-label uk-label-<?php if ($account_verified) { ?>success<?php } else { ?>danger<?php } ?>" uk-tooltip="<?php echo esc_attr(JText::_($account_verified?'FWFM_VERIFY_WEBSITE_VERIFIED_HINT':($update_code?'FWFM_VERIFY_WEBSITE_INVALID_HINT':'FWFM_VERIFY_WEBSITE_NOT_VERIFIED_HINT'))); ?>">
                                    <span uk-icon="icon:world; ratio: .75" class="uk-margin-small-right"></span> <span><?php echo esc_attr(JText::_($account_verified?'FWFM_VERIFY_WEBSITE_VERIFIED':($update_code?'FWFM_VERIFY_WEBSITE_INVALID':'FWFM_VERIFY_WEBSITE_NOT_VERIFIED'))); ?></span>
                                </span>
                            </div>
                            <div class="fwa-account-subscription fwa-user-logged-in"<?php if (!$account_verified) { ?> style="display:none"<?php } ?>>
                                <span class="uk-label uk-label-small uk-label-<?php if ($has_active_packages) { ?>success<?php } else { ?>danger<?php } ?>" uk-tooltip="<?php echo esc_attr(JText::_($has_active_packages?'FWFM_ACCOUNT_SUBSCRIBED_HINT':($has_inactive_packages?'FWFM_ACCOUNT_SUBSCRIPTION_INACTIVE_HINT':($has_packages?'FWFM_ACCOUNT_SUBSCRIPTION_EXPIRED_HINT':'FWFM_ACCOUNT_NOT_SUBSCRIBED_HINT')))); ?>">
                                    <span uk-icon="icon:puzzle-piece; ratio: .75" class="uk-margin-small-right"></span> <span><?php echo esc_attr(JText::_($has_active_packages?'FWFM_ACCOUNT_SUBSCRIBED':($has_inactive_packages?'FWFM_ACCOUNT_SUBSCRIPTION_INACTIVE':($has_packages?'FWFM_ACCOUNT_SUBSCRIPTION_EXPIRED':'FWFM_ACCOUNT_NOT_SUBSCRIBED')))); ?></span>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="uk-flex fwa-account-user fwa-user-logged-in"<?php if (!$account_verified) { ?> style="display:none!important;"<?php } ?>>
                        <div class="fwa-account-photo">
                            <a href="#fwfm-logout" uk-toggle="target: #fwfm-logout" title="<?php echo esc_attr($user_name); ?>">
                                <img src="<?php echo esc_attr($user_avatar); ?>"<?php if (!$user_avatar) { ?> style="display:none"<?php } ?>/> 
                                <span class="uk-position-center" uk-icon="user"></span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="fwa-main">
            <div class="uk-flex fwa-main-header">
                <div class="fwa-main-header-text">
                    <h2><span uk-icon="icon:<?php echo esc_attr($icons[$view->menu]); ?>; ratio: 1.25;" class="uk-margin-small-right"></span> <?php echo esc_html($displayData['title']); ?></h2>
                </div>
<?php
$buttons = fwfmButtons::getInstance()->getButtons();
if ($buttons) {
?>
                <div class="fwa-toolbar-wrapper">
                    <div class="fwa-toolbar">
<?php
	foreach ($buttons as $button) {
		$onclick = '';
		if ($button->listSelect) {
			if (is_string($button->listSelect)) {
				$onclick = "if (document.adminForm.boxchecked.value == 0) { fwfm_alert('".JText::_('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST', true)."'); } else { if (confirm('".JText::_($button->listSelect, true)."')) { Joomla.submitbutton('".$button->task."'); } }";
			} else {
				$onclick = "if (document.adminForm.boxchecked.value == 0) { fwfm_alert('".JText::_('JLIB_HTML_PLEASE_MAKE_A_SELECTION_FROM_THE_LIST', true)."'); } else { Joomla.submitbutton('".$button->task."'); }";
			}
		} else {
			$onclick = "Joomla.submitbutton('".esc_js($button->task)."');";
		}
?>
						<button type="button"<?php if ($button->task == 'add') { ?> id="fwfm-add-button"<?php } ?> class="uk-button<?php if (!empty($button->color)) { ?> uk-button-<?php echo esc_attr($button->color); } ?>" onclick="<?php echo esc_attr($onclick); ?>" role="button">
							<i uk-icon="<?php echo esc_attr($button->icon); ?>"></i>
							<span><?php echo esc_html($button->alt); ?></span>
						</button>
<?php
	}
?>
                    </div>
                </div>
<?php
}
?>
            </div>
            <div class="fwa-main-body">
