<?php
/**
 * FW Food menu 5.1.1
 * @copyright (C) 2020 Fastw3b
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @link http://www.fastw3b.net/ Official website
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );

class menuController extends JControllerLegacy {
    function __construct($config = array()) {
        parent::__construct($config);
        $this->fields = array('limit', 'limitstart', 'search', 'order', 'client', 'state', 'tab', 'category', 'type', 'extension');
        $this->registerTask('add','edit');
    }
    function edit() {
        $viewName = $this->input->getCmd('view', $this->getName());

        $view = $this->getView($viewName, 'html');
        $view->setModel($this->getModel($viewName), true);
        $view->setLayout('edit');
        parent::display();
    }
	function apply() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);
		$input = JFactory::getApplication()->input;

        if (method_exists($model, 'save')) {
            $id = $model->save();
            $msg = $model->getError();
        } else {
            $id = JArrayHelper :: getValue($input->getVar('cid'), 0);
            $msg = JText::_('FWFM_METHOD_APPLY_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name.'&task=edit&cid[]='.$id);
    }
    function dobatch() {
    	$view_name = $this->input->getString('view');
    	$model = $this->getModel($view_name);

    	if (method_exists($model, 'batch')) {
    		$model->batch();
    		$msg = $model->getError();
    	} else {
    		$msg = JText::_('FWFM_METHOD_BATCH_DOES_NOT_EXISTS');
    	}
    	foreach ($this->fields as $field) {
    		if ($data = $this->input->getString($field)) {
    			$view_name .= '&'.$field.'='.urlencode($data);
    		}
    	}
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
    	$this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function save() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'save')) {
            $model->save();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_SAVE_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
	function save2new() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'save')) {
            $model->save();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_SAVE_DOES_NOT_EXISTS');
        }
		$view_name .= '&task=edit';
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
	}
	function save2copy() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);
		$input = JFactory::getApplication()->input;

        if (method_exists($model, 'save2copy')) {
            $id = $model->save2copy();
            $msg = $model->getError();
        } else {
			$id = $input->get('id');
            $msg = JText::_('FWFM_METHOD_SAVE2COPY_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name.'&task=edit&cid[]='.$id);
	}
    function copy() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'copy')) {
            $model->copy();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_COPY_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function remove() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'remove')) {
            $model->remove();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_DELETE_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function saveorder() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'saveorder')) {
            $model->saveorder();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_SAVEORDER_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function orderup() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'orderup')) {
            $model->orderup();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_ORDERUP_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function orderdown() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'orderdown')) {
            $model->orderdown();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_ORDERDOWN_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function publish() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'publish')) {
            $model->publish();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_PUBLISH_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function unpublish() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'unpublish')) {
            $model->unpublish();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_UNPUBLISH_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function mealday() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'mealday')) {
            $model->mealday();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_mealday_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function unmealday() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'unmealday')) {
            $model->unmealday();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_UNmealday_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function asnew() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'asnew')) {
            $model->asnew();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_new_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function unnew() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'unnew')) {
            $model->unnew();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_UNnew_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function asrecommended() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'asrecommended')) {
            $model->asrecommended();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_RECOMMENDED_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function unrecommended() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'unrecommended')) {
            $model->unrecommended();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_UNRECOMMENDED_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
    function request() {
        $view_name = $this->input->getString('view');
        $model = $this->getModel($view_name);

        if (method_exists($model, 'request')) {
            $model->request();
            $msg = $model->getError();
        } else {
            $msg = JText::_('FWFM_METHOD_REQUEST_DOES_NOT_EXISTS');
        }
        foreach ($this->fields as $field) {
            if ($buff = $this->input->getString($field)) {
                $view_name .= '&'.$field.'='.urlencode($buff);
            }
        }
        if ($msg) {
            fwFoodMenuHelper::addMessage($msg);
        }
        $this->setRedirect('index.php?option=com_fwfoodmenu&view='.$view_name);
    }
}
