<!DOCTYPE html>
<html lang="mk">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
    <?php echo $__env->yieldContent('title'); ?>
    <?php echo $__env->yieldContent('description'); ?>
    <?php echo $__env->yieldContent('keywords'); ?>

    <meta name="author" content="John Doe">
    <!-- Bootstrap -->
    <link href="<?php echo url('css/bootstrap.min.css'); ?>" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.6.3/css/font-awesome.css" rel="stylesheet">
    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
    <!-- Scripts -->
    <script>
        window.Laravel = <?php echo json_encode([
            'csrfToken' => csrf_token(),
        ]); ?>;
    </script>
    <link href="<?php echo url('css/main.css'); ?>" rel="stylesheet">
    <link href="<?php echo url('css/animate.css'); ?>" rel="stylesheet">
    <?php echo $__env->yieldContent('styles'); ?>
</head>
<body>
<nav class="nav-down">
    <div class="container-fluid navigation-top">
        <div class="container">
            <div class="social-contacts">
                <a href="https://www.facebook.com/ohridskibiser/" target="_blank"><span class="fa fa-facebook"></span></a>
            </div>
            <div class="phone">
                <span class="fa fa-phone"></span>
                +389(71)261-216 | +389(70)261-216
            </div>
        </div>
    </div>
    <div class="container">
        <div class="logo">
            <img src="<?php echo url('images/logo.png'); ?>" alt="Ohridski Biser Talevi logo">
        </div>
        <div class="menu-toggle">
            <a href="javascript:void(0)" onclick="openNav()">
                <span class="fa fa-navicon"></span>
            </a>
        </div>
        <?php if(Auth::user()): ?>
            <div class="side-menu"><a href="javascript:void(0)" onclick="openAdminNav()"><span class="fa fa-pencil-square-o" ></span></a></div>
        <?php endif; ?>
        <div class="languages">
            <a href=""><img src="<?php echo url('images/mk.png'); ?>"></a>
            <a href=""><img src="<?php echo url('images/uk.png'); ?>"></a>
        </div>
        <ul class="navigation-menu" id="myNav">
            <li><a href="<?php echo route('getHome'); ?>" id="pocetna">Почетна</a></li>
            <li><a href="javascript:void(0)" id="za_nas">За нас</a></li>
            <li><a href="<?php echo route('getProducts'); ?>" id="biseri">Бисери</a></li>
            <li><a href="<?php echo route('getGalleries'); ?>" id="galerija">Галерија</a></li>
            <li><a href="<?php echo route('getContact'); ?>" id="kontakt">Контакт</a></li>
        </ul>
    </div>
</nav>

<?php if(Auth::user()): ?>
    <!-- Start Side Menu -->
    <div class="sidenav" id="myAdminSidenav">
        <a href="javascript:void(0)" class="closebtn" onclick="closeAdminNav()">&times;</a>

        <div class="widget">
            <?php if(Auth::user()->hasRole('admin')||Auth::user()->hasRole('editor')): ?>
                <?php if(Auth::user()->hasRole('admin')): ?>
                    <a href="<?php echo route('getUsers'); ?>"><span class="fa fa-users"></span> Корисници</a>
                    <hr>
                <?php endif; ?>
                <a href="<?php echo route('getGalleriesAdmin'); ?>"><span class="fa fa-image"></span> Албуми</a>
                <a href="<?php echo route('getGallery'); ?>"><span class="fa fa-camera"></span> Додади албуми</a>
                <a href="<?php echo route('getPageGalleries'); ?>"><span class="fa fa-arrows"></span> Промени редослед</a>
                    <hr>
                <a href="<?php echo route('getEventsAdmin'); ?>"><span class="fa fa-newspaper-o"></span> Производи</a>
                <a href="<?php echo route('getEventAdmin'); ?>"><span class="fa fa-pencil"></span> Внеси производ</a>
                <hr>
                <a href="<?php echo route('getVideosAdmin'); ?>"><span class="fa fa-youtube"></span> Youtube видеа</a>
                <a href="<?php echo route('getVideo'); ?>"><span class="fa fa-youtube-play"></span> Додади видео</a>
                <hr>
            <?php endif; ?>
            <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                <span class="fa fa-sign-out"></span> Одјави се
            </a>

            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                <?php echo e(csrf_field()); ?>

            </form>
        </div>
    </div>
    <!-- End Side Menu -->
<?php endif; ?>
<?php echo $__env->yieldContent('content'); ?>
<footer>
    <div class="container-fluid footer">
        <div class="container">
            <div class="col-sm-3">
                <h3><span class="fa fa-map-marker"></span> Адреса</h3>
                <p>
                    Ул. "Климент Охридски" бр.64/А,<br> 6000 Охрид, Македонија<br>
                </p>
            </div>
            <div class="col-sm-3">
                <h3><span class="fa fa-phone"></span> Телефон</h3>
                <p>
                    тел/факс: 00 389 46 260 540,<br>
                    моб: +389(71)261-216, +389(70)261-216
                </p>
            </div>
            <div class="col-sm-3">
                <h3><span class="fa fa-envelope-o"></span> E-mail адреса</h3>
                <p>
                    ohrbiser@mt.net.mk
                </p>
            </div>
            <div class="col-sm-3">
                <h3><span class="fa fa-thumbs-o-up"></span> Следете не</h3>
                <a href="https://www.facebook.com/ohridskibiser/" target="_blank"><span class="fa fa-facebook fa-2x"></span></a>&nbsp;&nbsp;&nbsp;
            </div>
        </div>
    </div>
    <div class="container copyright">
        <div class="col-md-12 pull-left text-center">
            &copy; 2017 Ohridski Biser. All rights reserved. &nbsp;
            Design by <a href="http://www.webmasterdesignlab.com" target="_blank">Webmaster</a>
        </div>
    </div>
</footer>
<script src="<?php echo url('js/jquery.min.js'); ?>"></script>
<script src="<?php echo url('js/bootstrap.min.js'); ?>"></script>
<?php echo $__env->yieldContent('scripts'); ?>
<script>
    /* Set the width of the side navigation to 250px */
    function openAdminNav() {
        document.getElementById("myAdminSidenav").style.right = "0";
    }
    /* Set the width of the side navigation to 0 */
    function closeAdminNav() {
        document.getElementById("myAdminSidenav").style.right = "-250px";
    }

    /* Set the width of the side navigation to 250px */
    function openNav() {
        document.getElementById("myNav").style.left = "0";
        $('.menu-toggle').html('<a href="javascript:void(0)" onclick="closeNav()"><span class="fa fa-remove"></span></a>');
    }
    /* Set the width of the side navigation to 0 */
    function closeNav() {
        document.getElementById("myNav").style.left = "-250px";
        $('.menu-toggle').html('<a href="javascript:void(0)" onclick="openNav()"><span class="fa fa-navicon"></span></a>');
    }

</script>

<script type="text/javascript">
    // Hide Header on on scroll down
    var didScroll;
    var lastScrollTop = 0;
    var delta = 5;
    var navbarHeight = $('nav').outerHeight();

    $(window).scroll(function(event){
        didScroll = true;
    });

    setInterval(function() {
        if (didScroll) {
            hasScrolled();
            didScroll = false;
        }
    }, 250);

    function hasScrolled() {
        var st = $(this).scrollTop();

        // Make sure they scroll more than delta
        if(Math.abs(lastScrollTop - st) <= delta)
            return;

        // If they scrolled down and are past the navbar, add class .nav-up.
        // This is necessary so you never see what is "behind" the navbar.
        if (st > lastScrollTop && st > navbarHeight){
            // Scroll Down
            $('nav').removeClass('nav-down').addClass('nav-up');
        } else {
            // Scroll Up
            if(st + $(window).height() < $(document).height()) {
                $('nav').removeClass('nav-up').addClass('nav-down');
            }
        }

        lastScrollTop = st;
    }
</script>
</body>
</html>