@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
    <link rel="stylesheet" href="{!! URL::asset('css/dropzone.min.css') !!}">
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading"><span class="fa fa-camera"></span> Прикачи слики</div>
                    <div class="panel-body">
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                        <div class="col-md-12">
                            <form class="dropzone dz-clickable" id="my-awesome-dropzone" method="POST" enctype="multipart/form-data" action="{!! route('createGallerySecond') !!}">
                                <div class="dz-message">
                                    <span class="fa fa-image fa-3x"></span>
                                    <h4>Drag Photos to Upload</h4>
                                    <span>Or click to browse</span>
                                </div>
                                <input name="_token" type="hidden" value="{{ csrf_token() }}">
                            </form>
                        </div>
                            <div class="col-md-12">
                                <br>
                                @if(session('upload_images'))
                                    @if(session('upload_images')=='create_new_gallery')
                                        <a href="{!! route('getGalleryBack') !!}" class="btn btn-primary">
                                            <i class="fa fa-angle-double-left" aria-hidden="true"></i>
                                            НАЗАД
                                        </a>
                                    @endif
                                    @if(session('upload_images')=='upload_new_images'||session('upload_images')=='create_new_gallery')
                                        <a href="{!! route('getGalleriesAdmin') !!}" class="btn btn-primary">
                                            ПРОДОЛЖИ
                                            <i class="fa fa-angle-double-right" aria-hidden="true"></i>
                                        </a>
                                    @endif
                                @endif
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script src="{!! URL::asset('js/dropzone.min.js') !!}"></script>
    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
@endsection