@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading"><span class="fa fa-calendar"></span> Производи
                        <a href="{!! route('getEventAdmin') !!}" class="btn btn-sm btn-success" style="float:right; margin-right: 3px;">
                            <span class="fa fa-plus"></span>
                        </a>
                    </div>
                    <div class="panel-body">
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                        <div class="event_items">
                            @foreach($events as $event)
                                <div class="col-md-3 col-sm-6 text-center event_item_wrap">
                                    <div class="gallery_item">
                                        @if(\DB::table('gallery_event')->where('event_id', $event->id)->count()==0)
                                            <a href="{!! route('getEditEvent', ['id'=>$event->id]) !!}">
                                                <img src="{!! URL::asset('images/image_placeholder.jpg')!!}" class="img-responsive img-thumbnail">
                                            </a>
                                            @else
                                            @foreach(App\Event::find($event->id)->galleries()->limit(1)->get() as $event_gallery)
                                                @foreach(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('id', 'desc')->limit(1)->get() as $gallery_image)
                                                    <img src="{!! URL::asset('images/galleries') !!}/{!! $event_gallery->id !!}/{!! $gallery_image->thumbnail !!}" class="img-responsive img-thumbnail">
                                                @endforeach
                                            @endforeach
                                        @endif
                                        <h4>{!! $event->event_title !!}</h4>
                                        <p>{!! $event->event_description !!}</p>
                                        <a href="{!! route('getEditEvent', ['id'=>$event->id]) !!}" class="btn btn-primary btn-sm">
                                            АЖУРИРАЈ
                                            <span class="fa fa-pencil"></span>
                                        </a>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        <div class="row text-center">
                            {{ $events->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        var divs = $(".event_item_wrap");
        var i=0;

        if ($(window).width() >= 992) {
            for(i = 0; i < divs.length; i+=4) {
                divs.slice(i, i+4).wrapAll("<div class='row'></div>");
            }
        }

        else
        {
            for (i = 0; i < divs.length; i += 2) {
                divs.slice(i, i + 2).wrapAll("<div class='row'></div>");
            }
        }

    </script>

    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
@endsection
