@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
    <link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
    <script src="{!! URL::asset('ckeditor/ckeditor.js') !!}"></script>
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading"><span class="fa fa-youtube"></span> Сите видеа
                        <a href="{!! route('getEditEvent',['id'=>$id]) !!}" class="btn btn-sm btn-primary" style="float:right; margin-right:2px;">
                            <span class="fa fa-arrow-left"></span>
                            Производ
                        </a>
                    </div>

                    <div class="panel-body">
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                        <div class="form-group">
                            @foreach($videos as $event_video)
                                <div class="col-md-3 text-center" id="gallery-item-{!! $event_video->id !!}">
                                    <div class="gallery_item {!! App\Event::find($id)->videos()->where('video_id', $event_video->id)->exists() ? 'alert-success' : 'alert-danger' !!}">
                                        <iframe width="100%" height="300" src="https://www.youtube.com/embed/{!! $event_video->video_code !!}" frameborder="0" allowfullscreen></iframe>
                                        <h4>{!! $event_video->video_name !!}</h4>
                                        <p>{!! $event_video->video_description !!}</p>
                                        <a href="{!! route('getEditVideo', ['id'=>$event_video->id]) !!}" class="btn btn-primary btn-sm">
                                            ЕДИТИРАЈ
                                            <span class="fa fa-pencil"></span>
                                        </a>
                                        @if(App\Event::find($id)->videos()->where('video_id', $event_video->id)->exists())
                                            <a href="{!! route('removeVideoEvent', ['video_id'=>$event_video->id, 'event_id'=>$id]) !!}" class="btn btn-danger btn-sm">
                                                ОТСТРАНИ
                                                <span class="fa fa-remove"></span>
                                            </a>
                                        @else
                                            <a href="{!! route('addEventToVideoAll', ['video_id'=>$event_video->id, 'event_id'=>$id]) !!}" class="btn btn-success btn-sm">
                                                ДОДАДИ
                                                <span class="fa fa-check"></span>
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            @endforeach
                            <div class="col-md-12 text-center">
                                {!! $videos->links() !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
@endsection
