@extends('layout')
@section('styles')
    <link rel="stylesheet" href="{!! URL::asset('css/admin.css') !!}">
    <script src="{!! URL::asset('js/jquery.min.js') !!}"></script>
@endsection
@section('content')
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading">
                        <span class="fa fa-youtube-play"></span> Видео "{!! $video->video_name !!}"
                        <a href="" class="btn btn-sm btn-danger" style="float:right" data-toggle="modal" data-target="#modal-delete-{!! $video->id !!}">
                            <span class="fa fa-trash-o"></span>
                        </a>
                        <div class="modal fade" id="modal-delete-{!! $video->id !!}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        <h4 class="modal-title">Избриши видео</h4>
                                    </div>
                                    <div class="modal-body grey-bg">
                                        <p>
                                            Дали сте сигурни дека сакате да го избришете видеото "{!! $video->video_name !!}"?<br>
                                            <small><i><b>Напомена: </b>видеото ќе биде избришано од сите страници !</i></small>
                                        </p>
                                    </div>
                                    <div class="modal-footer grey-bg">
                                        <a href="{!! URL::route('deleteVideo', ['id'=>$video->id])!!}" class="btn btn-danger">Избриши&nbsp; <span class="fa fa-trash-o"></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a href="{!! route('getVideosAdmin') !!}" class="btn btn-sm btn-primary" style="float:right; margin-right:2px;">
                            <span class="fa fa-arrow-left"></span>
                            Видеа
                        </a>
                    </div>

                    <div class="panel-body">
                        @if(session('status'))
                            <div class="alert {!! session('status-class') !!} alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                {!! session('status') !!}
                            </div>
                        @endif
                        <div class="row">
                            <div class="row">
                                <div class="col-md-6">
                                    <form class="form-horizontal" role="form" method="POST" action="{!! route('updateVideoInfo', ['id'=>$video->id]) !!}" novalidate>
                                        {{ csrf_field() }}
                                        <div class="form-group{{ $errors->has('title') ? ' has-error' : '' }} col-md-12">
                                            <hr>
                                            <label for="title" class="col-md-12">Наслов</label>
                                            <div class="col-md-12">
                                                <input id="title" type="text" class="form-control" name="title" value="{{ $video->video_name }}">
                                                @if ($errors->has('title'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('title') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }} col-md-12">
                                            <label for="description" class="col-md-12">Краток опис</label>
                                            <div class="col-md-12">
                                                <textarea id="description" class="form-control" name="description">{{ $video->video_description }}</textarea>
                                                @if ($errors->has('description'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('description') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="form-group{{ $errors->has('code') ? ' has-error' : '' }} col-md-12">
                                            <label for="code" class="col-md-12">Url</label>
                                            <div class="col-md-12">
                                                <textarea id="code" class="form-control" name="code">https://www.youtube.com/watch?v={!! $video->video_code !!}</textarea>
                                                @if ($errors->has('code'))
                                                    <span class="help-block">
                                                        <strong>{{ $errors->first('code') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-success">
                                                ЗАЧУВАЈ
                                                <i class="fa fa-save" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-6">
                                    <form action="{!! route('addVideoToEvent', ['video_id'=>$video->id]) !!}" method="post" novalidate>
                                        {!! csrf_field() !!}
                                        <div class="form-group col-md-12">
                                            <hr>
                                            <label for="page" class="col-md-12 col-xs-12">Додади видео на производ</label>
                                            <div class="col-md-8 col-xs-12">
                                                <select name="event" id="event" class="form-control">
                                                    <!--listaj na koi strani e dodadeno-->
                                                    @foreach(App\Event::orderBy('id', 'desc')->get() as $event)
                                                        <option value="{!! $event->id !!}" {!! App\Video::find($video->id)->events()->where('event_id', $event->id)->exists() ? 'disabled' : '' !!}>{!! $event->event_title !!}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <button class="btn btn-sm btn-success">
                                                    Додади &nbsp;
                                                    <span class="fa fa-save"> </span>
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-6">
                                    <iframe width="100%" height="350" style="padding:30px;" src="https://www.youtube.com/embed/{!! $video->video_code !!}" frameborder="0" allowfullscreen></iframe>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('scripts')
    <script>
        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
@endsection
