<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo URL::asset('css/admin.css'); ?>">
    <script src="<?php echo URL::asset('js/jquery.min.js'); ?>"></script>
    <style>
        #sortable-iframe{
            position: absolute;
            border: none;
            z-index: 10000000000;
            background: rgba(58, 58, 58, 0.89);
            left: 0;
            right:0;
            width:100%;
            height:100vh;
        }

    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container top-margin">
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-primary top-panel-margin">
                    <div class="panel-heading">
                        <span class="fa fa-camera"></span> Албум "<?php echo $gallery->gallery_name; ?>"
                        <a href="" class="btn btn-sm btn-danger" style="float:right" data-toggle="modal" data-target="#modal-delete-<?php echo $gallery->id; ?>">
                            <span class="fa fa-trash-o"></span>
                        </a>
                        <div class="modal fade" id="modal-delete-<?php echo $gallery->id; ?>">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        <h4 class="modal-title">Избриши албум</h4>
                                    </div>
                                    <div class="modal-body grey-bg">
                                        <p>
                                            Дали сте сигурни дека сакате да го избришете албумот "<?php echo $gallery->gallery_name; ?>"?<br>
                                            <small><i><b>Напомена: </b>Албумот ќе биде избришан од сите страници со сите свои слики !</i></small>
                                        </p>
                                    </div>
                                    <div class="modal-footer grey-bg">
                                        <a href="<?php echo URL::route('deleteGallery', ['id'=>$gallery->id]); ?>" class="btn btn-danger">Избриши&nbsp; <span class="fa fa-trash-o"></span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <a href="<?php echo route('uploadNewImages',['gallery_id'=>$gallery->id]); ?>" class="btn btn-sm btn-success" style="float:right; margin-right: 3px;">
                            <span class="fa fa-plus"></span>
                        </a>
                        <a href="<?php echo route('getGalleriesAdmin'); ?>" class="btn btn-sm btn-primary" style="float:right; margin-right:2px;">
                            <span class="fa fa-arrow-left"></span>
                            Галерии
                        </a>
                    </div>

                    <div class="panel-body">
                        <?php if(session('status')): ?>
                            <div class="alert <?php echo session('status-class'); ?> alert-dismissable fade in">
                                <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                                <?php echo session('status'); ?>

                            </div>
                        <?php endif; ?>
                        <div class="row">
                            <div class="row">
                                <div class="col-md-6">
                                    <form class="form-horizontal" role="form" method="POST" action="<?php echo route('updateGalleryInfo', ['id'=>$gallery->id]); ?>" novalidate>
                                        <?php echo e(csrf_field()); ?>

                                        <div class="form-group<?php echo e($errors->has('title') ? ' has-error' : ''); ?> col-md-12">
                                            <hr>
                                            <label for="title" class="col-md-12">Наслов</label>
                                            <div class="col-md-12">
                                                <input id="title" type="text" class="form-control" name="title" value="<?php echo e($gallery->gallery_name); ?>">
                                                <?php if($errors->has('title')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('title')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="form-group<?php echo e($errors->has('description') ? ' has-error' : ''); ?> col-md-12">
                                            <label for="description" class="col-md-12">Краток опис</label>
                                            <div class="col-md-12">
                                                <textarea id="description" class="form-control" name="description"><?php echo e($gallery->gallery_description); ?></textarea>
                                                <?php if($errors->has('description')): ?>
                                                    <span class="help-block">
                                                        <strong><?php echo e($errors->first('description')); ?></strong>
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <button type="submit" class="btn btn-success">
                                                ЗАЧУВАЈ
                                                <i class="fa fa-save" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div class="col-md-6">
                                    <form action="<?php echo route('addGalleryToPage', ['gallery_id'=>$gallery->id]); ?>" method="post" novalidate>
                                        <?php echo csrf_field(); ?>

                                        <div class="form-group col-md-12">
                                            <hr>
                                            <label for="page" class="col-md-12 col-xs-12">Додади албум на страна</label>
                                            <div class="col-md-8 col-xs-12">
                                                <select name="page" id="page" class="form-control">
                                                    <!--listaj na koi strani e dodadena-->
                                                    <?php $__currentLoopData = App\Page::orderBy('id', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo $page->id; ?>" <?php echo App\Gallery::find($gallery->id)->pages()->where('page_id', $page->id)->exists() ? 'disabled' : ''; ?>><?php echo $page->page_name; ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <button class="btn btn-sm btn-success">
                                                    Додади &nbsp;
                                                    <span class="fa fa-save"> </span>
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                    <form action="<?php echo route('addGalleryToEvent', ['gallery_id'=>$gallery->id]); ?>" method="post" novalidate>
                                        <?php echo csrf_field(); ?>

                                        <div class="form-group col-md-12">
                                            <hr>
                                            <label for="page" class="col-md-12 col-xs-12">Додади албум на производ</label>
                                            <div class="col-md-8 col-xs-12">
                                                <select name="event" id="event" class="form-control">
                                                    <!--listaj na koi strani e dodadena-->
                                                    <?php $__currentLoopData = App\Event::orderBy('id', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo $event->id; ?>" <?php echo App\Gallery::find($gallery->id)->events()->where('event_id', $event->id)->exists() ? 'disabled' : ''; ?>><?php echo $event->event_title; ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                            <div class="col-md-2 col-xs-12">
                                                <button class="btn btn-sm btn-success">
                                                    Додади &nbsp;
                                                    <span class="fa fa-save"> </span>
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div id="images">
                                <div class="col-md-12">
                                    <hr>
                                    <div class="col-md-12">
                                        <a href="<?php echo route('getSortable', ['id'=>$gallery->id]); ?>" class="btn btn-primary reorder_link">ПРОМЕНИ РЕДОСЛЕД <span class="fa fa-arrows"></span></a>
                                    </div>
                                </div>
                                <div class="col-md-12 gallery-image-container">
                                    <?php $__currentLoopData = \DB::table('gallery_images')->where('gallery_id', $gallery->id)->orderBy('image_order', 'asc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery_image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-3 col-sm-4 text-center gallery_item_m " id="image-item-<?php echo $gallery_image->id; ?>">
                                                <div class="gallery_item" style="padding:3px;">
                                                    <img src="<?php echo URL::asset('images/galleries'); ?>/<?php echo $gallery->id; ?>/<?php echo $gallery_image->thumbnail; ?>?nocache=<?php echo str_random(5); ?>" class="img-responsive img-thumbnail">
                                                   <form action="<?php echo route('updateImageDescriptionAlt', ['id'=>$gallery_image->id]); ?>" method="post" novalidate id="update-img-info-<?php echo $gallery_image->id; ?>">
                                                        <?php echo csrf_field(); ?>

                                                        Наслов на слика:<br>
                                                        <input id="image_alt_<?php echo $gallery_image->id; ?>" type="text" class="form-control" name="image_alt" value="<?php echo e($gallery_image->image_alt); ?>">
                                                        <hr>
                                                        Опис на слика:<br>
                                                        <input id="image_desc_<?php echo $gallery_image->id; ?>" type="text" class="form-control" name="image_desc" value="<?php echo e($gallery_image->image_description); ?>">
                                                        <hr>
                                                        <button type="submit" class="btn btn-success btn-sm">
                                                            ЗАЧУВАЈ
                                                            <span class="fa fa-save"></span>
                                                        </button>
                                                        <a href="<?php echo route('getCropImage', ['id'=>$gallery_image->id]); ?>" class="btn btn-sm btn-default">
                                                            <span class="fa fa-crop"></span>
                                                        </a>
                                                        <a href="#" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-image-delete-<?php echo $gallery_image->id; ?>">
                                                            <span class="fa fa-trash-o"></span>
                                                        </a>
                                                        <br>
                                                        <span style="display: none; padding: 2px;" id="img-info-<?php echo $gallery_image->id; ?>" class="alert"> </span>
                                                        <br>
                                                    </form>
                                                </div>
                                        </div>
                                        <div class="modal fade" id="modal-image-delete-<?php echo $gallery_image->id; ?>">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        <h4 class="modal-title">Избриши слика</h4>
                                                    </div>
                                                    <div class="modal-body grey-bg">
                                                        <p>
                                                            Дали сте сигурни дека сакате да ја избришете сликата ?<br>
                                                            <small><i><b>Напомена: </b>Оваа акција не може да се поврати !</i></small>
                                                        </p>
                                                        <div style="display: none;" id="image-delete-message-<?php echo $gallery_image->id; ?>" class="alert"></div>
                                                    </div>
                                                    <div class="modal-footer grey-bg">
                                                        <a href="#" class="btn btn-danger" id="delete-image-<?php echo $gallery_image->id; ?>">Избриши&nbsp; <span class="fa fa-trash-o"></span>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <script>
                                            $(document).ready(function() {
                                                //Delete image
                                                $("#delete-image-<?php echo $gallery_image->id; ?>").click(function(a) {
                                                    a.preventDefault();
                                                    var url = '<?php echo URL::route('getHome'); ?>/dashboard/gallery/image/<?php echo $gallery_image->id; ?>/delete';
                                                    $.ajax({
                                                        url: url,
                                                        type: "get",
                                                        dataType: "json",
                                                        cache: !1,
                                                        success: function(data) {
                                                            $("#image-delete-message-<?php echo $gallery_image->id; ?>").addClass(data.message_class).text(data.message).fadeIn(function(){
                                                                $("#image-delete-message-<?php echo $gallery_image->id; ?>").fadeOut();
                                                                $("#modal-image-delete-<?php echo $gallery_image->id; ?>").modal('toggle');
                                                                $('#image-item-<?php echo $gallery_image->id; ?>').fadeOut();
                                                                //window.location.href="<?php echo route('getEditGallery', ['id'=>$gallery->id]); ?>";

                                                            });

                                                        },
                                                        error: function() {
                                                            alert("Bad request ! Please try again.")
                                                        }
                                                    });
                                                });

                                                //Update image Alternate text and description
                                                $(document).ready(function() {
                                                    $("#update-img-info-<?php echo $gallery_image->id; ?>").submit(function(a) {
                                                        var b = $("#update-img-info-<?php echo $gallery_image->id; ?>").attr("action"),
                                                                c = $("#update-img-info-<?php echo $gallery_image->id; ?>").serializeArray();
                                                        $("#contact_loader").fadeIn(), $.ajax({
                                                            url: b,
                                                            type: "post",
                                                            data: c,
                                                            dataType: "json",
                                                            cache: !1,
                                                            success: function(data) {
                                                                if(data.success_message==true)
                                                                {
                                                                    $('#img-info-<?php echo $gallery_image->id; ?>').html(data.message).addClass(data.message_class).fadeIn();
                                                                    $("#image_desc_<?php echo $gallery_image->id; ?>").val(data.desc);
                                                                    $("#image_alt_<?php echo $gallery_image->id; ?>").val(data.alt);
                                                                    //window.location.href="<?php echo route('getEditGallery', ['id'=>$gallery->id]); ?>";
                                                                }
                                                                else
                                                                {
                                                                    $('#img-info-<?php echo $gallery_image->id; ?>').html(data.message).addClass(data.message_class).fadeIn();
                                                                }
                                                            },
                                                            error: function() {
                                                                alert('Bad request. Please try again !')
                                                            }
                                                        }), a.preventDefault()
                                                    })
                                                });
                                            });
                                        </script>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $('#za_nas').click(function(){
            window.location.href ='<?php echo route('getHome'); ?>#about-us';
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>