@extends('layout')

@section('title')
    <title>Our pearls - Talevi Ohrid pearl shop, Ohrid natural pearls</title>
@endsection
@section('description')
    <meta name="description" content="Ohrid family Talevi is a synonym of unique, natural pearls with tradition more than 90 years.">
@endsection
@section('keywords')
@endsection

@section('styles')
@endsection

@section('content')
    <section class="container-fluid products text-center top-margin">
        @foreach($event_categories as $event_category)
            @if(App\EventCategory::find($event_category->id)->events()->count()>0)
                @foreach(App\EventCategory::find($event_category->id)->events()->limit(1)->get() as $event)
                    <div class="col-md-3 gallery_item_wrap">
                        <div class="category_item">
                            <div class="product-image gallery-item">
                                @if(App\Event::find($event->id)->galleries()->count()>0)
                                    @foreach(App\Event::find($event->id)->galleries()->limit(1)->get() as $event_gallery)
                                        @foreach(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('image_order', 'asc')->limit(1)->get() as $gallery_image)
                                            <a href="{!! route('getProductCategory', ['id'=>$event_category->id, 'slug'=>$event_category->category_slug]) !!}">
                                                <img src="{!! URL::asset('images/galleries') !!}/{!! $event_gallery->id !!}/{!! $gallery_image->thumbnail !!}" class="img-responsive content-image">
                                                <div class="middle">
                                                    <div class="text">
                                                        <span class="fa fa-search fa-2x"></span><br>
                                                        Open
                                                    </div>
                                                </div>
                                            </a>
                                        @endforeach
                                    @endforeach
                                @else
                                    <img src="{!! url('images/product_placeholder.png') !!}" class="img-responsive">
                                @endif
                            </div>
                            <div class="product-review">
                                <h3 class="product-title">
                                    <a href="{!! route('getProductCategory', ['id'=>$event_category->id, 'slug'=>$event_category->category_slug]) !!}">{!! $event_category->category_name !!}</a>
                                </h3>
                                <br>
                                <a href="{!! route('getProductCategory', ['id'=>$event_category->id, 'slug'=>$event_category->category_slug]) !!}" class="show-more-btn">
                                    More
                                    <span class="fa fa-eye"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                @endforeach
            @endif
        @endforeach
    </section>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $("#biseri").addClass('active');
        });
    </script>

    <script>
        var divs = $(".gallery_item_wrap");
        var i=0;

        if ($(window).width() >= 992) {
            for(i = 0; i < divs.length; i+=4) {
                divs.slice(i, i+4).wrapAll("<div class='row'></div>");
            }
        }

        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });

    </script>
@endsection