@extends('layout')

@section('title')
    <title>{!! $event_category->category_name !!}</title>
@endsection
@section('description')
    <meta name="description" content="{!! $event_category->category_name !!}">
@endsection
@section('keywords')
@endsection

@section('styles')
@endsection

@section('content')
    <section class="container-fluid products top-margin text-center">
        <div class="row">
            <div class="col-xs-10 text-left gallery-title">
                <h1>{!! $event_category->category_name !!}</h1>
            </div>
            <div class="col-xs-2 text-right">
                <a href="{!! route('getProducts') !!}" class="btn btn-default gallery_back">
                    <span class="fa fa-arrow-left"></span>
                </a>
            </div>
        </div>
        @if(App\EventCategory::find($event_category->id)->events()->count()>0)
            @foreach($events as $event)
                <div class="col-md-3 gallery_item_wrap">
                    <div class="category_item">
                        <div class="product-image gallery-item">
                            @if(App\Event::find($event->id)->galleries()->count()>0)
                                @foreach(App\Event::find($event->id)->galleries()->limit(1)->get() as $event_gallery)
                                    @foreach(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('image_order', 'asc')->limit(1)->get() as $gallery_image)
                                        <a href="{!! route('getProduct', ['id'=>$event->id]) !!}">
                                            <img src="{!! URL::asset('images/galleries') !!}/{!! $event_gallery->id !!}/{!! $gallery_image->thumbnail !!}" class="img-responsive content-image">
                                            <div class="middle">
                                                <div class="text">
                                                    <span class="fa fa-search fa-2x"></span><br>
                                                    Open
                                                    @if(Auth::user())
                                                        @if(Auth::user()->hasRole('admin')||Auth::user()->hasRole('editor'))
                                                            <br>
                                                            <a href="{!! route('getEditEvent', ['id'=>$event->id]) !!}" class="btn btn-default btn-xs"><span class="fa fa-pencil"></span></a>
                                                        @endif
                                                    @endif
                                                </div>
                                            </div>
                                        </a>
                                    @endforeach
                                @endforeach
                            @else
                                <img src="{!! url('images/product_placeholder.png') !!}" class="img-responsive">
                            @endif
                        </div>
                        <div class="product-review">
                            <h3 class="product-title">
                                <a href="{!! route('getProduct', ['id'=>$event->id]) !!}">{!! $event->event_title !!}</a>
                            </h3>
                            <p>{!! $event-> event_description!!}</p>
                            <br>
                            <a href="{!! route('getProduct', ['id'=>$event->id]) !!}" class="show-more-btn">
                                More
                                <span class="fa fa-eye"></span>
                            </a>
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </section>
@endsection

@section('scripts')
    <script>
        $(document).ready(function() {
            $("#biseri").addClass('active');
        });
    </script>

    <script>
        var divs = $(".gallery_item_wrap");
        var i=0;

        if ($(window).width() >= 992) {
            for(i = 0; i < divs.length; i+=4) {
                divs.slice(i, i+4).wrapAll("<div class='row'></div>");
            }
        }

        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
@endsection