@extends('layout')

@section('title')
    <title>{!! $event->event_title !!}</title>
@endsection
@section('description')
    <meta name="description" content="{!! $event->event_description !!}">
@endsection
@section('keywords')
@endsection

@section('styles')
    <link rel="stylesheet" type="text/css" href="{!! url('fancybox/dist/jquery.fancybox.min.css') !!}">
    <style>
        h4{
            color:#FFAAA5;
        }
    </style>
@endsection

@section('content')
    <section class="container products top-margin text-center">

        @if(App\Event::find($event->id)->count()>0)
                <div class="col-sm-6">
                    <div class="product_item">
                        <div class="product-image gallery-item">
                            @if(App\Event::find($event->id)->galleries()->count()>0)
                                @foreach(App\Event::find($event->id)->galleries()->limit(1)->get() as $event_gallery)
                                    @foreach(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('image_order', 'asc')->limit(1)->get() as $gallery_image)
                                        <img src="{!! URL::asset('images/galleries') !!}/{!! $event_gallery->id !!}/{!! $gallery_image->image !!}" class="img-thumbnail img-responsive">
                                    @endforeach
                                @endforeach
                                    @if(App\Event::find($event->id)->galleries()->count()>0)
                                        @foreach(App\Event::find($event->id)->galleries()->get() as $event_gallery)
                                            @if(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->count()>1)
                                                @foreach(\DB::table('gallery_images')->where('gallery_id', $event_gallery->id)->orderBy('image_order', 'asc')->get() as $gallery_image)
                                                    <div class="col-xs-3">
                                                        <a href="{!! URL::asset('images/galleries') !!}/{!! $event_gallery->id !!}/{!! $gallery_image->image !!}" class="grouped_elements" data-fancybox="group">
                                                            <img src="{!! URL::asset('images/galleries') !!}/{!! $event_gallery->id !!}/{!! $gallery_image->thumbnail !!}" class="img-thumbnail img-responsive">
                                                        </a>
                                                    </div>
                                                @endforeach
                                            @endif
                                        @endforeach
                                    @endif
                            @else
                                <img src="{!! url('images/product_placeholder.png') !!}" class="img-responsive">
                            @endif
                        </div>
                    </div>
                </div>
            <div class="col-sm-6 text-left">
                <div class="row">
                    <div class="col-xs-10 text-left gallery-title">
                        <h1>{!! $event->event_title !!}</h1>
                        @if(Auth::user())
                            @if(Auth::user()->hasRole('admin')||Auth::user()->hasRole('editor'))
                                <a href="{!! route('getEditEvent', ['id'=>$event->id]) !!}" class="btn btn-primary btn-xs"><span class="fa fa-pencil"></span></a>
                            @endif
                        @endif
                    </div>
                    <div class="col-xs-2 text-right">
                        <a href="{!! route('getProductCategory', ['id'=>$event->category_id, 'slug'=>'back']) !!}" class="btn btn-default gallery_back">
                            <span class="fa fa-arrow-left"></span>
                        </a>
                    </div>
                </div>
                <div>
                    @if($event-> event_description != null)
                    <p>{!! $event->event_description!!}</p>
                    <hr>
                    @endif
                        @if($event->code != null)
                            <h4>Code:</h4>
                            {!! $event-> code!!}
                            <hr>
                        @endif
                        @if($event->color != null)
                            <h4>Color:</h4>
                            {!! $event-> color!!}
                            <hr>
                        @endif
                        @if($event->mechanism != null)
                            <h4>Mechanism:</h4>
                            {!! $event-> mechanism!!}
                            <hr>
                        @endif
                        @if($event->size != null)
                            <h4>Size of the bracelet:</h4>
                            {!! $event-> size!!}
                            <hr>
                        @endif
                        @if($event->price != null || ($event->price_from != null &&$event->price_to != null))
                            <h4>Price:</h4>
                            @if($event->price!=null)
                            @foreach(explode(', ', $event->price) as $event_price)
                                {!! $event_price !!} {!! $event->currency !!} {!! $event->weight!=null ? $event->weight : '' !!}
                                {!! $loop->last ? '' : ', ' !!}
                            @endforeach
                                <br>
                            @endif
                            @if(($event->price_from != null &&$event->price_to != null))
                                From {!! $event->price_from !!} {!! $event->currency !!} {!! $event->weight!=null ? $event->weight : '' !!} to {!! $event->price_to !!} {!! $event->currency !!} {!! $event->weight!=null ? $event->weight : '' !!}
                                @endif
                            <hr>
                        @endif
                        @if($event->event_text != null)
                            {!! $event-> event_text!!}
                            <hr>
                        @endif
                </div>
            </div>
        @endif
    </section>
@endsection

@section('scripts')
    <script src="{!! url('fancybox/dist/jquery.fancybox.min.js') !!}"></script>
    <script type="text/javascript">
        $("[data-fancybox].working-process").fancybox({
            // Options will go here

        });

        $('#za_nas').click(function(){
            window.location.href ='{!! route('getHome') !!}#about-us';
        });
    </script>
@endsection